/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.data;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.grid.data.RequestId;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.TypeToken;

public class SessionRequestCapability {
    private static final Type SET_OF_CAPABILITIES = new TypeToken<Set<Capabilities>>(){}.getType();
    private final RequestId requestId;
    private final Set<Capabilities> desiredCapabilities;

    public SessionRequestCapability(RequestId requestId, Set<Capabilities> desiredCapabilities) {
        this.requestId = (RequestId)Require.nonNull((String)"Request ID", (Object)requestId);
        this.desiredCapabilities = Collections.unmodifiableSet(new LinkedHashSet((Collection)Require.nonNull((String)"Capabilities", desiredCapabilities)));
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public Set<Capabilities> getDesiredCapabilities() {
        return this.desiredCapabilities;
    }

    public String toString() {
        return new StringJoiner(", ", SessionRequestCapability.class.getSimpleName() + "[", "]").add("requestId=" + this.requestId).add("desiredCapabilities=" + this.desiredCapabilities).toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof SessionRequestCapability)) {
            return false;
        }
        SessionRequestCapability that = (SessionRequestCapability)o;
        return this.requestId.equals(that.requestId) && this.desiredCapabilities.equals(that.desiredCapabilities);
    }

    public int hashCode() {
        return Objects.hash(this.requestId, this.desiredCapabilities);
    }

    private Map<String, Object> toJson() {
        HashMap<String, Object> toReturn = new HashMap<String, Object>();
        toReturn.put("requestId", this.requestId);
        toReturn.put("capabilities", this.desiredCapabilities);
        return Collections.unmodifiableMap(toReturn);
    }

    private static SessionRequestCapability fromJson(JsonInput input) {
        RequestId id = null;
        Set capabilities = null;
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "capabilities": {
                    capabilities = (Set)input.read(SET_OF_CAPABILITIES);
                    continue block8;
                }
                case "requestId": {
                    id = (RequestId)input.read(RequestId.class);
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new SessionRequestCapability(id, capabilities);
    }
}

