/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.commands;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.cli.CliCommand;
import org.openqa.selenium.events.Event;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.events.EventListener;
import org.openqa.selenium.events.EventName;
import org.openqa.selenium.grid.TemplateGridCommand;
import org.openqa.selenium.grid.config.CompoundConfig;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.MapConfig;
import org.openqa.selenium.grid.config.MemoizedConfig;
import org.openqa.selenium.grid.config.Role;
import org.openqa.selenium.grid.config.StandardGridRoles;
import org.openqa.selenium.grid.server.BaseServerOptions;
import org.openqa.selenium.grid.server.EventBusOptions;
import org.openqa.selenium.grid.server.Server;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.netty.server.NettyServer;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Routable;
import org.openqa.selenium.remote.http.Route;

@AutoService(value={CliCommand.class})
public class EventBusCommand
extends TemplateGridCommand {
    private static final Logger LOG = Logger.getLogger(EventBusCommand.class.getName());

    @Override
    public String getName() {
        return "event-bus";
    }

    @Override
    public String getDescription() {
        return "Standalone instance of the event bus.";
    }

    @Override
    public Set<Role> getConfigurableRoles() {
        return ImmutableSet.of((Object)StandardGridRoles.EVENT_BUS_ROLE, (Object)StandardGridRoles.HTTPD_ROLE);
    }

    @Override
    public boolean isShown() {
        return false;
    }

    @Override
    public Set<Object> getFlagObjects() {
        return Collections.emptySet();
    }

    @Override
    protected String getSystemPropertiesConfigPrefix() {
        return "selenium";
    }

    @Override
    protected Config getDefaultConfig() {
        return new MapConfig((Map)ImmutableMap.of((Object)"events", (Object)ImmutableMap.of((Object)"bind", (Object)true, (Object)"publish", (Object)"tcp://*:4442", (Object)"subscribe", (Object)"tcp://*:4443"), (Object)"server", (Object)ImmutableMap.of((Object)"port", (Object)5557)));
    }

    public Server<?> asServer(Config initialConfig) {
        Require.nonNull((String)"Config", (Object)initialConfig);
        MemoizedConfig config = new MemoizedConfig((Config)new CompoundConfig(new Config[]{initialConfig, this.getDefaultConfig()}));
        EventBusOptions events = new EventBusOptions((Config)config);
        EventBus bus = events.getEventBus();
        BaseServerOptions serverOptions = new BaseServerOptions((Config)config);
        return new NettyServer(serverOptions, (HttpHandler)Route.combine((Routable)Route.get((String)"/status").to(() -> req -> {
            CountDownLatch latch = new CountDownLatch(1);
            EventName healthCheck = new EventName("healthcheck");
            bus.addListener(new EventListener<Object>(healthCheck, (Type)((Object)Object.class), obj -> latch.countDown()));
            bus.fire(new Event(healthCheck, "ping"));
            try {
                if (latch.await(5L, TimeUnit.SECONDS)) {
                    return this.httpResponse(true, "Event bus running");
                }
                return this.httpResponse(false, "Event bus could not deliver a test message in 5 seconds");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return this.httpResponse(false, "Status checking was interrupted");
            }
        }), (Routable[])new Routable[]{Route.get((String)"/readyz").to(() -> req -> new HttpResponse().setStatus(204))}));
    }

    @Override
    protected void execute(Config config) {
        Require.nonNull((String)"Config", (Object)config);
        Server<?> server = this.asServer(config);
        server.start();
        BuildInfo info = new BuildInfo();
        LOG.info(String.format("Started Selenium EventBus %s (revision %s): %s", info.getReleaseLabel(), info.getBuildRevision(), server.getUrl()));
    }

    private HttpResponse httpResponse(boolean ready, String message) {
        return (HttpResponse)((HttpResponse)new HttpResponse().addHeader("Content-Type", "application/json; charset=utf-8")).setContent(Contents.asJson((Object)ImmutableMap.of((Object)"value", (Object)ImmutableMap.of((Object)"ready", (Object)ready, (Object)"message", (Object)message))));
    }
}

