/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.events.local;

import com.google.common.eventbus.Subscribe;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.openqa.selenium.events.Event;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.events.EventListener;
import org.openqa.selenium.events.EventName;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.internal.Require;

public class GuavaEventBus
implements EventBus {
    private final com.google.common.eventbus.EventBus guavaBus;
    private final List<Listener> allListeners = new LinkedList<Listener>();

    public GuavaEventBus() {
        this.guavaBus = new com.google.common.eventbus.EventBus();
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public void addListener(EventListener<?> listener) {
        Require.nonNull((String)"Listener", listener);
        Listener guavaListener = new Listener(listener.getEventName(), listener);
        this.allListeners.add(guavaListener);
        this.guavaBus.register((Object)guavaListener);
    }

    @Override
    public void fire(Event event) {
        this.guavaBus.post(Require.nonNull((String)"Event", (Object)event));
    }

    @Override
    public void close() {
        this.allListeners.forEach(arg_0 -> ((com.google.common.eventbus.EventBus)this.guavaBus).unregister(arg_0));
        this.allListeners.clear();
    }

    public static GuavaEventBus create(Config config) {
        return new GuavaEventBus();
    }

    private static class Listener {
        private final EventName eventName;
        private final Consumer<Event> onType;

        public Listener(EventName eventName, Consumer<Event> onType) {
            this.eventName = (EventName)Require.nonNull((String)"Event type", (Object)eventName);
            this.onType = (Consumer)Require.nonNull((String)"Event listener", onType);
        }

        @Subscribe
        public void handle(Event event) {
            if (this.eventName.equals(event.getType())) {
                this.onType.accept(event);
            }
        }
    }
}

