package org.openqa.selenium.devtools.v95.performancetimeline.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public class LayoutShiftAttribution {

    private final org.openqa.selenium.devtools.v95.dom.model.Rect previousRect;

    private final org.openqa.selenium.devtools.v95.dom.model.Rect currentRect;

    private final java.util.Optional<org.openqa.selenium.devtools.v95.dom.model.BackendNodeId> nodeId;

    public LayoutShiftAttribution(org.openqa.selenium.devtools.v95.dom.model.Rect previousRect, org.openqa.selenium.devtools.v95.dom.model.Rect currentRect, java.util.Optional<org.openqa.selenium.devtools.v95.dom.model.BackendNodeId> nodeId) {
        this.previousRect = java.util.Objects.requireNonNull(previousRect, "previousRect is required");
        this.currentRect = java.util.Objects.requireNonNull(currentRect, "currentRect is required");
        this.nodeId = nodeId;
    }

    public org.openqa.selenium.devtools.v95.dom.model.Rect getPreviousRect() {
        return previousRect;
    }

    public org.openqa.selenium.devtools.v95.dom.model.Rect getCurrentRect() {
        return currentRect;
    }

    public java.util.Optional<org.openqa.selenium.devtools.v95.dom.model.BackendNodeId> getNodeId() {
        return nodeId;
    }

    private static LayoutShiftAttribution fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v95.dom.model.Rect previousRect = null;
        org.openqa.selenium.devtools.v95.dom.model.Rect currentRect = null;
        java.util.Optional<org.openqa.selenium.devtools.v95.dom.model.BackendNodeId> nodeId = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "previousRect":
                    previousRect = input.read(org.openqa.selenium.devtools.v95.dom.model.Rect.class);
                    break;
                case "currentRect":
                    currentRect = input.read(org.openqa.selenium.devtools.v95.dom.model.Rect.class);
                    break;
                case "nodeId":
                    nodeId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v95.dom.model.BackendNodeId.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new LayoutShiftAttribution(previousRect, currentRect, nodeId);
    }
}
