/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v85.emulation.model;

import java.util.Arrays;
import java.util.Objects;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public class ScreenOrientation {
    private final Type type;
    private final Integer angle;

    public ScreenOrientation(Type type, Integer angle) {
        this.type = Objects.requireNonNull(type, "type is required");
        this.angle = Objects.requireNonNull(angle, "angle is required");
    }

    public Type getType() {
        return this.type;
    }

    public Integer getAngle() {
        return this.angle;
    }

    private static ScreenOrientation fromJson(JsonInput input) {
        Type type = null;
        Integer angle = 0;
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "type": {
                    type = Type.fromString(input.nextString());
                    continue block8;
                }
                case "angle": {
                    angle = input.nextNumber().intValue();
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ScreenOrientation(type, angle);
    }

    public static enum Type {
        PORTRAITPRIMARY("portraitPrimary"),
        PORTRAITSECONDARY("portraitSecondary"),
        LANDSCAPEPRIMARY("landscapePrimary"),
        LANDSCAPESECONDARY("landscapeSecondary");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public static Type fromString(String s) {
            return Arrays.stream(Type.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within Type "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Type fromJson(JsonInput input) {
            return Type.fromString(input.nextString());
        }
    }
}

