package org.openqa.selenium.devtools.v142.storage.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * A shared storage run or selectURL operation finished its execution.
 * The following parameters are included in all events.
 */
public class SharedStorageWorkletOperationExecutionFinished {

    private final org.openqa.selenium.devtools.v142.network.model.TimeSinceEpoch finishedTime;

    private final java.lang.Integer executionTime;

    private final org.openqa.selenium.devtools.v142.storage.model.SharedStorageAccessMethod method;

    private final java.lang.String operationId;

    private final org.openqa.selenium.devtools.v142.target.model.TargetID workletTargetId;

    private final org.openqa.selenium.devtools.v142.page.model.FrameId mainFrameId;

    private final java.lang.String ownerOrigin;

    public SharedStorageWorkletOperationExecutionFinished(org.openqa.selenium.devtools.v142.network.model.TimeSinceEpoch finishedTime, java.lang.Integer executionTime, org.openqa.selenium.devtools.v142.storage.model.SharedStorageAccessMethod method, java.lang.String operationId, org.openqa.selenium.devtools.v142.target.model.TargetID workletTargetId, org.openqa.selenium.devtools.v142.page.model.FrameId mainFrameId, java.lang.String ownerOrigin) {
        this.finishedTime = java.util.Objects.requireNonNull(finishedTime, "finishedTime is required");
        this.executionTime = java.util.Objects.requireNonNull(executionTime, "executionTime is required");
        this.method = java.util.Objects.requireNonNull(method, "method is required");
        this.operationId = java.util.Objects.requireNonNull(operationId, "operationId is required");
        this.workletTargetId = java.util.Objects.requireNonNull(workletTargetId, "workletTargetId is required");
        this.mainFrameId = java.util.Objects.requireNonNull(mainFrameId, "mainFrameId is required");
        this.ownerOrigin = java.util.Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
    }

    /**
     * Time that the operation finished.
     */
    public org.openqa.selenium.devtools.v142.network.model.TimeSinceEpoch getFinishedTime() {
        return finishedTime;
    }

    /**
     * Time, in microseconds, from start of shared storage JS API call until
     * end of operation execution in the worklet.
     */
    public java.lang.Integer getExecutionTime() {
        return executionTime;
    }

    /**
     * Enum value indicating the Shared Storage API method invoked.
     */
    public org.openqa.selenium.devtools.v142.storage.model.SharedStorageAccessMethod getMethod() {
        return method;
    }

    /**
     * ID of the operation call.
     */
    public java.lang.String getOperationId() {
        return operationId;
    }

    /**
     * Hex representation of the DevTools token used as the TargetID for the
     * associated shared storage worklet.
     */
    public org.openqa.selenium.devtools.v142.target.model.TargetID getWorkletTargetId() {
        return workletTargetId;
    }

    /**
     * DevTools Frame Token for the primary frame tree's root.
     */
    public org.openqa.selenium.devtools.v142.page.model.FrameId getMainFrameId() {
        return mainFrameId;
    }

    /**
     * Serialization of the origin owning the Shared Storage data.
     */
    public java.lang.String getOwnerOrigin() {
        return ownerOrigin;
    }

    private static SharedStorageWorkletOperationExecutionFinished fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v142.network.model.TimeSinceEpoch finishedTime = null;
        java.lang.Integer executionTime = 0;
        org.openqa.selenium.devtools.v142.storage.model.SharedStorageAccessMethod method = null;
        java.lang.String operationId = null;
        org.openqa.selenium.devtools.v142.target.model.TargetID workletTargetId = null;
        org.openqa.selenium.devtools.v142.page.model.FrameId mainFrameId = null;
        java.lang.String ownerOrigin = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "finishedTime":
                    finishedTime = input.read(org.openqa.selenium.devtools.v142.network.model.TimeSinceEpoch.class);
                    break;
                case "executionTime":
                    executionTime = input.nextNumber().intValue();
                    break;
                case "method":
                    method = input.read(org.openqa.selenium.devtools.v142.storage.model.SharedStorageAccessMethod.class);
                    break;
                case "operationId":
                    operationId = input.nextString();
                    break;
                case "workletTargetId":
                    workletTargetId = input.read(org.openqa.selenium.devtools.v142.target.model.TargetID.class);
                    break;
                case "mainFrameId":
                    mainFrameId = input.read(org.openqa.selenium.devtools.v142.page.model.FrameId.class);
                    break;
                case "ownerOrigin":
                    ownerOrigin = input.nextString();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new SharedStorageWorkletOperationExecutionFinished(finishedTime, executionTime, method, operationId, workletTargetId, mainFrameId, ownerOrigin);
    }
}
