package org.openqa.selenium.devtools.v140.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired when direct_socket.UDPSocket is closed.
 */
@org.openqa.selenium.Beta()
public class DirectUDPSocketClosed {

    private final org.openqa.selenium.devtools.v140.network.model.RequestId identifier;

    private final org.openqa.selenium.devtools.v140.network.model.MonotonicTime timestamp;

    public DirectUDPSocketClosed(org.openqa.selenium.devtools.v140.network.model.RequestId identifier, org.openqa.selenium.devtools.v140.network.model.MonotonicTime timestamp) {
        this.identifier = java.util.Objects.requireNonNull(identifier, "identifier is required");
        this.timestamp = java.util.Objects.requireNonNull(timestamp, "timestamp is required");
    }

    public org.openqa.selenium.devtools.v140.network.model.RequestId getIdentifier() {
        return identifier;
    }

    public org.openqa.selenium.devtools.v140.network.model.MonotonicTime getTimestamp() {
        return timestamp;
    }

    private static DirectUDPSocketClosed fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v140.network.model.RequestId identifier = null;
        org.openqa.selenium.devtools.v140.network.model.MonotonicTime timestamp = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "identifier":
                    identifier = input.read(org.openqa.selenium.devtools.v140.network.model.RequestId.class);
                    break;
                case "timestamp":
                    timestamp = input.read(org.openqa.selenium.devtools.v140.network.model.MonotonicTime.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new DirectUDPSocketClosed(identifier, timestamp);
    }
}
