/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v131.security;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v131.security.model.CertificateError;
import org.openqa.selenium.devtools.v131.security.model.CertificateErrorAction;
import org.openqa.selenium.devtools.v131.security.model.SecurityStateChanged;
import org.openqa.selenium.devtools.v131.security.model.VisibleSecurityState;

public class Security {
    public static Command<Void> disable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Security.disable", Map.copyOf(params));
    }

    public static Command<Void> enable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Security.enable", Map.copyOf(params));
    }

    public static Command<Void> setIgnoreCertificateErrors(Boolean ignore) {
        Objects.requireNonNull(ignore, "ignore is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("ignore", ignore);
        return new Command("Security.setIgnoreCertificateErrors", Map.copyOf(params));
    }

    @Deprecated
    public static Command<Void> handleCertificateError(Integer eventId, CertificateErrorAction action) {
        Objects.requireNonNull(eventId, "eventId is required");
        Objects.requireNonNull(action, "action is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("eventId", eventId);
        params.put("action", (Object)action);
        return new Command("Security.handleCertificateError", Map.copyOf(params));
    }

    @Deprecated
    public static Command<Void> setOverrideCertificateErrors(Boolean override) {
        Objects.requireNonNull(override, "override is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("override", override);
        return new Command("Security.setOverrideCertificateErrors", Map.copyOf(params));
    }

    public static Event<CertificateError> certificateError() {
        return new Event("Security.certificateError", input -> (CertificateError)input.read(CertificateError.class));
    }

    public static Event<VisibleSecurityState> visibleSecurityStateChanged() {
        return new Event("Security.visibleSecurityStateChanged", ConverterFunctions.map((String)"visibleSecurityState", VisibleSecurityState.class));
    }

    public static Event<SecurityStateChanged> securityStateChanged() {
        return new Event("Security.securityStateChanged", input -> (SecurityStateChanged)input.read(SecurityStateChanged.class));
    }
}

