/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v131.runtime;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v131.runtime.model.BindingCalled;
import org.openqa.selenium.devtools.v131.runtime.model.CallArgument;
import org.openqa.selenium.devtools.v131.runtime.model.ConsoleAPICalled;
import org.openqa.selenium.devtools.v131.runtime.model.ExceptionDetails;
import org.openqa.selenium.devtools.v131.runtime.model.ExceptionRevoked;
import org.openqa.selenium.devtools.v131.runtime.model.ExceptionThrown;
import org.openqa.selenium.devtools.v131.runtime.model.ExecutionContextDescription;
import org.openqa.selenium.devtools.v131.runtime.model.ExecutionContextDestroyed;
import org.openqa.selenium.devtools.v131.runtime.model.ExecutionContextId;
import org.openqa.selenium.devtools.v131.runtime.model.InspectRequested;
import org.openqa.selenium.devtools.v131.runtime.model.InternalPropertyDescriptor;
import org.openqa.selenium.devtools.v131.runtime.model.PrivatePropertyDescriptor;
import org.openqa.selenium.devtools.v131.runtime.model.PropertyDescriptor;
import org.openqa.selenium.devtools.v131.runtime.model.RemoteObject;
import org.openqa.selenium.devtools.v131.runtime.model.RemoteObjectId;
import org.openqa.selenium.devtools.v131.runtime.model.ScriptId;
import org.openqa.selenium.devtools.v131.runtime.model.SerializationOptions;
import org.openqa.selenium.devtools.v131.runtime.model.TimeDelta;
import org.openqa.selenium.json.JsonInput;

public class Runtime {
    public static Command<AwaitPromiseResponse> awaitPromise(RemoteObjectId promiseObjectId, Optional<Boolean> returnByValue, Optional<Boolean> generatePreview) {
        Objects.requireNonNull(promiseObjectId, "promiseObjectId is required");
        LinkedHashMap<String, RemoteObjectId> params = new LinkedHashMap<String, RemoteObjectId>();
        params.put("promiseObjectId", promiseObjectId);
        returnByValue.ifPresent(p -> params.put("returnByValue", (RemoteObjectId)p));
        generatePreview.ifPresent(p -> params.put("generatePreview", (RemoteObjectId)p));
        return new Command("Runtime.awaitPromise", Map.copyOf(params), input -> (AwaitPromiseResponse)input.read(AwaitPromiseResponse.class));
    }

    public static Command<CallFunctionOnResponse> callFunctionOn(String functionDeclaration, Optional<RemoteObjectId> objectId, Optional<List<CallArgument>> arguments, Optional<Boolean> silent, Optional<Boolean> returnByValue, Optional<Boolean> generatePreview, Optional<Boolean> userGesture, Optional<Boolean> awaitPromise, Optional<ExecutionContextId> executionContextId, Optional<String> objectGroup, Optional<Boolean> throwOnSideEffect, Optional<String> uniqueContextId, Optional<SerializationOptions> serializationOptions) {
        Objects.requireNonNull(functionDeclaration, "functionDeclaration is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("functionDeclaration", functionDeclaration);
        objectId.ifPresent(p -> params.put("objectId", (String)p));
        arguments.ifPresent(p -> params.put("arguments", (String)p));
        silent.ifPresent(p -> params.put("silent", (String)p));
        returnByValue.ifPresent(p -> params.put("returnByValue", (String)p));
        generatePreview.ifPresent(p -> params.put("generatePreview", (String)p));
        userGesture.ifPresent(p -> params.put("userGesture", (String)p));
        awaitPromise.ifPresent(p -> params.put("awaitPromise", (String)p));
        executionContextId.ifPresent(p -> params.put("executionContextId", (String)p));
        objectGroup.ifPresent(p -> params.put("objectGroup", (String)p));
        throwOnSideEffect.ifPresent(p -> params.put("throwOnSideEffect", (String)p));
        uniqueContextId.ifPresent(p -> params.put("uniqueContextId", (String)p));
        serializationOptions.ifPresent(p -> params.put("serializationOptions", (String)p));
        return new Command("Runtime.callFunctionOn", Map.copyOf(params), input -> (CallFunctionOnResponse)input.read(CallFunctionOnResponse.class));
    }

    public static Command<CompileScriptResponse> compileScript(String expression, String sourceURL, Boolean persistScript, Optional<ExecutionContextId> executionContextId) {
        Objects.requireNonNull(expression, "expression is required");
        Objects.requireNonNull(sourceURL, "sourceURL is required");
        Objects.requireNonNull(persistScript, "persistScript is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("expression", expression);
        params.put("sourceURL", sourceURL);
        params.put("persistScript", persistScript);
        executionContextId.ifPresent(p -> params.put("executionContextId", p));
        return new Command("Runtime.compileScript", Map.copyOf(params), input -> (CompileScriptResponse)input.read(CompileScriptResponse.class));
    }

    public static Command<Void> disable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Runtime.disable", Map.copyOf(params));
    }

    public static Command<Void> discardConsoleEntries() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Runtime.discardConsoleEntries", Map.copyOf(params));
    }

    public static Command<Void> enable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Runtime.enable", Map.copyOf(params));
    }

    public static Command<EvaluateResponse> evaluate(String expression, Optional<String> objectGroup, Optional<Boolean> includeCommandLineAPI, Optional<Boolean> silent, Optional<ExecutionContextId> contextId, Optional<Boolean> returnByValue, Optional<Boolean> generatePreview, Optional<Boolean> userGesture, Optional<Boolean> awaitPromise, Optional<Boolean> throwOnSideEffect, Optional<TimeDelta> timeout, Optional<Boolean> disableBreaks, Optional<Boolean> replMode, Optional<Boolean> allowUnsafeEvalBlockedByCSP, Optional<String> uniqueContextId, Optional<SerializationOptions> serializationOptions) {
        Objects.requireNonNull(expression, "expression is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("expression", expression);
        objectGroup.ifPresent(p -> params.put("objectGroup", (String)p));
        includeCommandLineAPI.ifPresent(p -> params.put("includeCommandLineAPI", (String)p));
        silent.ifPresent(p -> params.put("silent", (String)p));
        contextId.ifPresent(p -> params.put("contextId", (String)p));
        returnByValue.ifPresent(p -> params.put("returnByValue", (String)p));
        generatePreview.ifPresent(p -> params.put("generatePreview", (String)p));
        userGesture.ifPresent(p -> params.put("userGesture", (String)p));
        awaitPromise.ifPresent(p -> params.put("awaitPromise", (String)p));
        throwOnSideEffect.ifPresent(p -> params.put("throwOnSideEffect", (String)p));
        timeout.ifPresent(p -> params.put("timeout", (String)p));
        disableBreaks.ifPresent(p -> params.put("disableBreaks", (String)p));
        replMode.ifPresent(p -> params.put("replMode", (String)p));
        allowUnsafeEvalBlockedByCSP.ifPresent(p -> params.put("allowUnsafeEvalBlockedByCSP", (String)p));
        uniqueContextId.ifPresent(p -> params.put("uniqueContextId", (String)p));
        serializationOptions.ifPresent(p -> params.put("serializationOptions", (String)p));
        return new Command("Runtime.evaluate", Map.copyOf(params), input -> (EvaluateResponse)input.read(EvaluateResponse.class));
    }

    @Beta
    public static Command<String> getIsolateId() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Runtime.getIsolateId", Map.copyOf(params), ConverterFunctions.map((String)"id", String.class));
    }

    @Beta
    public static Command<GetHeapUsageResponse> getHeapUsage() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Runtime.getHeapUsage", Map.copyOf(params), input -> (GetHeapUsageResponse)input.read(GetHeapUsageResponse.class));
    }

    public static Command<GetPropertiesResponse> getProperties(RemoteObjectId objectId, Optional<Boolean> ownProperties, Optional<Boolean> accessorPropertiesOnly, Optional<Boolean> generatePreview, Optional<Boolean> nonIndexedPropertiesOnly) {
        Objects.requireNonNull(objectId, "objectId is required");
        LinkedHashMap<String, RemoteObjectId> params = new LinkedHashMap<String, RemoteObjectId>();
        params.put("objectId", objectId);
        ownProperties.ifPresent(p -> params.put("ownProperties", (RemoteObjectId)p));
        accessorPropertiesOnly.ifPresent(p -> params.put("accessorPropertiesOnly", (RemoteObjectId)p));
        generatePreview.ifPresent(p -> params.put("generatePreview", (RemoteObjectId)p));
        nonIndexedPropertiesOnly.ifPresent(p -> params.put("nonIndexedPropertiesOnly", (RemoteObjectId)p));
        return new Command("Runtime.getProperties", Map.copyOf(params), input -> (GetPropertiesResponse)input.read(GetPropertiesResponse.class));
    }

    public static Command<List<String>> globalLexicalScopeNames(Optional<ExecutionContextId> executionContextId) {
        LinkedHashMap params = new LinkedHashMap();
        executionContextId.ifPresent(p -> params.put("executionContextId", p));
        return new Command("Runtime.globalLexicalScopeNames", Map.copyOf(params), ConverterFunctions.map((String)"names", input -> input.readArray(String.class)));
    }

    public static Command<RemoteObject> queryObjects(RemoteObjectId prototypeObjectId, Optional<String> objectGroup) {
        Objects.requireNonNull(prototypeObjectId, "prototypeObjectId is required");
        LinkedHashMap<String, RemoteObjectId> params = new LinkedHashMap<String, RemoteObjectId>();
        params.put("prototypeObjectId", prototypeObjectId);
        objectGroup.ifPresent(p -> params.put("objectGroup", (RemoteObjectId)p));
        return new Command("Runtime.queryObjects", Map.copyOf(params), ConverterFunctions.map((String)"objects", RemoteObject.class));
    }

    public static Command<Void> releaseObject(RemoteObjectId objectId) {
        Objects.requireNonNull(objectId, "objectId is required");
        LinkedHashMap<String, RemoteObjectId> params = new LinkedHashMap<String, RemoteObjectId>();
        params.put("objectId", objectId);
        return new Command("Runtime.releaseObject", Map.copyOf(params));
    }

    public static Command<Void> releaseObjectGroup(String objectGroup) {
        Objects.requireNonNull(objectGroup, "objectGroup is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("objectGroup", objectGroup);
        return new Command("Runtime.releaseObjectGroup", Map.copyOf(params));
    }

    public static Command<Void> runIfWaitingForDebugger() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Runtime.runIfWaitingForDebugger", Map.copyOf(params));
    }

    public static Command<RunScriptResponse> runScript(ScriptId scriptId, Optional<ExecutionContextId> executionContextId, Optional<String> objectGroup, Optional<Boolean> silent, Optional<Boolean> includeCommandLineAPI, Optional<Boolean> returnByValue, Optional<Boolean> generatePreview, Optional<Boolean> awaitPromise) {
        Objects.requireNonNull(scriptId, "scriptId is required");
        LinkedHashMap<String, ScriptId> params = new LinkedHashMap<String, ScriptId>();
        params.put("scriptId", scriptId);
        executionContextId.ifPresent(p -> params.put("executionContextId", (ScriptId)p));
        objectGroup.ifPresent(p -> params.put("objectGroup", (ScriptId)p));
        silent.ifPresent(p -> params.put("silent", (ScriptId)p));
        includeCommandLineAPI.ifPresent(p -> params.put("includeCommandLineAPI", (ScriptId)p));
        returnByValue.ifPresent(p -> params.put("returnByValue", (ScriptId)p));
        generatePreview.ifPresent(p -> params.put("generatePreview", (ScriptId)p));
        awaitPromise.ifPresent(p -> params.put("awaitPromise", (ScriptId)p));
        return new Command("Runtime.runScript", Map.copyOf(params), input -> (RunScriptResponse)input.read(RunScriptResponse.class));
    }

    public static Command<Void> setAsyncCallStackDepth(Integer maxDepth) {
        Objects.requireNonNull(maxDepth, "maxDepth is required");
        LinkedHashMap<String, Integer> params = new LinkedHashMap<String, Integer>();
        params.put("maxDepth", maxDepth);
        return new Command("Runtime.setAsyncCallStackDepth", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setCustomObjectFormatterEnabled(Boolean enabled) {
        Objects.requireNonNull(enabled, "enabled is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("enabled", enabled);
        return new Command("Runtime.setCustomObjectFormatterEnabled", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setMaxCallStackSizeToCapture(Integer size) {
        Objects.requireNonNull(size, "size is required");
        LinkedHashMap<String, Integer> params = new LinkedHashMap<String, Integer>();
        params.put("size", size);
        return new Command("Runtime.setMaxCallStackSizeToCapture", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> terminateExecution() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Runtime.terminateExecution", Map.copyOf(params));
    }

    public static Command<Void> addBinding(String name, Optional<ExecutionContextId> executionContextId, Optional<String> executionContextName) {
        Objects.requireNonNull(name, "name is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("name", name);
        executionContextId.ifPresent(p -> params.put("executionContextId", (String)p));
        executionContextName.ifPresent(p -> params.put("executionContextName", (String)p));
        return new Command("Runtime.addBinding", Map.copyOf(params));
    }

    public static Command<Void> removeBinding(String name) {
        Objects.requireNonNull(name, "name is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("name", name);
        return new Command("Runtime.removeBinding", Map.copyOf(params));
    }

    @Beta
    public static Command<ExceptionDetails> getExceptionDetails(RemoteObjectId errorObjectId) {
        Objects.requireNonNull(errorObjectId, "errorObjectId is required");
        LinkedHashMap<String, RemoteObjectId> params = new LinkedHashMap<String, RemoteObjectId>();
        params.put("errorObjectId", errorObjectId);
        return new Command("Runtime.getExceptionDetails", Map.copyOf(params), ConverterFunctions.map((String)"exceptionDetails", ExceptionDetails.class));
    }

    public static Event<BindingCalled> bindingCalled() {
        return new Event("Runtime.bindingCalled", input -> (BindingCalled)input.read(BindingCalled.class));
    }

    public static Event<ConsoleAPICalled> consoleAPICalled() {
        return new Event("Runtime.consoleAPICalled", input -> (ConsoleAPICalled)input.read(ConsoleAPICalled.class));
    }

    public static Event<ExceptionRevoked> exceptionRevoked() {
        return new Event("Runtime.exceptionRevoked", input -> (ExceptionRevoked)input.read(ExceptionRevoked.class));
    }

    public static Event<ExceptionThrown> exceptionThrown() {
        return new Event("Runtime.exceptionThrown", input -> (ExceptionThrown)input.read(ExceptionThrown.class));
    }

    public static Event<ExecutionContextDescription> executionContextCreated() {
        return new Event("Runtime.executionContextCreated", ConverterFunctions.map((String)"context", ExecutionContextDescription.class));
    }

    public static Event<ExecutionContextDestroyed> executionContextDestroyed() {
        return new Event("Runtime.executionContextDestroyed", input -> (ExecutionContextDestroyed)input.read(ExecutionContextDestroyed.class));
    }

    public static Event<Void> executionContextsCleared() {
        return new Event("Runtime.executionContextsCleared", ConverterFunctions.empty());
    }

    public static Event<InspectRequested> inspectRequested() {
        return new Event("Runtime.inspectRequested", input -> (InspectRequested)input.read(InspectRequested.class));
    }

    public static class RunScriptResponse {
        private final RemoteObject result;
        private final Optional<ExceptionDetails> exceptionDetails;

        public RunScriptResponse(RemoteObject result, Optional<ExceptionDetails> exceptionDetails) {
            this.result = Objects.requireNonNull(result, "result is required");
            this.exceptionDetails = exceptionDetails;
        }

        public RemoteObject getResult() {
            return this.result;
        }

        public Optional<ExceptionDetails> getExceptionDetails() {
            return this.exceptionDetails;
        }

        private static RunScriptResponse fromJson(JsonInput input) {
            RemoteObject result = null;
            Optional<ExceptionDetails> exceptionDetails = Optional.empty();
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "result": {
                        result = (RemoteObject)input.read(RemoteObject.class);
                        continue block8;
                    }
                    case "exceptionDetails": {
                        exceptionDetails = Optional.ofNullable((ExceptionDetails)input.read(ExceptionDetails.class));
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new RunScriptResponse(result, exceptionDetails);
        }
    }

    public static class GetPropertiesResponse {
        private final List<PropertyDescriptor> result;
        private final Optional<List<InternalPropertyDescriptor>> internalProperties;
        private final Optional<List<PrivatePropertyDescriptor>> privateProperties;
        private final Optional<ExceptionDetails> exceptionDetails;

        public GetPropertiesResponse(List<PropertyDescriptor> result, Optional<List<InternalPropertyDescriptor>> internalProperties, Optional<List<PrivatePropertyDescriptor>> privateProperties, Optional<ExceptionDetails> exceptionDetails) {
            this.result = Objects.requireNonNull(result, "result is required");
            this.internalProperties = internalProperties;
            this.privateProperties = privateProperties;
            this.exceptionDetails = exceptionDetails;
        }

        public List<PropertyDescriptor> getResult() {
            return this.result;
        }

        public Optional<List<InternalPropertyDescriptor>> getInternalProperties() {
            return this.internalProperties;
        }

        public Optional<List<PrivatePropertyDescriptor>> getPrivateProperties() {
            return this.privateProperties;
        }

        public Optional<ExceptionDetails> getExceptionDetails() {
            return this.exceptionDetails;
        }

        private static GetPropertiesResponse fromJson(JsonInput input) {
            List result = null;
            Optional<List<InternalPropertyDescriptor>> internalProperties = Optional.empty();
            Optional<List<PrivatePropertyDescriptor>> privateProperties = Optional.empty();
            Optional<ExceptionDetails> exceptionDetails = Optional.empty();
            input.beginObject();
            block12: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "result": {
                        result = input.readArray(PropertyDescriptor.class);
                        continue block12;
                    }
                    case "internalProperties": {
                        internalProperties = Optional.ofNullable(input.readArray(InternalPropertyDescriptor.class));
                        continue block12;
                    }
                    case "privateProperties": {
                        privateProperties = Optional.ofNullable(input.readArray(PrivatePropertyDescriptor.class));
                        continue block12;
                    }
                    case "exceptionDetails": {
                        exceptionDetails = Optional.ofNullable((ExceptionDetails)input.read(ExceptionDetails.class));
                        continue block12;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetPropertiesResponse(result, internalProperties, privateProperties, exceptionDetails);
        }
    }

    public static class GetHeapUsageResponse {
        private final Number usedSize;
        private final Number totalSize;

        public GetHeapUsageResponse(Number usedSize, Number totalSize) {
            this.usedSize = Objects.requireNonNull(usedSize, "usedSize is required");
            this.totalSize = Objects.requireNonNull(totalSize, "totalSize is required");
        }

        public Number getUsedSize() {
            return this.usedSize;
        }

        public Number getTotalSize() {
            return this.totalSize;
        }

        private static GetHeapUsageResponse fromJson(JsonInput input) {
            Number usedSize = 0;
            Number totalSize = 0;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "usedSize": {
                        usedSize = input.nextNumber();
                        continue block8;
                    }
                    case "totalSize": {
                        totalSize = input.nextNumber();
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetHeapUsageResponse(usedSize, totalSize);
        }
    }

    public static class EvaluateResponse {
        private final RemoteObject result;
        private final Optional<ExceptionDetails> exceptionDetails;

        public EvaluateResponse(RemoteObject result, Optional<ExceptionDetails> exceptionDetails) {
            this.result = Objects.requireNonNull(result, "result is required");
            this.exceptionDetails = exceptionDetails;
        }

        public RemoteObject getResult() {
            return this.result;
        }

        public Optional<ExceptionDetails> getExceptionDetails() {
            return this.exceptionDetails;
        }

        private static EvaluateResponse fromJson(JsonInput input) {
            RemoteObject result = null;
            Optional<ExceptionDetails> exceptionDetails = Optional.empty();
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "result": {
                        result = (RemoteObject)input.read(RemoteObject.class);
                        continue block8;
                    }
                    case "exceptionDetails": {
                        exceptionDetails = Optional.ofNullable((ExceptionDetails)input.read(ExceptionDetails.class));
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new EvaluateResponse(result, exceptionDetails);
        }
    }

    public static class CompileScriptResponse {
        private final Optional<ScriptId> scriptId;
        private final Optional<ExceptionDetails> exceptionDetails;

        public CompileScriptResponse(Optional<ScriptId> scriptId, Optional<ExceptionDetails> exceptionDetails) {
            this.scriptId = scriptId;
            this.exceptionDetails = exceptionDetails;
        }

        public Optional<ScriptId> getScriptId() {
            return this.scriptId;
        }

        public Optional<ExceptionDetails> getExceptionDetails() {
            return this.exceptionDetails;
        }

        private static CompileScriptResponse fromJson(JsonInput input) {
            Optional<ScriptId> scriptId = Optional.empty();
            Optional<ExceptionDetails> exceptionDetails = Optional.empty();
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "scriptId": {
                        scriptId = Optional.ofNullable((ScriptId)input.read(ScriptId.class));
                        continue block8;
                    }
                    case "exceptionDetails": {
                        exceptionDetails = Optional.ofNullable((ExceptionDetails)input.read(ExceptionDetails.class));
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new CompileScriptResponse(scriptId, exceptionDetails);
        }
    }

    public static class CallFunctionOnResponse {
        private final RemoteObject result;
        private final Optional<ExceptionDetails> exceptionDetails;

        public CallFunctionOnResponse(RemoteObject result, Optional<ExceptionDetails> exceptionDetails) {
            this.result = Objects.requireNonNull(result, "result is required");
            this.exceptionDetails = exceptionDetails;
        }

        public RemoteObject getResult() {
            return this.result;
        }

        public Optional<ExceptionDetails> getExceptionDetails() {
            return this.exceptionDetails;
        }

        private static CallFunctionOnResponse fromJson(JsonInput input) {
            RemoteObject result = null;
            Optional<ExceptionDetails> exceptionDetails = Optional.empty();
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "result": {
                        result = (RemoteObject)input.read(RemoteObject.class);
                        continue block8;
                    }
                    case "exceptionDetails": {
                        exceptionDetails = Optional.ofNullable((ExceptionDetails)input.read(ExceptionDetails.class));
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new CallFunctionOnResponse(result, exceptionDetails);
        }
    }

    public static class AwaitPromiseResponse {
        private final RemoteObject result;
        private final Optional<ExceptionDetails> exceptionDetails;

        public AwaitPromiseResponse(RemoteObject result, Optional<ExceptionDetails> exceptionDetails) {
            this.result = Objects.requireNonNull(result, "result is required");
            this.exceptionDetails = exceptionDetails;
        }

        public RemoteObject getResult() {
            return this.result;
        }

        public Optional<ExceptionDetails> getExceptionDetails() {
            return this.exceptionDetails;
        }

        private static AwaitPromiseResponse fromJson(JsonInput input) {
            RemoteObject result = null;
            Optional<ExceptionDetails> exceptionDetails = Optional.empty();
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "result": {
                        result = (RemoteObject)input.read(RemoteObject.class);
                        continue block8;
                    }
                    case "exceptionDetails": {
                        exceptionDetails = Optional.ofNullable((ExceptionDetails)input.read(ExceptionDetails.class));
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new AwaitPromiseResponse(result, exceptionDetails);
        }
    }
}

