/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v131.overlay.model;

import java.util.Objects;
import org.openqa.selenium.json.JsonInput;

public class WindowControlsOverlayConfig {
    private final Boolean showCSS;
    private final String selectedPlatform;
    private final String themeColor;

    public WindowControlsOverlayConfig(Boolean showCSS, String selectedPlatform, String themeColor) {
        this.showCSS = Objects.requireNonNull(showCSS, "showCSS is required");
        this.selectedPlatform = Objects.requireNonNull(selectedPlatform, "selectedPlatform is required");
        this.themeColor = Objects.requireNonNull(themeColor, "themeColor is required");
    }

    public Boolean getShowCSS() {
        return this.showCSS;
    }

    public String getSelectedPlatform() {
        return this.selectedPlatform;
    }

    public String getThemeColor() {
        return this.themeColor;
    }

    private static WindowControlsOverlayConfig fromJson(JsonInput input) {
        Boolean showCSS = false;
        String selectedPlatform = null;
        String themeColor = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "showCSS": {
                    showCSS = input.nextBoolean();
                    continue block10;
                }
                case "selectedPlatform": {
                    selectedPlatform = input.nextString();
                    continue block10;
                }
                case "themeColor": {
                    themeColor = input.nextString();
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new WindowControlsOverlayConfig(showCSS, selectedPlatform, themeColor);
    }
}

