/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v114.network.model;

import java.util.Arrays;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

@Beta
public enum TrustTokenOperationType {
    ISSUANCE("Issuance"),
    REDEMPTION("Redemption"),
    SIGNING("Signing");

    private String value;

    private TrustTokenOperationType(String value) {
        this.value = value;
    }

    public static TrustTokenOperationType fromString(String s) {
        return Arrays.stream(TrustTokenOperationType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within TrustTokenOperationType "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static TrustTokenOperationType fromJson(JsonInput input) {
        return TrustTokenOperationType.fromString(input.nextString());
    }
}

