/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.interactions;

import java.time.Duration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.interactions.Encodable;
import org.openqa.selenium.interactions.InputSource;
import org.openqa.selenium.interactions.Interaction;
import org.openqa.selenium.interactions.Pause;

public class Sequence
implements Encodable {
    private final List<Encodable> actions = new LinkedList<Encodable>();
    private final InputSource device;

    public Sequence(InputSource device, int initialLength) {
        if (!(device instanceof Encodable)) {
            throw new IllegalArgumentException("Input device must implement Encodable: " + device);
        }
        this.device = device;
        for (int i = 0; i < initialLength; ++i) {
            this.addAction(new Pause(device, Duration.ZERO));
        }
    }

    public Sequence addAction(Interaction action) {
        if (!action.isValidFor(this.device.getInputType())) {
            throw new IllegalArgumentException(String.format("Interaction (%s) is for wrong kind of input device: %s ", action.getClass(), this.device));
        }
        if (!(action instanceof Encodable)) {
            throw new IllegalArgumentException("Interaction must implement Encodable: " + action);
        }
        this.actions.add((Encodable)((Object)action));
        return this;
    }

    @Override
    public Map<String, Object> encode() {
        HashMap<String, Object> toReturn = new HashMap<String, Object>(((Encodable)((Object)this.device)).encode());
        LinkedList<HashMap<String, Object>> encodedActions = new LinkedList<HashMap<String, Object>>();
        for (Encodable action : this.actions) {
            HashMap<String, Object> encodedAction = new HashMap<String, Object>(action.encode());
            encodedActions.add(encodedAction);
        }
        toReturn.put("actions", encodedActions);
        return toReturn;
    }

    public Map<String, Object> toJson() {
        return this.encode();
    }

    int size() {
        return this.actions.size();
    }
}

