/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.ScriptKey;

public class UnpinnedScriptKey
extends ScriptKey {
    private static final WeakHashMap<JavascriptExecutor, Set<UnpinnedScriptKey>> pinnedScripts = new WeakHashMap();
    private final String script;
    private String scriptId;
    private final String scriptHandle = UUID.randomUUID().toString().replace("-", "");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static UnpinnedScriptKey pin(JavascriptExecutor executor, String script) {
        UnpinnedScriptKey toReturn = new UnpinnedScriptKey(script);
        WeakHashMap<JavascriptExecutor, Set<UnpinnedScriptKey>> weakHashMap = pinnedScripts;
        synchronized (weakHashMap) {
            pinnedScripts.computeIfAbsent(executor, ignored -> new HashSet()).add(toReturn);
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unpin(JavascriptExecutor executor, UnpinnedScriptKey key) {
        WeakHashMap<JavascriptExecutor, Set<UnpinnedScriptKey>> weakHashMap = pinnedScripts;
        synchronized (weakHashMap) {
            ((Set)pinnedScripts.getOrDefault(executor, new HashSet())).remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Set<UnpinnedScriptKey> getPinnedScripts(JavascriptExecutor executor) {
        Set toReturn;
        WeakHashMap<JavascriptExecutor, Set<UnpinnedScriptKey>> weakHashMap = pinnedScripts;
        synchronized (weakHashMap) {
            toReturn = pinnedScripts.getOrDefault(executor, new HashSet());
        }
        return Collections.unmodifiableSet(toReturn);
    }

    public UnpinnedScriptKey(String script) {
        super(script);
        this.script = script;
    }

    public void setScriptId(String id) {
        this.scriptId = id;
    }

    public String getScriptId() {
        return this.scriptId;
    }

    public String getScript() {
        return this.script;
    }

    public String getScriptHandle() {
        return this.scriptHandle;
    }

    public String creationScript() {
        return String.format("function __webdriver_%s(arguments) { %s }", this.scriptHandle, this.script);
    }

    public String executionScript() {
        return String.format("return __webdriver_%s(arguments)", this.scriptHandle);
    }

    public String removalScript() {
        return String.format("__webdriver_%s = undefined", this.scriptHandle);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UnpinnedScriptKey that = (UnpinnedScriptKey)o;
        return Objects.equals(this.script, that.script);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.script);
    }
}

