/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.logging;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.openqa.selenium.logging.LogEntry;

public class LoggingHandler
extends Handler {
    private static final int MAX_RECORDS = 1000;
    private ArrayDeque<LogEntry> records = new ArrayDeque();
    private static final LoggingHandler INSTANCE = new LoggingHandler();

    private LoggingHandler() {
    }

    public static LoggingHandler getInstance() {
        return INSTANCE;
    }

    public synchronized Collection<LogEntry> getRecords() {
        return Collections.unmodifiableCollection(this.records);
    }

    @Override
    public synchronized void publish(LogRecord logRecord) {
        if (this.isLoggable(logRecord)) {
            if (this.records.size() > 1000) {
                this.records.remove();
            }
            this.records.add(new LogEntry(logRecord.getLevel(), logRecord.getMillis(), logRecord.getLoggerName() + " " + logRecord.getSourceClassName() + "." + logRecord.getSourceMethodName() + " " + logRecord.getMessage()));
        }
    }

    @Override
    public synchronized void flush() {
        this.records = new ArrayDeque();
    }

    @Override
    public synchronized void close() throws SecurityException {
        this.records.clear();
    }
}

