/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.platform;

import java.io.IOException;
import java.net.URL;
import org.scijava.Disposable;
import org.scijava.platform.PlatformService;
import org.scijava.plugin.SingletonPlugin;

public interface Platform
extends SingletonPlugin,
Disposable {
    default public String javaVendor() {
        return null;
    }

    default public String javaVersion() {
        return null;
    }

    default public String osArch() {
        return null;
    }

    default public String osName() {
        return null;
    }

    default public String osVersion() {
        return null;
    }

    default public boolean isTarget() {
        String osVersion;
        String osArch;
        String osName;
        String javaVersion;
        String javaVendor;
        if (this.javaVendor() != null && !(javaVendor = System.getProperty("java.vendor")).matches(".*" + this.javaVendor() + ".*")) {
            return false;
        }
        if (this.javaVersion() != null && (javaVersion = System.getProperty("java.version")).compareTo(this.javaVersion()) < 0) {
            return false;
        }
        if (this.osName() != null && !(osName = System.getProperty("os.name")).matches(".*" + this.osName() + ".*")) {
            return false;
        }
        if (this.osArch() != null && !(osArch = System.getProperty("os.arch")).matches(".*" + this.osArch() + ".*")) {
            return false;
        }
        return this.osVersion() == null || (osVersion = System.getProperty("os.version")).compareTo(this.osVersion()) >= 0;
    }

    public void configure(PlatformService var1);

    public void open(URL var1) throws IOException;

    default public boolean registerAppMenus(Object menus) {
        return false;
    }
}

