/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.xsbt;

import dotty.tools.dotc.util.SourceFile;
import dotty.tools.dotc.util.SourcePosition;
import dotty.tools.io.AbstractFile;
import dotty.tools.xsbt.ZincPlainFile;
import dotty.tools.xsbt.ZincVirtualFile;
import java.io.File;
import java.util.Optional;
import xsbti.Position;

public class PositionBridge
implements Position {
    private final SourcePosition pos;
    private final SourceFile src;
    public static final Position noPosition = new Position(){

        public Optional<File> sourceFile() {
            return Optional.empty();
        }

        public Optional<String> sourcePath() {
            return Optional.empty();
        }

        public Optional<Integer> line() {
            return Optional.empty();
        }

        public String lineContent() {
            return "";
        }

        public Optional<Integer> offset() {
            return Optional.empty();
        }

        public Optional<Integer> pointer() {
            return Optional.empty();
        }

        public Optional<String> pointerSpace() {
            return Optional.empty();
        }

        public String toString() {
            return "";
        }
    };

    public PositionBridge(SourcePosition sourcePosition, SourceFile sourceFile) {
        this.pos = sourcePosition;
        this.src = sourceFile;
    }

    public Optional<Integer> line() {
        if (this.src.content().length == 0) {
            return Optional.empty();
        }
        int n = this.pos.line();
        if (n == -1) {
            return Optional.empty();
        }
        return Optional.of(n + 1);
    }

    public String lineContent() {
        if (this.src.content().length == 0) {
            return "";
        }
        String string = this.pos.lineContent();
        if (string.endsWith("\r\n")) {
            return string.substring(0, string.length() - 2);
        }
        if (string.endsWith("\n") || string.endsWith("\f")) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    public Optional<Integer> offset() {
        return Optional.of(this.pos.point());
    }

    public Optional<String> sourcePath() {
        if (!this.src.exists()) {
            return Optional.empty();
        }
        AbstractFile abstractFile = this.pos.source().file();
        if (abstractFile instanceof ZincPlainFile) {
            return Optional.of(((ZincPlainFile)abstractFile).underlying().id());
        }
        if (abstractFile instanceof ZincVirtualFile) {
            return Optional.of(((ZincVirtualFile)abstractFile).underlying().id());
        }
        return Optional.of(abstractFile.path());
    }

    public Optional<File> sourceFile() {
        if (!this.src.exists()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.src.file().file());
    }

    public Optional<Integer> pointer() {
        if (this.src.content().length == 0) {
            return Optional.empty();
        }
        return Optional.of(this.pos.point() - this.src.startOfLine(this.pos.point()));
    }

    public Optional<String> pointerSpace() {
        if (!this.pointer().isPresent()) {
            return Optional.empty();
        }
        int n = Math.min(this.pointer().get(), this.lineContent().length());
        String string = this.lineContent();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(string.charAt(i) == '\t' ? (char)'\t' : ' ');
        }
        return Optional.of(stringBuilder.toString());
    }

    public String toString() {
        String string = this.sourcePath().orElse("");
        Optional<Integer> optional = this.line();
        Integer n = this.pointer().orElse(1);
        if (optional.isPresent()) {
            return String.format("%s:%d:%d", string, optional.get(), n);
        }
        return string;
    }

    public Optional<Integer> startOffset() {
        if (this.src.content().length == 0) {
            return Optional.empty();
        }
        return Optional.of(this.pos.start());
    }

    public Optional<Integer> endOffset() {
        if (this.src.content().length == 0) {
            return Optional.empty();
        }
        return Optional.of(this.pos.end());
    }

    public Optional<Integer> startLine() {
        if (this.src.content().length == 0) {
            return Optional.empty();
        }
        return Optional.of(this.pos.startLine() + 1);
    }

    public Optional<Integer> endLine() {
        if (this.src.content().length == 0) {
            return Optional.empty();
        }
        return Optional.of(this.pos.endLine() + 1);
    }

    public Optional<Integer> startColumn() {
        if (this.src.content().length == 0) {
            return Optional.empty();
        }
        return Optional.of(this.pos.startColumn());
    }

    public Optional<Integer> endColumn() {
        if (this.src.content().length == 0) {
            return Optional.empty();
        }
        return Optional.of(this.pos.endColumn());
    }
}

