/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.duration;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Ordered;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichDouble;

public abstract class Duration
implements Serializable,
Ordered<Duration> {
    public static Infinite Inf() {
        return Duration$.MODULE$.Inf();
    }

    public static Infinite MinusInf() {
        return Duration$.MODULE$.MinusInf();
    }

    public static Infinite Undefined() {
        return Duration$.MODULE$.Undefined();
    }

    public static FiniteDuration Zero() {
        return Duration$.MODULE$.Zero();
    }

    public static Duration apply(double d, TimeUnit timeUnit) {
        return Duration$.MODULE$.apply(d, timeUnit);
    }

    public static FiniteDuration apply(long l, String string2) {
        return Duration$.MODULE$.apply(l, string2);
    }

    public static FiniteDuration apply(long l, TimeUnit timeUnit) {
        return Duration$.MODULE$.apply(l, timeUnit);
    }

    public static Duration apply(String string2) {
        return Duration$.MODULE$.apply(string2);
    }

    public static Duration create(double d, TimeUnit timeUnit) {
        return Duration$.MODULE$.create(d, timeUnit);
    }

    public static FiniteDuration create(long l, String string2) {
        return Duration$.MODULE$.create(l, string2);
    }

    public static FiniteDuration create(long l, TimeUnit timeUnit) {
        return Duration$.MODULE$.create(l, timeUnit);
    }

    public static Duration create(String string2) {
        return Duration$.MODULE$.create(string2);
    }

    public static Duration fromNanos(double d) {
        return Duration$.MODULE$.fromNanos(d);
    }

    public static FiniteDuration fromNanos(long l) {
        return Duration$.MODULE$.fromNanos(l);
    }

    public static Option<Tuple2<Object, TimeUnit>> unapply(Duration duration) {
        return Duration$.MODULE$.unapply(duration);
    }

    public static Option<Tuple2<Object, TimeUnit>> unapply(String string2) {
        return Duration$.MODULE$.unapply(string2);
    }

    public Duration() {
        Ordered.$init$(this);
    }

    @Override
    public boolean $less(Object that) {
        return Ordered.$less$(this, that);
    }

    @Override
    public boolean $greater(Object that) {
        return Ordered.$greater$(this, that);
    }

    @Override
    public boolean $less$eq(Object that) {
        return Ordered.$less$eq$(this, that);
    }

    @Override
    public boolean $greater$eq(Object that) {
        return Ordered.$greater$eq$(this, that);
    }

    @Override
    public int compareTo(Object that) {
        return Ordered.compareTo$(this, that);
    }

    public abstract long length();

    public abstract TimeUnit unit();

    public abstract long toNanos();

    public abstract long toMicros();

    public abstract long toMillis();

    public abstract long toSeconds();

    public abstract long toMinutes();

    public abstract long toHours();

    public abstract long toDays();

    public abstract double toUnit(TimeUnit var1);

    public abstract Duration $plus(Duration var1);

    public abstract Duration $minus(Duration var1);

    public abstract Duration $times(double var1);

    public abstract Duration $div(double var1);

    public abstract double $div(Duration var1);

    public abstract Duration unary_$minus();

    public abstract boolean isFinite();

    public Duration min(Duration other) {
        if (this.$less(other)) {
            return this;
        }
        return other;
    }

    public Duration max(Duration other) {
        if (this.$greater(other)) {
            return this;
        }
        return other;
    }

    public Duration div(double divisor) {
        return this.$div(divisor);
    }

    public double div(Duration other) {
        return this.$div(other);
    }

    public boolean gt(Duration other) {
        return this.$greater(other);
    }

    public boolean gteq(Duration other) {
        return this.$greater$eq(other);
    }

    public boolean lt(Duration other) {
        return this.$less(other);
    }

    public boolean lteq(Duration other) {
        return this.$less$eq(other);
    }

    public Duration minus(Duration other) {
        return this.$minus(other);
    }

    public Duration mul(double factor) {
        return this.$times(factor);
    }

    public Duration neg() {
        return this.unary_$minus();
    }

    public Duration plus(Duration other) {
        return this.$plus(other);
    }

    public abstract Duration toCoarsest();

    public static abstract class Infinite
    extends Duration {
        @Override
        public Duration $plus(Duration other) {
            Infinite infinite;
            Infinite x;
            Duration duration = other;
            Duration x2 = duration;
            if (x2 == Duration$.MODULE$.Undefined()) {
                return Duration$.MODULE$.Undefined();
            }
            if (duration instanceof Infinite && (x = (infinite = (Infinite)duration)) != this) {
                return Duration$.MODULE$.Undefined();
            }
            return this;
        }

        @Override
        public Duration $minus(Duration other) {
            Infinite infinite;
            Infinite x;
            Duration duration = other;
            Duration x2 = duration;
            if (x2 == Duration$.MODULE$.Undefined()) {
                return Duration$.MODULE$.Undefined();
            }
            if (duration instanceof Infinite && (x = (infinite = (Infinite)duration)) == this) {
                return Duration$.MODULE$.Undefined();
            }
            return this;
        }

        @Override
        public Duration $times(double factor) {
            if (factor == 0.0 || Double.isNaN(factor)) {
                return Duration$.MODULE$.Undefined();
            }
            if (factor < 0.0) {
                return this.unary_$minus();
            }
            return this;
        }

        @Override
        public Duration $div(double divisor) {
            if (Double.isNaN(divisor) || Predef$.MODULE$.double2Double(divisor).isInfinite()) {
                return Duration$.MODULE$.Undefined();
            }
            if (new RichDouble(Predef$.MODULE$.doubleWrapper(divisor)).compare(BoxesRunTime.boxToDouble(0.0)) < 0) {
                return this.unary_$minus();
            }
            return this;
        }

        @Override
        public double $div(Duration divisor) {
            Duration duration = divisor;
            if (duration instanceof Infinite) {
                Infinite infinite = (Infinite)duration;
                return Double.NaN;
            }
            Duration x = duration;
            return Double.POSITIVE_INFINITY * (double)(this.$greater(Duration$.MODULE$.Zero()) ^ divisor.$greater$eq(Duration$.MODULE$.Zero()) ? -1 : 1);
        }

        @Override
        public final boolean isFinite() {
            return false;
        }

        private Nothing$ fail(String what) {
            throw new IllegalArgumentException(new StringBuilder(34).append(what).append(" not allowed on infinite Durations").toString());
        }

        @Override
        public final long length() {
            throw this.fail("length");
        }

        @Override
        public final TimeUnit unit() {
            throw this.fail("unit");
        }

        @Override
        public final long toNanos() {
            throw this.fail("toNanos");
        }

        @Override
        public final long toMicros() {
            throw this.fail("toMicros");
        }

        @Override
        public final long toMillis() {
            throw this.fail("toMillis");
        }

        @Override
        public final long toSeconds() {
            throw this.fail("toSeconds");
        }

        @Override
        public final long toMinutes() {
            throw this.fail("toMinutes");
        }

        @Override
        public final long toHours() {
            throw this.fail("toHours");
        }

        @Override
        public final long toDays() {
            throw this.fail("toDays");
        }

        @Override
        public final Duration toCoarsest() {
            return this;
        }
    }
}

