/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import java.io.Serializable;
import java.util.Arrays;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnce$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Growable;
import scala.collection.mutable.ReusableBuilder;
import scala.reflect.ClassTag;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;

public abstract class ArrayBuilder<T>
implements ReusableBuilder<T, Object>,
Serializable {
    private static final long serialVersionUID = 3L;
    private int capacity;
    private int size;

    public static <T> ArrayBuilder<T> make(ClassTag<T> classTag) {
        return ArrayBuilder$.MODULE$.make(classTag);
    }

    public ArrayBuilder() {
        Growable.$init$(this);
        Builder.$init$(this);
        this.capacity = 0;
        this.size = 0;
    }

    @Override
    public final Growable $plus$eq(Object elem) {
        return Growable.$plus$eq$(this, elem);
    }

    @Override
    public final Growable $plus$eq(Object elem1, Object elem2, Seq elems) {
        return Growable.$plus$eq$(this, elem1, elem2, elems);
    }

    @Override
    public final Growable $plus$plus$eq(IterableOnce elems) {
        return Growable.$plus$plus$eq$(this, elems);
    }

    @Override
    public final void sizeHint(IterableOnce<?> coll, int delta) {
        Builder.sizeHint$(this, coll, delta);
    }

    @Override
    public int sizeHint$default$2() {
        return Builder.sizeHint$default$2$(this);
    }

    @Override
    public final void sizeHintBounded(int size, Iterable<?> boundingColl) {
        Builder.sizeHintBounded$(this, size, boundingColl);
    }

    @Override
    public <NewTo> Builder<T, NewTo> mapResult(Function1<Object, NewTo> f) {
        return Builder.mapResult$(this, f);
    }

    public int capacity() {
        return this.capacity;
    }

    public void capacity_$eq(int x$1) {
        this.capacity = x$1;
    }

    public abstract Object elems();

    public int size() {
        return this.size;
    }

    public void size_$eq(int x$1) {
        this.size = x$1;
    }

    public int length() {
        return this.size();
    }

    @Override
    public int knownSize() {
        return this.size();
    }

    public final void ensureSize(int size) {
        int newLen = ArrayBuffer$.MODULE$.resizeUp(this.capacity(), size);
        if (newLen > 0) {
            this.resize(newLen);
            return;
        }
    }

    @Override
    public final void sizeHint(int size) {
        if (this.capacity() < size) {
            this.resize(size);
            return;
        }
    }

    @Override
    public void clear() {
        this.size_$eq(0);
    }

    public abstract void resize(int var1);

    public ArrayBuilder<T> addAll(Object xs) {
        return this.addAll(xs, 0, ScalaRunTime$.MODULE$.array_length(xs));
    }

    public ArrayBuilder<T> addAll(Object xs, int offset, int length) {
        int offset1 = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(offset), 0);
        int length1 = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(length), 0);
        int effectiveLength = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(length1), ScalaRunTime$.MODULE$.array_length(xs) - offset1);
        return this.doAddAll(xs, offset1, effectiveLength);
    }

    private ArrayBuilder<T> doAddAll(Object xs, int offset, int length) {
        if (length > 0) {
            this.ensureSize(this.size() + length);
            Object x$proxy1 = this.elems();
            if (x$proxy1 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            Array$.MODULE$.copy(xs, offset, x$proxy1, this.size(), length);
            this.size_$eq(this.size() + length);
        }
        return this;
    }

    @Override
    public ArrayBuilder<T> addAll(IterableOnce<T> xs) {
        int k = xs.knownSize();
        if (k > 0) {
            this.ensureSize(this.size() + k);
            Object x$proxy2 = this.elems();
            if (x$proxy2 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            int actual = IterableOnce$.MODULE$.copyElemsToArray(xs, x$proxy2, this.size(), IterableOnce$.MODULE$.copyElemsToArray$default$4());
            if (actual != k) {
                throw new IllegalStateException(new StringBuilder(11).append("Copied ").append(actual).append(" of ").append(k).toString());
            }
            this.size_$eq(this.size() + k);
        } else if (k < 0) {
            Growable.addAll$(this, xs);
        }
        return this;
    }

    public static class ofBoolean
    extends ArrayBuilder<Object> {
        private static final long serialVersionUID = 3L;
        private boolean[] elems = null;

        public boolean[] elems() {
            return this.elems;
        }

        public void elems_$eq(boolean[] x$1) {
            this.elems = x$1;
        }

        /*
         * WARNING - void declaration
         */
        private boolean[] mkArray(int size) {
            boolean[] newelems = new boolean[size];
            if (this.size() > 0) {
                void var3_3;
                boolean[] x$proxy30 = this.elems();
                if (x$proxy30 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                Array$.MODULE$.copy(var3_3, 0, newelems, 0, this.size());
            }
            return newelems;
        }

        @Override
        public void resize(int size) {
            this.elems_$eq(this.mkArray(size));
            this.capacity_$eq(size);
        }

        public ofBoolean addOne(boolean elem) {
            this.ensureSize(this.size() + 1);
            boolean[] x$proxy31 = this.elems();
            if (x$proxy31 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            x$proxy31[this.size()] = elem;
            this.size_$eq(this.size() + 1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean[] result() {
            if (this.capacity() != 0 && this.capacity() == this.size()) {
                void var2_1;
                this.capacity_$eq(0);
                boolean[] x$proxy32 = this.elems();
                if (x$proxy32 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                void res = var2_1;
                this.elems_$eq(null);
                return res;
            }
            return this.mkArray(this.size());
        }

        public boolean equals(Object other) {
            Object object = other;
            if (object instanceof ofBoolean) {
                ofBoolean ofBoolean2;
                ofBoolean x = ofBoolean2 = (ofBoolean)object;
                return this.size() == x.size() && this.elems() == x.elems();
            }
            return false;
        }

        public String toString() {
            return "ArrayBuilder.ofBoolean";
        }
    }

    public static final class ofByte
    extends ArrayBuilder<Object> {
        private static final long serialVersionUID = 3L;
        private byte[] elems = null;

        public byte[] elems() {
            return this.elems;
        }

        public void elems_$eq(byte[] x$1) {
            this.elems = x$1;
        }

        /*
         * WARNING - void declaration
         */
        private byte[] mkArray(int size) {
            byte[] newelems = new byte[size];
            if (this.size() > 0) {
                void var3_3;
                byte[] x$proxy9 = this.elems();
                if (x$proxy9 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                Array$.MODULE$.copy(var3_3, 0, newelems, 0, this.size());
            }
            return newelems;
        }

        @Override
        public void resize(int size) {
            this.elems_$eq(this.mkArray(size));
            this.capacity_$eq(size);
        }

        public ofByte addOne(byte elem) {
            this.ensureSize(this.size() + 1);
            byte[] x$proxy10 = this.elems();
            if (x$proxy10 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            x$proxy10[this.size()] = elem;
            this.size_$eq(this.size() + 1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public byte[] result() {
            if (this.capacity() != 0 && this.capacity() == this.size()) {
                void var2_1;
                this.capacity_$eq(0);
                byte[] x$proxy11 = this.elems();
                if (x$proxy11 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                void res = var2_1;
                this.elems_$eq(null);
                return res;
            }
            return this.mkArray(this.size());
        }

        public boolean equals(Object other) {
            Object object = other;
            if (object instanceof ofByte) {
                ofByte ofByte2;
                ofByte x = ofByte2 = (ofByte)object;
                return this.size() == x.size() && this.elems() == x.elems();
            }
            return false;
        }

        public String toString() {
            return "ArrayBuilder.ofByte";
        }
    }

    public static final class ofChar
    extends ArrayBuilder<Object> {
        private static final long serialVersionUID = 3L;
        private char[] elems = null;

        public char[] elems() {
            return this.elems;
        }

        public void elems_$eq(char[] x$1) {
            this.elems = x$1;
        }

        /*
         * WARNING - void declaration
         */
        private char[] mkArray(int size) {
            char[] newelems = new char[size];
            if (this.size() > 0) {
                void var3_3;
                char[] x$proxy15 = this.elems();
                if (x$proxy15 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                Array$.MODULE$.copy(var3_3, 0, newelems, 0, this.size());
            }
            return newelems;
        }

        @Override
        public void resize(int size) {
            this.elems_$eq(this.mkArray(size));
            this.capacity_$eq(size);
        }

        public ofChar addOne(char elem) {
            this.ensureSize(this.size() + 1);
            char[] x$proxy16 = this.elems();
            if (x$proxy16 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            x$proxy16[this.size()] = elem;
            this.size_$eq(this.size() + 1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public char[] result() {
            if (this.capacity() != 0 && this.capacity() == this.size()) {
                void var2_1;
                this.capacity_$eq(0);
                char[] x$proxy17 = this.elems();
                if (x$proxy17 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                void res = var2_1;
                this.elems_$eq(null);
                return res;
            }
            return this.mkArray(this.size());
        }

        public boolean equals(Object other) {
            Object object = other;
            if (object instanceof ofChar) {
                ofChar ofChar2;
                ofChar x = ofChar2 = (ofChar)object;
                return this.size() == x.size() && this.elems() == x.elems();
            }
            return false;
        }

        public String toString() {
            return "ArrayBuilder.ofChar";
        }
    }

    public static final class ofDouble
    extends ArrayBuilder<Object> {
        private static final long serialVersionUID = 3L;
        private double[] elems = null;

        public double[] elems() {
            return this.elems;
        }

        public void elems_$eq(double[] x$1) {
            this.elems = x$1;
        }

        /*
         * WARNING - void declaration
         */
        private double[] mkArray(int size) {
            double[] newelems = new double[size];
            if (this.size() > 0) {
                void var3_3;
                double[] x$proxy27 = this.elems();
                if (x$proxy27 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                Array$.MODULE$.copy(var3_3, 0, newelems, 0, this.size());
            }
            return newelems;
        }

        @Override
        public void resize(int size) {
            this.elems_$eq(this.mkArray(size));
            this.capacity_$eq(size);
        }

        public ofDouble addOne(double elem) {
            this.ensureSize(this.size() + 1);
            double[] x$proxy28 = this.elems();
            if (x$proxy28 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            x$proxy28[this.size()] = elem;
            this.size_$eq(this.size() + 1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public double[] result() {
            if (this.capacity() != 0 && this.capacity() == this.size()) {
                void var2_1;
                this.capacity_$eq(0);
                double[] x$proxy29 = this.elems();
                if (x$proxy29 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                void res = var2_1;
                this.elems_$eq(null);
                return res;
            }
            return this.mkArray(this.size());
        }

        public boolean equals(Object other) {
            Object object = other;
            if (object instanceof ofDouble) {
                ofDouble ofDouble2;
                ofDouble x = ofDouble2 = (ofDouble)object;
                return this.size() == x.size() && this.elems() == x.elems();
            }
            return false;
        }

        public String toString() {
            return "ArrayBuilder.ofDouble";
        }
    }

    public static final class ofFloat
    extends ArrayBuilder<Object> {
        private static final long serialVersionUID = 3L;
        private float[] elems = null;

        public float[] elems() {
            return this.elems;
        }

        public void elems_$eq(float[] x$1) {
            this.elems = x$1;
        }

        /*
         * WARNING - void declaration
         */
        private float[] mkArray(int size) {
            float[] newelems = new float[size];
            if (this.size() > 0) {
                void var3_3;
                float[] x$proxy24 = this.elems();
                if (x$proxy24 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                Array$.MODULE$.copy(var3_3, 0, newelems, 0, this.size());
            }
            return newelems;
        }

        @Override
        public void resize(int size) {
            this.elems_$eq(this.mkArray(size));
            this.capacity_$eq(size);
        }

        public ofFloat addOne(float elem) {
            this.ensureSize(this.size() + 1);
            float[] x$proxy25 = this.elems();
            if (x$proxy25 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            x$proxy25[this.size()] = elem;
            this.size_$eq(this.size() + 1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public float[] result() {
            if (this.capacity() != 0 && this.capacity() == this.size()) {
                void var2_1;
                this.capacity_$eq(0);
                float[] x$proxy26 = this.elems();
                if (x$proxy26 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                void res = var2_1;
                this.elems_$eq(null);
                return res;
            }
            return this.mkArray(this.size());
        }

        public boolean equals(Object other) {
            Object object = other;
            if (object instanceof ofFloat) {
                ofFloat ofFloat2;
                ofFloat x = ofFloat2 = (ofFloat)object;
                return this.size() == x.size() && this.elems() == x.elems();
            }
            return false;
        }

        public String toString() {
            return "ArrayBuilder.ofFloat";
        }
    }

    public static final class ofInt
    extends ArrayBuilder<Object> {
        private static final long serialVersionUID = 3L;
        private int[] elems = null;

        public int[] elems() {
            return this.elems;
        }

        public void elems_$eq(int[] x$1) {
            this.elems = x$1;
        }

        /*
         * WARNING - void declaration
         */
        private int[] mkArray(int size) {
            int[] newelems = new int[size];
            if (this.size() > 0) {
                void var3_3;
                int[] x$proxy18 = this.elems();
                if (x$proxy18 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                Array$.MODULE$.copy(var3_3, 0, newelems, 0, this.size());
            }
            return newelems;
        }

        @Override
        public void resize(int size) {
            this.elems_$eq(this.mkArray(size));
            this.capacity_$eq(size);
        }

        public ofInt addOne(int elem) {
            this.ensureSize(this.size() + 1);
            int[] x$proxy19 = this.elems();
            if (x$proxy19 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            x$proxy19[this.size()] = elem;
            this.size_$eq(this.size() + 1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int[] result() {
            if (this.capacity() != 0 && this.capacity() == this.size()) {
                void var2_1;
                this.capacity_$eq(0);
                int[] x$proxy20 = this.elems();
                if (x$proxy20 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                void res = var2_1;
                this.elems_$eq(null);
                return res;
            }
            return this.mkArray(this.size());
        }

        public boolean equals(Object other) {
            Object object = other;
            if (object instanceof ofInt) {
                ofInt ofInt2;
                ofInt x = ofInt2 = (ofInt)object;
                return this.size() == x.size() && this.elems() == x.elems();
            }
            return false;
        }

        public String toString() {
            return "ArrayBuilder.ofInt";
        }
    }

    public static final class ofLong
    extends ArrayBuilder<Object> {
        private static final long serialVersionUID = 3L;
        private long[] elems = null;

        public long[] elems() {
            return this.elems;
        }

        public void elems_$eq(long[] x$1) {
            this.elems = x$1;
        }

        /*
         * WARNING - void declaration
         */
        private long[] mkArray(int size) {
            long[] newelems = new long[size];
            if (this.size() > 0) {
                void var3_3;
                long[] x$proxy21 = this.elems();
                if (x$proxy21 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                Array$.MODULE$.copy(var3_3, 0, newelems, 0, this.size());
            }
            return newelems;
        }

        @Override
        public void resize(int size) {
            this.elems_$eq(this.mkArray(size));
            this.capacity_$eq(size);
        }

        public ofLong addOne(long elem) {
            this.ensureSize(this.size() + 1);
            long[] x$proxy22 = this.elems();
            if (x$proxy22 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            x$proxy22[this.size()] = elem;
            this.size_$eq(this.size() + 1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public long[] result() {
            if (this.capacity() != 0 && this.capacity() == this.size()) {
                void var2_1;
                this.capacity_$eq(0);
                long[] x$proxy23 = this.elems();
                if (x$proxy23 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                void res = var2_1;
                this.elems_$eq(null);
                return res;
            }
            return this.mkArray(this.size());
        }

        public boolean equals(Object other) {
            Object object = other;
            if (object instanceof ofLong) {
                ofLong ofLong2;
                ofLong x = ofLong2 = (ofLong)object;
                return this.size() == x.size() && this.elems() == x.elems();
            }
            return false;
        }

        public String toString() {
            return "ArrayBuilder.ofLong";
        }
    }

    public static final class ofRef<T>
    extends ArrayBuilder<T> {
        private static final long serialVersionUID = 3L;
        private final ClassTag<T> ct;
        private T[] elems;

        public ofRef(ClassTag<T> ct) {
            this.ct = ct;
            this.elems = null;
        }

        public T[] elems() {
            return this.elems;
        }

        public void elems_$eq(T[] x$1) {
            this.elems = x$1;
        }

        private T[] mkArray(int size) {
            if (this.capacity() == size && this.capacity() > 0) {
                T[] x$proxy3 = this.elems();
                if (x$proxy3 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                return x$proxy3;
            }
            if (this.elems() == null) {
                return (Object[])Arrays$.MODULE$.newGenericArray(size, this.ct);
            }
            return Arrays.copyOf(this.elems(), size);
        }

        @Override
        public void resize(int size) {
            this.elems_$eq(this.mkArray(size));
            this.capacity_$eq(size);
        }

        @Override
        public ofRef<T> addOne(T elem) {
            this.ensureSize(this.size() + 1);
            T[] x$proxy5 = this.elems();
            if (x$proxy5 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            x$proxy5[this.size()] = elem;
            this.size_$eq(this.size() + 1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public T[] result() {
            if (this.capacity() != 0 && this.capacity() == this.size()) {
                void var2_1;
                this.capacity_$eq(0);
                T[] x$proxy6 = this.elems();
                if (x$proxy6 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                void res = var2_1;
                this.elems_$eq(null);
                return res;
            }
            return this.mkArray(this.size());
        }

        @Override
        public void clear() {
            super.clear();
            if (!(this.elems() == null)) {
                Arrays.fill(this.elems(), null);
                return;
            }
        }

        public boolean equals(Object other) {
            Object object = other;
            if (object instanceof ofRef) {
                ofRef ofRef2;
                ofRef x = ofRef2 = (ofRef)object;
                return this.size() == x.size() && this.elems() == x.elems();
            }
            return false;
        }

        public String toString() {
            return "ArrayBuilder.ofRef";
        }
    }

    public static final class ofShort
    extends ArrayBuilder<Object> {
        private static final long serialVersionUID = 3L;
        private short[] elems = null;

        public short[] elems() {
            return this.elems;
        }

        public void elems_$eq(short[] x$1) {
            this.elems = x$1;
        }

        /*
         * WARNING - void declaration
         */
        private short[] mkArray(int size) {
            short[] newelems = new short[size];
            if (this.size() > 0) {
                void var3_3;
                short[] x$proxy12 = this.elems();
                if (x$proxy12 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                Array$.MODULE$.copy(var3_3, 0, newelems, 0, this.size());
            }
            return newelems;
        }

        @Override
        public void resize(int size) {
            this.elems_$eq(this.mkArray(size));
            this.capacity_$eq(size);
        }

        public ofShort addOne(short elem) {
            this.ensureSize(this.size() + 1);
            short[] x$proxy13 = this.elems();
            if (x$proxy13 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            x$proxy13[this.size()] = elem;
            this.size_$eq(this.size() + 1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public short[] result() {
            if (this.capacity() != 0 && this.capacity() == this.size()) {
                void var2_1;
                this.capacity_$eq(0);
                short[] x$proxy14 = this.elems();
                if (x$proxy14 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                void res = var2_1;
                this.elems_$eq(null);
                return res;
            }
            return this.mkArray(this.size());
        }

        public boolean equals(Object other) {
            Object object = other;
            if (object instanceof ofShort) {
                ofShort ofShort2;
                ofShort x = ofShort2 = (ofShort)object;
                return this.size() == x.size() && this.elems() == x.elems();
            }
            return false;
        }

        public String toString() {
            return "ArrayBuilder.ofShort";
        }
    }

    public static final class ofUnit
    extends ArrayBuilder<BoxedUnit> {
        private static final long serialVersionUID = 3L;

        public BoxedUnit[] elems() {
            throw new UnsupportedOperationException();
        }

        public ofUnit addOne(BoxedUnit elem) {
            int newSize = this.size() + 1;
            this.ensureSize(newSize);
            this.size_$eq(newSize);
            return this;
        }

        public ofUnit addAll(IterableOnce<BoxedUnit> xs) {
            int newSize = this.size() + xs.iterator().size();
            this.ensureSize(newSize);
            this.size_$eq(newSize);
            return this;
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        public ofUnit addAll(Object xs, int offset, int length) {
            int newSize = this.size() + length;
            this.ensureSize(newSize);
            this.size_$eq(newSize);
            return this;
        }

        @Override
        public BoxedUnit[] result() {
            BoxedUnit[] ans = new BoxedUnit[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                ans[i] = BoxedUnit.UNIT;
            }
            return ans;
        }

        public boolean equals(Object other) {
            Object object = other;
            if (object instanceof ofUnit) {
                ofUnit ofUnit2;
                ofUnit x = ofUnit2 = (ofUnit)object;
                return this.size() == x.size();
            }
            return false;
        }

        @Override
        public void resize(int size) {
            this.capacity_$eq(size);
        }

        public String toString() {
            return "ArrayBuilder.ofUnit";
        }
    }
}

