/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.util.Arrays;
import java.util.NoSuchElementException;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Hashing$;
import scala.collection.Iterator$;
import scala.collection.immutable.HashCollisionMapNode;
import scala.collection.immutable.HashMapBuilder;
import scala.collection.immutable.MapNode;
import scala.collection.immutable.MapNode$;
import scala.collection.immutable.Node;
import scala.collection.immutable.Node$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.AbstractBuffer;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class BitmapIndexedMapNode<K, V>
extends MapNode<K, V> {
    private int dataMap;
    private int nodeMap;
    private Object[] content;
    private int[] originalHashes;
    private int size;
    private int cachedJavaKeySetHashCode;

    public BitmapIndexedMapNode(int dataMap, int nodeMap, Object[] content, int[] originalHashes, int size, int cachedJavaKeySetHashCode) {
        this.dataMap = dataMap;
        this.nodeMap = nodeMap;
        this.content = content;
        this.originalHashes = originalHashes;
        this.size = size;
        this.cachedJavaKeySetHashCode = cachedJavaKeySetHashCode;
        Statics.releaseFence();
    }

    public int dataMap() {
        return this.dataMap;
    }

    public void dataMap_$eq(int x$1) {
        this.dataMap = x$1;
    }

    public int nodeMap() {
        return this.nodeMap;
    }

    public void nodeMap_$eq(int x$1) {
        this.nodeMap = x$1;
    }

    public Object[] content() {
        return this.content;
    }

    public void content_$eq(Object[] x$1) {
        this.content = x$1;
    }

    public int[] originalHashes() {
        return this.originalHashes;
    }

    public void originalHashes_$eq(int[] x$1) {
        this.originalHashes = x$1;
    }

    @Override
    public int size() {
        return this.size;
    }

    public void size_$eq(int x$1) {
        this.size = x$1;
    }

    @Override
    public int cachedJavaKeySetHashCode() {
        return this.cachedJavaKeySetHashCode;
    }

    public void cachedJavaKeySetHashCode_$eq(int x$1) {
        this.cachedJavaKeySetHashCode = x$1;
    }

    @Override
    public K getKey(int index) {
        return (K)this.content()[2 * index];
    }

    @Override
    public V getValue(int index) {
        return (V)this.content()[2 * index + 1];
    }

    @Override
    public Tuple2<K, V> getPayload(int index) {
        return Tuple2$.MODULE$.apply(this.content()[2 * index], this.content()[2 * index + 1]);
    }

    @Override
    public int getHash(int index) {
        return this.originalHashes()[index];
    }

    @Override
    public MapNode<K, V> getNode(int index) {
        return (MapNode)this.content()[this.content().length - 1 - index];
    }

    @Override
    public V apply(K key, int originalHash, int keyHash, int shift) {
        int mask = Node$.MODULE$.maskFrom(keyHash, shift);
        int bitpos = Node$.MODULE$.bitposFrom(mask);
        if ((this.dataMap() & bitpos) != 0) {
            int index = Node$.MODULE$.indexFrom(this.dataMap(), mask, bitpos);
            if (BoxesRunTime.equals(key, this.getKey(index))) {
                return this.getValue(index);
            }
            throw new NoSuchElementException(new StringBuilder(15).append("key not found: ").append(key).toString());
        }
        if ((this.nodeMap() & bitpos) != 0) {
            return ((MapNode)this.getNode(Node$.MODULE$.indexFrom(this.nodeMap(), mask, bitpos))).apply(key, originalHash, keyHash, shift + 5);
        }
        throw new NoSuchElementException(new StringBuilder(15).append("key not found: ").append(key).toString());
    }

    @Override
    public Option<V> get(K key, int originalHash, int keyHash, int shift) {
        int mask = Node$.MODULE$.maskFrom(keyHash, shift);
        int bitpos = Node$.MODULE$.bitposFrom(mask);
        if ((this.dataMap() & bitpos) != 0) {
            int index = Node$.MODULE$.indexFrom(this.dataMap(), mask, bitpos);
            K key0 = this.getKey(index);
            if (BoxesRunTime.equals(key, key0)) {
                return Some$.MODULE$.apply(this.getValue(index));
            }
            return None$.MODULE$;
        }
        if ((this.nodeMap() & bitpos) != 0) {
            int index = Node$.MODULE$.indexFrom(this.nodeMap(), mask, bitpos);
            return ((MapNode)this.getNode(index)).get(key, originalHash, keyHash, shift + 5);
        }
        return None$.MODULE$;
    }

    @Override
    public Tuple2<K, V> getTuple(K key, int originalHash, int hash, int shift) {
        int mask = Node$.MODULE$.maskFrom(hash, shift);
        int bitpos = Node$.MODULE$.bitposFrom(mask);
        if ((this.dataMap() & bitpos) != 0) {
            int index = Node$.MODULE$.indexFrom(this.dataMap(), mask, bitpos);
            Object payload = this.getPayload(index);
            if (BoxesRunTime.equals(key, ((Tuple2)payload)._1())) {
                return payload;
            }
            return (Tuple2)Iterator$.MODULE$.empty().next();
        }
        if ((this.nodeMap() & bitpos) != 0) {
            int index = Node$.MODULE$.indexFrom(this.nodeMap(), mask, bitpos);
            return ((MapNode)this.getNode(index)).getTuple(key, originalHash, hash, shift + 5);
        }
        return (Tuple2)Iterator$.MODULE$.empty().next();
    }

    @Override
    public <V1> V1 getOrElse(K key, int originalHash, int keyHash, int shift, Function0<V1> f) {
        int mask = Node$.MODULE$.maskFrom(keyHash, shift);
        int bitpos = Node$.MODULE$.bitposFrom(mask);
        if ((this.dataMap() & bitpos) != 0) {
            int index = Node$.MODULE$.indexFrom(this.dataMap(), mask, bitpos);
            K key0 = this.getKey(index);
            if (BoxesRunTime.equals(key, key0)) {
                return (V1)this.getValue(index);
            }
            return f.apply();
        }
        if ((this.nodeMap() & bitpos) != 0) {
            int index = Node$.MODULE$.indexFrom(this.nodeMap(), mask, bitpos);
            return ((MapNode)this.getNode(index)).getOrElse(key, originalHash, keyHash, shift + 5, f);
        }
        return f.apply();
    }

    @Override
    public boolean containsKey(K key, int originalHash, int keyHash, int shift) {
        int mask = Node$.MODULE$.maskFrom(keyHash, shift);
        int bitpos = Node$.MODULE$.bitposFrom(mask);
        if ((this.dataMap() & bitpos) != 0) {
            int index = Node$.MODULE$.indexFrom(this.dataMap(), mask, bitpos);
            return this.originalHashes()[index] == originalHash && BoxesRunTime.equals(key, this.getKey(index));
        }
        if ((this.nodeMap() & bitpos) != 0) {
            return ((MapNode)this.getNode(Node$.MODULE$.indexFrom(this.nodeMap(), mask, bitpos))).containsKey(key, originalHash, keyHash, shift + 5);
        }
        return false;
    }

    @Override
    public <V1> BitmapIndexedMapNode<K, V1> updated(K key, V1 value, int originalHash, int keyHash, int shift, boolean replaceValue) {
        int mask = Node$.MODULE$.maskFrom(keyHash, shift);
        int bitpos = Node$.MODULE$.bitposFrom(mask);
        if ((this.dataMap() & bitpos) != 0) {
            int index = Node$.MODULE$.indexFrom(this.dataMap(), mask, bitpos);
            K key0 = this.getKey(index);
            int key0UnimprovedHash = this.getHash(index);
            if (key0UnimprovedHash == originalHash && BoxesRunTime.equals(key0, key)) {
                if (replaceValue) {
                    V value0 = this.getValue(index);
                    if (key0 == key && value0 == value) {
                        return this;
                    }
                    return this.copyAndSetValue(bitpos, key, value);
                }
                return this;
            }
            V value0 = this.getValue(index);
            int key0Hash = Hashing$.MODULE$.improve(key0UnimprovedHash);
            MapNode<K, V> subNodeNew = this.mergeTwoKeyValPairs(key0, value0, key0UnimprovedHash, key0Hash, key, value, originalHash, keyHash, shift + 5);
            return this.copyAndMigrateFromInlineToNode(bitpos, key0Hash, subNodeNew);
        }
        if ((this.nodeMap() & bitpos) != 0) {
            int index = Node$.MODULE$.indexFrom(this.nodeMap(), mask, bitpos);
            Node subNode = this.getNode(index);
            MapNode<K, V1> subNodeNew = ((MapNode)subNode).updated(key, value, originalHash, keyHash, shift + 5, replaceValue);
            if (subNodeNew == subNode) {
                return this;
            }
            return this.copyAndSetNode(bitpos, (MapNode<K, V1>)subNode, subNodeNew);
        }
        return this.copyAndInsertValue(bitpos, key, originalHash, keyHash, value);
    }

    /*
     * Unable to fully structure code
     */
    public <V1> int updateWithShallowMutations(K key, V1 value, int originalHash, int keyHash, int shift, int shallowlyMutableNodeMap) {
        block6: {
            mask = Node$.MODULE$.maskFrom(keyHash, shift);
            bitpos = Node$.MODULE$.bitposFrom(mask);
            if ((this.dataMap() & bitpos) != 0) {
                index = Node$.MODULE$.indexFrom(this.dataMap(), mask, bitpos);
                key0 = this.getKey(index);
                key0UnimprovedHash = this.getHash(index);
                if (key0UnimprovedHash == originalHash && BoxesRunTime.equals(key0, key)) {
                    value0 = this.getValue(index);
                    if (key0 != key || value0 != value) {
                        dataIx = this.dataIndex(bitpos);
                        idx = 2 * dataIx;
                        this.content()[idx + 1] = value;
                    }
                    return shallowlyMutableNodeMap;
                }
                value0 = this.getValue(index);
                key0Hash = Hashing$.MODULE$.improve(key0UnimprovedHash);
                subNodeNew = this.mergeTwoKeyValPairs(key0, value0, key0UnimprovedHash, key0Hash, key, value, originalHash, keyHash, shift + 5);
                this.migrateFromInlineToNodeInPlace(bitpos, key0Hash, subNodeNew);
                return shallowlyMutableNodeMap | bitpos;
            }
            if ((this.nodeMap() & bitpos) == 0) break block6;
            index = Node$.MODULE$.indexFrom(this.nodeMap(), mask, bitpos);
            subNode = this.getNode(index);
            subNodeSize = subNode.size();
            subNodeHashCode = subNode.cachedJavaKeySetHashCode();
            returnMutableNodeMap = shallowlyMutableNodeMap;
            var24_23 = subNode;
            if (!(var24_23 instanceof BitmapIndexedMapNode)) ** GOTO lbl-1000
            subNodeBm = var25_24 = (BitmapIndexedMapNode)var24_23;
            if ((bitpos & shallowlyMutableNodeMap) != 0) {
                subNodeBm.updateWithShallowMutations(key, value, originalHash, keyHash, shift + 5, 0);
                v0 = subNodeBm;
            } else lbl-1000:
            // 2 sources

            {
                if ((result = subNode.updated(key, value, originalHash, keyHash, shift + 5, true)) != subNode) {
                    returnMutableNodeMap |= bitpos;
                }
                v0 = result;
            }
            subNodeNew = v0;
            this.content()[this.content().length - 1 - this.nodeIndex((int)bitpos)] = subNodeNew;
            this.size_$eq(this.size() - subNodeSize + subNodeNew.size());
            this.cachedJavaKeySetHashCode_$eq(this.cachedJavaKeySetHashCode() - subNodeHashCode + subNodeNew.cachedJavaKeySetHashCode());
            return returnMutableNodeMap;
        }
        dataIx = this.dataIndex(bitpos);
        idx = 2 * dataIx;
        src = this.content();
        dst = new Object[src.length + 2];
        System.arraycopy(src, 0, dst, 0, idx);
        dst[idx] = key;
        dst[idx + 1] = value;
        System.arraycopy(src, idx, dst, idx + 2, src.length - idx);
        this.dataMap_$eq(this.dataMap() | bitpos);
        this.content_$eq(dst);
        this.originalHashes_$eq(this.insertElement(this.originalHashes(), dataIx, originalHash));
        this.size_$eq(this.size() + 1);
        this.cachedJavaKeySetHashCode_$eq(this.cachedJavaKeySetHashCode() + keyHash);
        return shallowlyMutableNodeMap;
    }

    @Override
    public <V1> BitmapIndexedMapNode<K, V1> removed(K key, int originalHash, int keyHash, int shift) {
        int mask = Node$.MODULE$.maskFrom(keyHash, shift);
        int bitpos = Node$.MODULE$.bitposFrom(mask);
        if ((this.dataMap() & bitpos) != 0) {
            int index = Node$.MODULE$.indexFrom(this.dataMap(), mask, bitpos);
            K key0 = this.getKey(index);
            if (BoxesRunTime.equals(key0, key)) {
                if (this.payloadArity() == 2 && this.nodeArity() == 0) {
                    int newDataMap;
                    int n = newDataMap = shift == 0 ? this.dataMap() ^ bitpos : Node$.MODULE$.bitposFrom(Node$.MODULE$.maskFrom(keyHash, 0));
                    if (index == 0) {
                        return new BitmapIndexedMapNode<K, V>(newDataMap, 0, (Object[])Array$.MODULE$.apply(ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{this.getKey(1), this.getValue(1)}), ClassTag$.MODULE$.Any()), new int[]{this.originalHashes()[1]}, 1, Hashing$.MODULE$.improve(this.getHash(1)));
                    }
                    return new BitmapIndexedMapNode<K, V>(newDataMap, 0, (Object[])Array$.MODULE$.apply(ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{this.getKey(0), this.getValue(0)}), ClassTag$.MODULE$.Any()), new int[]{this.originalHashes()[0]}, 1, Hashing$.MODULE$.improve(this.getHash(0)));
                }
                return this.copyAndRemoveValue(bitpos, keyHash);
            }
            return this;
        }
        if ((this.nodeMap() & bitpos) != 0) {
            int index = Node$.MODULE$.indexFrom(this.nodeMap(), mask, bitpos);
            Node subNode = this.getNode(index);
            MapNode subNodeNew = ((MapNode)subNode).removed(key, originalHash, keyHash, shift + 5);
            if (subNodeNew == subNode) {
                return this;
            }
            int subNodeNewSize = subNodeNew.size();
            if (subNodeNewSize == 1) {
                if (this.size() == ((MapNode)subNode).size()) {
                    return (BitmapIndexedMapNode)subNodeNew;
                }
                return this.copyAndMigrateFromNodeToInline(bitpos, (MapNode<K, V1>)subNode, subNodeNew);
            }
            if (subNodeNewSize > 1) {
                return this.copyAndSetNode(bitpos, (MapNode<K, V1>)subNode, subNodeNew);
            }
            return this;
        }
        return this;
    }

    public <V1> MapNode<K, V1> mergeTwoKeyValPairs(K key0, V1 value0, int originalHash0, int keyHash0, K key1, V1 value1, int originalHash1, int keyHash1, int shift) {
        if (shift >= 32) {
            return new HashCollisionMapNode(originalHash0, keyHash0, (Vector)Vector$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[]{Tuple2$.MODULE$.apply(key0, value0), Tuple2$.MODULE$.apply(key1, value1)})));
        }
        int mask0 = Node$.MODULE$.maskFrom(keyHash0, shift);
        int mask1 = Node$.MODULE$.maskFrom(keyHash1, shift);
        int newCachedHash = keyHash0 + keyHash1;
        if (mask0 != mask1) {
            int dataMap = Node$.MODULE$.bitposFrom(mask0) | Node$.MODULE$.bitposFrom(mask1);
            if (mask0 < mask1) {
                return new BitmapIndexedMapNode<K, V>(dataMap, 0, (Object[])Array$.MODULE$.apply(ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{key0, value0, key1, value1}), ClassTag$.MODULE$.Any()), new int[]{originalHash0, originalHash1}, 2, newCachedHash);
            }
            return new BitmapIndexedMapNode<K, V>(dataMap, 0, (Object[])Array$.MODULE$.apply(ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{key1, value1, key0, value0}), ClassTag$.MODULE$.Any()), new int[]{originalHash1, originalHash0}, 2, newCachedHash);
        }
        int nodeMap = Node$.MODULE$.bitposFrom(mask0);
        MapNode<K, V1> node = this.mergeTwoKeyValPairs(key0, value0, originalHash0, keyHash0, key1, value1, originalHash1, keyHash1, shift + 5);
        return new BitmapIndexedMapNode<K, V>(0, nodeMap, (Object[])Array$.MODULE$.apply(ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{node}), ClassTag$.MODULE$.Any()), Array$.MODULE$.emptyIntArray(), node.size(), node.cachedJavaKeySetHashCode());
    }

    @Override
    public boolean hasNodes() {
        return this.nodeMap() != 0;
    }

    @Override
    public int nodeArity() {
        return Integer.bitCount(this.nodeMap());
    }

    @Override
    public boolean hasPayload() {
        return this.dataMap() != 0;
    }

    @Override
    public int payloadArity() {
        return Integer.bitCount(this.dataMap());
    }

    public int dataIndex(int bitpos) {
        return Integer.bitCount(this.dataMap() & bitpos - 1);
    }

    public int nodeIndex(int bitpos) {
        return Integer.bitCount(this.nodeMap() & bitpos - 1);
    }

    public <V1> BitmapIndexedMapNode<K, V1> copyAndSetValue(int bitpos, K newKey, V1 newValue) {
        int dataIx = this.dataIndex(bitpos);
        int idx = 2 * dataIx;
        Object[] src = this.content();
        Object[] dst = new Object[src.length];
        System.arraycopy(src, 0, dst, 0, src.length);
        dst[idx + 1] = newValue;
        return new BitmapIndexedMapNode<K, V>(this.dataMap(), this.nodeMap(), dst, this.originalHashes(), this.size(), this.cachedJavaKeySetHashCode());
    }

    public <V1> BitmapIndexedMapNode<K, V1> copyAndSetNode(int bitpos, MapNode<K, V1> oldNode, MapNode<K, V1> newNode) {
        int idx = this.content().length - 1 - this.nodeIndex(bitpos);
        Object[] src = this.content();
        Object[] dst = new Object[src.length];
        System.arraycopy(src, 0, dst, 0, src.length);
        dst[idx] = newNode;
        return new BitmapIndexedMapNode<K, V>(this.dataMap(), this.nodeMap(), dst, this.originalHashes(), this.size() - oldNode.size() + newNode.size(), this.cachedJavaKeySetHashCode() - oldNode.cachedJavaKeySetHashCode() + newNode.cachedJavaKeySetHashCode());
    }

    public <V1> BitmapIndexedMapNode<K, V1> copyAndInsertValue(int bitpos, K key, int originalHash, int keyHash, V1 value) {
        int dataIx = this.dataIndex(bitpos);
        int idx = 2 * dataIx;
        Object[] src = this.content();
        Object[] dst = new Object[src.length + 2];
        System.arraycopy(src, 0, dst, 0, idx);
        dst[idx] = key;
        dst[idx + 1] = value;
        System.arraycopy(src, idx, dst, idx + 2, src.length - idx);
        int[] dstHashes = this.insertElement(this.originalHashes(), dataIx, originalHash);
        return new BitmapIndexedMapNode<K, V>(this.dataMap() | bitpos, this.nodeMap(), dst, dstHashes, this.size() + 1, this.cachedJavaKeySetHashCode() + keyHash);
    }

    public BitmapIndexedMapNode<K, V> copyAndRemoveValue(int bitpos, int keyHash) {
        int dataIx = this.dataIndex(bitpos);
        int idx = 2 * dataIx;
        Object[] src = this.content();
        Object[] dst = new Object[src.length - 2];
        System.arraycopy(src, 0, dst, 0, idx);
        System.arraycopy(src, idx + 2, dst, idx, src.length - idx - 2);
        int[] dstHashes = this.removeElement(this.originalHashes(), dataIx);
        return new BitmapIndexedMapNode<K, V>(this.dataMap() ^ bitpos, this.nodeMap(), dst, dstHashes, this.size() - 1, this.cachedJavaKeySetHashCode() - keyHash);
    }

    public <V1> BitmapIndexedMapNode<K, V> migrateFromInlineToNodeInPlace(int bitpos, int keyHash, MapNode<K, V1> node) {
        int dataIx = this.dataIndex(bitpos);
        int idxOld = 2 * dataIx;
        int idxNew = this.content().length - 2 - this.nodeIndex(bitpos);
        Object[] src = this.content();
        Object[] dst = new Object[src.length - 2 + 1];
        System.arraycopy(src, 0, dst, 0, idxOld);
        System.arraycopy(src, idxOld + 2, dst, idxOld, idxNew - idxOld);
        dst[idxNew] = node;
        System.arraycopy(src, idxNew + 2, dst, idxNew + 1, src.length - idxNew - 2);
        int[] dstHashes = this.removeElement(this.originalHashes(), dataIx);
        this.dataMap_$eq(this.dataMap() ^ bitpos);
        this.nodeMap_$eq(this.nodeMap() | bitpos);
        this.content_$eq(dst);
        this.originalHashes_$eq(dstHashes);
        this.size_$eq(this.size() - 1 + node.size());
        this.cachedJavaKeySetHashCode_$eq(this.cachedJavaKeySetHashCode() - keyHash + node.cachedJavaKeySetHashCode());
        return this;
    }

    public <V1> BitmapIndexedMapNode<K, V1> copyAndMigrateFromInlineToNode(int bitpos, int keyHash, MapNode<K, V1> node) {
        int dataIx = this.dataIndex(bitpos);
        int idxOld = 2 * dataIx;
        int idxNew = this.content().length - 2 - this.nodeIndex(bitpos);
        Object[] src = this.content();
        Object[] dst = new Object[src.length - 2 + 1];
        System.arraycopy(src, 0, dst, 0, idxOld);
        System.arraycopy(src, idxOld + 2, dst, idxOld, idxNew - idxOld);
        dst[idxNew] = node;
        System.arraycopy(src, idxNew + 2, dst, idxNew + 1, src.length - idxNew - 2);
        int[] dstHashes = this.removeElement(this.originalHashes(), dataIx);
        return new BitmapIndexedMapNode<K, V>(this.dataMap() ^ bitpos, this.nodeMap() | bitpos, dst, dstHashes, this.size() - 1 + node.size(), this.cachedJavaKeySetHashCode() - keyHash + node.cachedJavaKeySetHashCode());
    }

    public <V1> BitmapIndexedMapNode<K, V1> copyAndMigrateFromNodeToInline(int bitpos, MapNode<K, V1> oldNode, MapNode<K, V1> node) {
        int idxOld = this.content().length - 1 - this.nodeIndex(bitpos);
        int dataIxNew = this.dataIndex(bitpos);
        int idxNew = 2 * dataIxNew;
        K key = node.getKey(0);
        V1 value = node.getValue(0);
        Object[] src = this.content();
        Object[] dst = new Object[src.length - 1 + 2];
        System.arraycopy(src, 0, dst, 0, idxNew);
        dst[idxNew] = key;
        dst[idxNew + 1] = value;
        System.arraycopy(src, idxNew, dst, idxNew + 2, idxOld - idxNew);
        System.arraycopy(src, idxOld + 1, dst, idxOld + 2, src.length - idxOld - 1);
        int hash = node.getHash(0);
        int[] dstHashes = this.insertElement(this.originalHashes(), dataIxNew, hash);
        return new BitmapIndexedMapNode<K, V>(this.dataMap() | bitpos, this.nodeMap() ^ bitpos, dst, dstHashes, this.size() - oldNode.size() + 1, this.cachedJavaKeySetHashCode() - oldNode.cachedJavaKeySetHashCode() + node.cachedJavaKeySetHashCode());
    }

    @Override
    public <U> void foreach(Function1<Tuple2<K, V>, U> f) {
        int iN = this.payloadArity();
        for (int i = 0; i < iN; ++i) {
            f.apply((Tuple2<K, V>)this.getPayload(i));
        }
        int jN = this.nodeArity();
        for (int j = 0; j < jN; ++j) {
            ((MapNode)this.getNode(j)).foreach(f);
        }
    }

    @Override
    public <U> void foreachEntry(Function2<K, V, U> f) {
        int iN = this.payloadArity();
        for (int i = 0; i < iN; ++i) {
            f.apply(this.getKey(i), this.getValue(i));
        }
        int jN = this.nodeArity();
        for (int j = 0; j < jN; ++j) {
            ((MapNode)this.getNode(j)).foreachEntry(f);
        }
    }

    @Override
    public void foreachWithHash(Function3<K, V, Object, BoxedUnit> f) {
        int iN = this.payloadArity();
        for (int i = 0; i < iN; ++i) {
            f.apply(this.getKey(i), this.getValue(i), BoxesRunTime.boxToInteger(this.getHash(i)));
        }
        int jN = this.nodeArity();
        for (int j = 0; j < jN; ++j) {
            ((MapNode)this.getNode(j)).foreachWithHash(f);
        }
    }

    @Override
    public <V1> void buildTo(HashMapBuilder<K, V1> builder) {
        int iN = this.payloadArity();
        int jN = this.nodeArity();
        for (int i = 0; i < iN; ++i) {
            builder.addOne(this.getKey(i), this.getValue(i), this.getHash(i));
        }
        for (int j = 0; j < jN; ++j) {
            ((MapNode)this.getNode(j)).buildTo(builder);
        }
    }

    @Override
    public <W> BitmapIndexedMapNode<K, W> transform(Function2<K, V, W> f) {
        Object[] newContent = null;
        int iN = this.payloadArity();
        int jN = this.nodeArity();
        int newContentLength = this.content().length;
        for (int i = 0; i < iN; ++i) {
            K key = this.getKey(i);
            V value = this.getValue(i);
            W newValue = f.apply(key, value);
            if (newContent == null) {
                if (newValue == value) continue;
                newContent = (Object[])this.content().clone();
                newContent[2 * i + 1] = newValue;
                continue;
            }
            newContent[2 * i + 1] = newValue;
        }
        for (int j = 0; j < jN; ++j) {
            Node node = this.getNode(j);
            MapNode<K, W> newNode = ((MapNode)node).transform(f);
            if (newContent == null) {
                if (newNode == node) continue;
                newContent = (Object[])this.content().clone();
                newContent[newContentLength - j - 1] = newNode;
                continue;
            }
            newContent[newContentLength - j - 1] = newNode;
        }
        if (newContent == null) {
            return this;
        }
        return new BitmapIndexedMapNode<K, V>(this.dataMap(), this.nodeMap(), newContent, this.originalHashes(), this.size(), this.cachedJavaKeySetHashCode());
    }

    @Override
    public <V1> void mergeInto(MapNode<K, V1> that, HashMapBuilder<K, V1> builder, int shift, Function2<Tuple2<K, V>, Tuple2<K, V1>, Tuple2<K, V1>> mergef) {
        MapNode<K, V1> mapNode = that;
        if (mapNode instanceof BitmapIndexedMapNode) {
            BitmapIndexedMapNode bitmapIndexedMapNode;
            BitmapIndexedMapNode bm = bitmapIndexedMapNode = (BitmapIndexedMapNode)mapNode;
            if (this.size() == 0) {
                that.buildTo(builder);
                return;
            }
            if (bm.size() == 0) {
                this.buildTo(builder);
                return;
            }
            int allMap = this.dataMap() | bm.dataMap() | this.nodeMap() | bm.nodeMap();
            int minIndex = Integer.numberOfTrailingZeros(allMap);
            int maxIndex = 32 - Integer.numberOfLeadingZeros(allMap);
            int leftIdx = 0;
            int rightIdx = 0;
            for (int index = minIndex; index < maxIndex; ++index) {
                int bitpos = Node$.MODULE$.bitposFrom(index);
                if ((bitpos & this.dataMap()) != 0) {
                    HashMapBuilder<K, V1> hashMapBuilder;
                    K leftKey = this.getKey(leftIdx);
                    V leftValue = this.getValue(leftIdx);
                    int leftOriginalHash = this.getHash(leftIdx);
                    if ((bitpos & bm.dataMap()) != 0) {
                        HashMapBuilder<K, V1> hashMapBuilder2;
                        K rightKey = bm.getKey(rightIdx);
                        V rightValue = bm.getValue(rightIdx);
                        int rightOriginalHash = bm.getHash(rightIdx);
                        if (leftOriginalHash == rightOriginalHash && BoxesRunTime.equals(leftKey, rightKey)) {
                            hashMapBuilder2 = builder.addOne(mergef.apply(Tuple2$.MODULE$.apply(leftKey, leftValue), Tuple2$.MODULE$.apply(rightKey, rightValue)));
                        } else {
                            builder.addOne(leftKey, leftValue, leftOriginalHash);
                            hashMapBuilder2 = builder.addOne(rightKey, rightValue, rightOriginalHash);
                        }
                        ++rightIdx;
                        hashMapBuilder = BoxedUnit.UNIT;
                    } else if ((bitpos & bm.nodeMap()) != 0) {
                        int leftImprovedHash;
                        Node subNode = bm.getNode(bm.nodeIndex(bitpos));
                        MapNode<K, V1> removed = ((MapNode)subNode).removed(leftKey, leftOriginalHash, leftImprovedHash = Hashing$.MODULE$.improve(leftOriginalHash), shift + 5);
                        if (removed == subNode) {
                            ((MapNode)subNode).buildTo(builder);
                            hashMapBuilder = builder.addOne(leftKey, leftValue, leftOriginalHash, leftImprovedHash);
                        } else {
                            removed.buildTo(builder);
                            hashMapBuilder = builder.addOne(mergef.apply(Tuple2$.MODULE$.apply(leftKey, leftValue), ((MapNode)subNode).getTuple(leftKey, leftOriginalHash, leftImprovedHash, shift + 5)));
                        }
                    } else {
                        hashMapBuilder = builder.addOne(leftKey, leftValue, leftOriginalHash);
                    }
                    ++leftIdx;
                    continue;
                }
                if ((bitpos & this.nodeMap()) != 0) {
                    if ((bitpos & bm.dataMap()) != 0) {
                        HashMapBuilder<K, V1> hashMapBuilder;
                        K rightKey = bm.getKey(rightIdx);
                        V rightValue = bm.getValue(rightIdx);
                        int rightOriginalHash = bm.getHash(rightIdx);
                        int rightImprovedHash = Hashing$.MODULE$.improve(rightOriginalHash);
                        Node subNode = this.getNode(this.nodeIndex(bitpos));
                        MapNode<K, V1> removed = ((MapNode)subNode).removed(rightKey, rightOriginalHash, rightImprovedHash, shift + 5);
                        if (removed == subNode) {
                            ((MapNode)subNode).buildTo(builder);
                            hashMapBuilder = builder.addOne(rightKey, rightValue, rightOriginalHash, rightImprovedHash);
                        } else {
                            removed.buildTo(builder);
                            hashMapBuilder = builder.addOne(mergef.apply(((MapNode)subNode).getTuple(rightKey, rightOriginalHash, rightImprovedHash, shift + 5), Tuple2$.MODULE$.apply(rightKey, rightValue)));
                        }
                        ++rightIdx;
                        continue;
                    }
                    if ((bitpos & bm.nodeMap()) != 0) {
                        ((MapNode)this.getNode(this.nodeIndex(bitpos))).mergeInto(bm.getNode(bm.nodeIndex(bitpos)), builder, shift + 5, mergef);
                        continue;
                    }
                    ((MapNode)this.getNode(this.nodeIndex(bitpos))).buildTo(builder);
                    continue;
                }
                if ((bitpos & bm.dataMap()) != 0) {
                    int dataIndex = bm.dataIndex(bitpos);
                    builder.addOne(bm.getKey(dataIndex), bm.getValue(dataIndex), bm.getHash(dataIndex));
                    ++rightIdx;
                    continue;
                }
                if ((bitpos & bm.nodeMap()) == 0) continue;
                ((MapNode)bm.getNode(bm.nodeIndex(bitpos))).buildTo(builder);
            }
            return;
        }
        if (mapNode instanceof HashCollisionMapNode) {
            HashCollisionMapNode hashCollisionMapNode = (HashCollisionMapNode)mapNode;
            throw new RuntimeException("Cannot merge BitmapIndexedMapNode with HashCollisionMapNode");
        }
        throw new MatchError(mapNode);
    }

    public boolean equals(Object that) {
        Object object = that;
        if (object instanceof BitmapIndexedMapNode) {
            BitmapIndexedMapNode bitmapIndexedMapNode = (BitmapIndexedMapNode)object;
            BitmapIndexedMapNode node = bitmapIndexedMapNode;
            return this == node || this.cachedJavaKeySetHashCode() == node.cachedJavaKeySetHashCode() && this.nodeMap() == node.nodeMap() && this.dataMap() == node.dataMap() && this.size() == node.size() && Arrays.equals(this.originalHashes(), node.originalHashes()) && this.deepContentEquality(this.content(), node.content(), this.content().length);
        }
        return false;
    }

    private boolean deepContentEquality(Object[] a1, Object[] a2, int length) {
        if (a1 == a2) {
            return true;
        }
        boolean isEqual = true;
        for (int i = 0; isEqual && i < length; ++i) {
            isEqual = BoxesRunTime.equals(a1[i], a2[i]);
        }
        return isEqual;
    }

    public int hashCode() {
        throw new UnsupportedOperationException("Trie nodes do not support hashing.");
    }

    public String toString() {
        return new StringBuilder(1).append(this.getClass().getName()).append("@").append(Integer.toHexString(System.identityHashCode(this))).toString();
    }

    @Override
    public <V1> BitmapIndexedMapNode<K, V1> concat(MapNode<K, V1> that, int shift) {
        MapNode<K, V1> mapNode = that;
        if (mapNode instanceof BitmapIndexedMapNode) {
            BitmapIndexedMapNode bitmapIndexedMapNode;
            BitmapIndexedMapNode bm = bitmapIndexedMapNode = (BitmapIndexedMapNode)mapNode;
            if (this.size() == 0) {
                return bm;
            }
            if (bm.size() == 0 || bm == this) {
                return this;
            }
            if (bm.size() == 1) {
                int originalHash = bm.getHash(0);
                return this.updated((Object)bm.getKey(0), bm.getValue(0), originalHash, Hashing$.MODULE$.improve(originalHash), shift, true);
            }
            boolean anyChangesMadeSoFar = false;
            int allMap = this.dataMap() | bm.dataMap() | this.nodeMap() | bm.nodeMap();
            int minimumBitPos = Node$.MODULE$.bitposFrom(Integer.numberOfTrailingZeros(allMap));
            int maximumBitPos = Node$.MODULE$.bitposFrom(32 - Integer.numberOfLeadingZeros(allMap) - 1);
            int leftNodeRightNode = 0;
            int leftDataRightNode = 0;
            int leftNodeRightData = 0;
            int leftDataOnly = 0;
            int rightDataOnly = 0;
            int leftNodeOnly = 0;
            int rightNodeOnly = 0;
            int leftDataRightDataMigrateToNode = 0;
            int leftDataRightDataRightOverwrites = 0;
            int dataToNodeMigrationTargets = 0;
            int bitpos = minimumBitPos;
            int leftIdx = 0;
            int rightIdx = 0;
            boolean finished = false;
            while (!finished) {
                if ((bitpos & this.dataMap()) != 0) {
                    if ((bitpos & bm.dataMap()) != 0) {
                        int leftOriginalHash = this.getHash(leftIdx);
                        if (leftOriginalHash == bm.getHash(rightIdx) && BoxesRunTime.equals(this.getKey(leftIdx), bm.getKey(rightIdx))) {
                            leftDataRightDataRightOverwrites |= bitpos;
                        } else {
                            leftDataRightDataMigrateToNode |= bitpos;
                            dataToNodeMigrationTargets |= Node$.MODULE$.bitposFrom(Node$.MODULE$.maskFrom(Hashing$.MODULE$.improve(leftOriginalHash), shift));
                        }
                        ++rightIdx;
                    } else if ((bitpos & bm.nodeMap()) != 0) {
                        leftDataRightNode |= bitpos;
                    } else {
                        leftDataOnly |= bitpos;
                    }
                    ++leftIdx;
                } else if ((bitpos & this.nodeMap()) != 0) {
                    if ((bitpos & bm.dataMap()) != 0) {
                        leftNodeRightData |= bitpos;
                        ++rightIdx;
                    } else if ((bitpos & bm.nodeMap()) != 0) {
                        leftNodeRightNode |= bitpos;
                    } else {
                        leftNodeOnly |= bitpos;
                    }
                } else if ((bitpos & bm.dataMap()) != 0) {
                    rightDataOnly |= bitpos;
                    ++rightIdx;
                } else if ((bitpos & bm.nodeMap()) != 0) {
                    rightNodeOnly |= bitpos;
                }
                if (bitpos == maximumBitPos) {
                    finished = true;
                    continue;
                }
                bitpos <<= 1;
            }
            int newDataMap = leftDataOnly | rightDataOnly | leftDataRightDataRightOverwrites;
            int newNodeMap = leftNodeRightNode | leftDataRightNode | leftNodeRightData | leftNodeOnly | rightNodeOnly | dataToNodeMigrationTargets;
            if (newDataMap == (rightDataOnly | leftDataRightDataRightOverwrites) && newNodeMap == rightNodeOnly) {
                return bm;
            }
            int newDataSize = Integer.bitCount(newDataMap);
            int newContentSize = 2 * newDataSize + Integer.bitCount(newNodeMap);
            Object[] newContent = new Object[newContentSize];
            int[] newOriginalHashes = new int[newDataSize];
            int newSize = 0;
            int newCachedHashCode = 0;
            int leftDataIdx = 0;
            int rightDataIdx = 0;
            int leftNodeIdx = 0;
            int rightNodeIdx = 0;
            int nextShift = shift + 5;
            int compressedDataIdx = 0;
            int compressedNodeIdx = 0;
            int bitpos2 = minimumBitPos;
            boolean finished2 = false;
            while (!finished2) {
                if ((bitpos2 & leftNodeRightNode) != 0) {
                    MapNode newNode;
                    Node rightNode = bm.getNode(rightNodeIdx);
                    if (rightNode != (newNode = ((MapNode)this.getNode(leftNodeIdx)).concat(rightNode, nextShift))) {
                        anyChangesMadeSoFar = true;
                    }
                    newContent[newContentSize - compressedNodeIdx - 1] = newNode;
                    ++compressedNodeIdx;
                    ++rightNodeIdx;
                    ++leftNodeIdx;
                    newSize += newNode.size();
                    newCachedHashCode += newNode.cachedJavaKeySetHashCode();
                } else if ((bitpos2 & leftDataRightNode) != 0) {
                    MapNode<K, V> newNode;
                    int leftImproved;
                    int leftOriginalHash;
                    V leftValue;
                    K leftKey;
                    Node n = bm.getNode(rightNodeIdx);
                    MapNode<K, V> updated = ((MapNode)n).updated(leftKey = this.getKey(leftDataIdx), leftValue = this.getValue(leftDataIdx), leftOriginalHash = this.getHash(leftDataIdx), leftImproved = Hashing$.MODULE$.improve(leftOriginalHash), nextShift, false);
                    if (updated != n) {
                        anyChangesMadeSoFar = true;
                    }
                    newContent[newContentSize - compressedNodeIdx - 1] = newNode = updated;
                    ++compressedNodeIdx;
                    ++rightNodeIdx;
                    ++leftDataIdx;
                    newSize += newNode.size();
                    newCachedHashCode += newNode.cachedJavaKeySetHashCode();
                } else if ((bitpos2 & leftNodeRightData) != 0) {
                    MapNode<K, V> newNode;
                    anyChangesMadeSoFar = true;
                    int rightOriginalHash = bm.getHash(rightDataIdx);
                    newContent[newContentSize - compressedNodeIdx - 1] = newNode = ((MapNode)this.getNode(leftNodeIdx)).updated(bm.getKey(rightDataIdx), bm.getValue(rightDataIdx), bm.getHash(rightDataIdx), Hashing$.MODULE$.improve(rightOriginalHash), nextShift, true);
                    ++compressedNodeIdx;
                    ++leftNodeIdx;
                    ++rightDataIdx;
                    newSize += newNode.size();
                    newCachedHashCode += newNode.cachedJavaKeySetHashCode();
                } else if ((bitpos2 & leftDataOnly) != 0) {
                    anyChangesMadeSoFar = true;
                    int originalHash = this.originalHashes()[leftDataIdx];
                    newContent[2 * compressedDataIdx] = this.getKey(leftDataIdx);
                    newContent[2 * compressedDataIdx + 1] = this.getValue(leftDataIdx);
                    newOriginalHashes[compressedDataIdx] = originalHash;
                    ++compressedDataIdx;
                    ++leftDataIdx;
                    ++newSize;
                    newCachedHashCode += Hashing$.MODULE$.improve(originalHash);
                } else if ((bitpos2 & rightDataOnly) != 0) {
                    int originalHash = bm.originalHashes()[rightDataIdx];
                    newContent[2 * compressedDataIdx] = bm.getKey(rightDataIdx);
                    newContent[2 * compressedDataIdx + 1] = bm.getValue(rightDataIdx);
                    newOriginalHashes[compressedDataIdx] = originalHash;
                    ++compressedDataIdx;
                    ++rightDataIdx;
                    ++newSize;
                    newCachedHashCode += Hashing$.MODULE$.improve(originalHash);
                } else if ((bitpos2 & leftNodeOnly) != 0) {
                    anyChangesMadeSoFar = true;
                    Node newNode = this.getNode(leftNodeIdx);
                    newContent[newContentSize - compressedNodeIdx - 1] = newNode;
                    ++compressedNodeIdx;
                    ++leftNodeIdx;
                    newSize += ((MapNode)newNode).size();
                    newCachedHashCode += newNode.cachedJavaKeySetHashCode();
                } else if ((bitpos2 & rightNodeOnly) != 0) {
                    Node newNode = bm.getNode(rightNodeIdx);
                    newContent[newContentSize - compressedNodeIdx - 1] = newNode;
                    ++compressedNodeIdx;
                    ++rightNodeIdx;
                    newSize += ((MapNode)newNode).size();
                    newCachedHashCode += newNode.cachedJavaKeySetHashCode();
                } else if ((bitpos2 & leftDataRightDataMigrateToNode) != 0) {
                    MapNode<K, V> newNode;
                    anyChangesMadeSoFar = true;
                    int leftOriginalHash = this.getHash(leftDataIdx);
                    int rightOriginalHash = bm.getHash(rightDataIdx);
                    newContent[newContentSize - compressedNodeIdx - 1] = newNode = bm.mergeTwoKeyValPairs(this.getKey(leftDataIdx), this.getValue(leftDataIdx), leftOriginalHash, Hashing$.MODULE$.improve(leftOriginalHash), bm.getKey(rightDataIdx), bm.getValue(rightDataIdx), rightOriginalHash, Hashing$.MODULE$.improve(rightOriginalHash), nextShift);
                    ++compressedNodeIdx;
                    ++leftDataIdx;
                    ++rightDataIdx;
                    newSize += newNode.size();
                    newCachedHashCode += newNode.cachedJavaKeySetHashCode();
                } else if ((bitpos2 & leftDataRightDataRightOverwrites) != 0) {
                    int originalHash = bm.originalHashes()[rightDataIdx];
                    newContent[2 * compressedDataIdx] = bm.getKey(rightDataIdx);
                    newContent[2 * compressedDataIdx + 1] = bm.getValue(rightDataIdx);
                    newOriginalHashes[compressedDataIdx] = originalHash;
                    ++compressedDataIdx;
                    ++rightDataIdx;
                    ++newSize;
                    newCachedHashCode += Hashing$.MODULE$.improve(originalHash);
                    ++leftDataIdx;
                }
                if (bitpos2 == maximumBitPos) {
                    finished2 = true;
                    continue;
                }
                bitpos2 <<= 1;
            }
            if (anyChangesMadeSoFar) {
                return new BitmapIndexedMapNode<K, V>(newDataMap, newNodeMap, newContent, newOriginalHashes, newSize, newCachedHashCode);
            }
            return bm;
        }
        throw new UnsupportedOperationException("Cannot concatenate a HashCollisionMapNode with a BitmapIndexedMapNode");
    }

    @Override
    public BitmapIndexedMapNode<K, V> copy() {
        Object[] contentClone = (Object[])this.content().clone();
        int contentLength = contentClone.length;
        for (int i = Integer.bitCount(this.dataMap()) * 2; i < contentLength; ++i) {
            contentClone[i] = ((MapNode)contentClone[i]).copy();
        }
        return new BitmapIndexedMapNode<K, V>(this.dataMap(), this.nodeMap(), contentClone, (int[])this.originalHashes().clone(), this.size(), this.cachedJavaKeySetHashCode());
    }

    @Override
    public BitmapIndexedMapNode<K, V> filterImpl(Function1<Tuple2<K, V>, Object> pred, boolean flipped) {
        if (this.size() == 0) {
            return this;
        }
        if (this.size() == 1) {
            if (BoxesRunTime.unboxToBoolean(pred.apply((Tuple2<K, V>)this.getPayload(0))) != flipped) {
                return this;
            }
            return MapNode$.MODULE$.empty();
        }
        if (this.nodeMap() == 0) {
            int minimumIndex = Integer.numberOfTrailingZeros(this.dataMap());
            int maximumIndex = 32 - Integer.numberOfLeadingZeros(this.dataMap());
            int newDataMap = 0;
            int newCachedHashCode = 0;
            int dataIndex = 0;
            for (int i = minimumIndex; i < maximumIndex; ++i) {
                boolean passed;
                int bitpos = Node$.MODULE$.bitposFrom(i);
                if ((bitpos & this.dataMap()) == 0) continue;
                Object payload = this.getPayload(dataIndex);
                boolean bl = passed = BoxesRunTime.unboxToBoolean(pred.apply((Tuple2<K, V>)payload)) != flipped;
                if (passed) {
                    newDataMap |= bitpos;
                    newCachedHashCode += Hashing$.MODULE$.improve(this.getHash(dataIndex));
                }
                ++dataIndex;
            }
            if (newDataMap == 0) {
                return MapNode$.MODULE$.empty();
            }
            if (newDataMap == this.dataMap()) {
                return this;
            }
            int newSize = Integer.bitCount(newDataMap);
            Object[] newContent = new Object[newSize * 2];
            int[] newOriginalHashCodes = new int[newSize];
            int newMaximumIndex = 32 - Integer.numberOfLeadingZeros(newDataMap);
            int newDataIndex = 0;
            for (int j = Integer.numberOfTrailingZeros(newDataMap); j < newMaximumIndex; ++j) {
                int bitpos = Node$.MODULE$.bitposFrom(j);
                if ((bitpos & newDataMap) == 0) continue;
                int oldIndex = Node$.MODULE$.indexFrom(this.dataMap(), bitpos);
                newContent[newDataIndex * 2] = this.content()[oldIndex * 2];
                newContent[newDataIndex * 2 + 1] = this.content()[oldIndex * 2 + 1];
                newOriginalHashCodes[newDataIndex] = this.originalHashes()[oldIndex];
                ++newDataIndex;
            }
            return new BitmapIndexedMapNode<K, V>(newDataMap, 0, newContent, newOriginalHashCodes, newSize, newCachedHashCode);
        }
        int allMap = this.dataMap() | this.nodeMap();
        int minimumIndex = Integer.numberOfTrailingZeros(allMap);
        int maximumIndex = 32 - Integer.numberOfLeadingZeros(allMap);
        int oldDataPassThrough = 0;
        int nodeMigrateToDataTargetMap = 0;
        AbstractBuffer nodesToMigrateToData = null;
        int nodesToPassThroughMap = 0;
        int mapOfNewNodes = 0;
        Object newNodes = null;
        int newDataMap = 0;
        int newNodeMap = 0;
        int newSize = 0;
        int newCachedHashCode = 0;
        int dataIndex = 0;
        int nodeIndex = 0;
        for (int i = minimumIndex; i < maximumIndex; ++i) {
            int bitpos = Node$.MODULE$.bitposFrom(i);
            if ((bitpos & this.dataMap()) != 0) {
                boolean passed;
                Object payload = this.getPayload(dataIndex);
                boolean bl = passed = BoxesRunTime.unboxToBoolean(pred.apply((Tuple2<K, V>)payload)) != flipped;
                if (passed) {
                    newDataMap |= bitpos;
                    oldDataPassThrough |= bitpos;
                    ++newSize;
                    newCachedHashCode += Hashing$.MODULE$.improve(this.getHash(dataIndex));
                }
                ++dataIndex;
                continue;
            }
            if ((bitpos & this.nodeMap()) == 0) continue;
            Node oldSubNode = this.getNode(nodeIndex);
            MapNode<K, V> newSubNode = ((MapNode)oldSubNode).filterImpl(pred, flipped);
            newSize += newSubNode.size();
            newCachedHashCode += newSubNode.cachedJavaKeySetHashCode();
            if (newSubNode.size() > 1) {
                newNodeMap |= bitpos;
                if (oldSubNode == newSubNode) {
                    nodesToPassThroughMap |= bitpos;
                } else {
                    mapOfNewNodes |= bitpos;
                    if (newNodes == null) {
                        newNodes = Queue$.MODULE$.empty();
                    }
                    ((AbstractBuffer)newNodes).$plus$eq(newSubNode);
                }
            } else if (newSubNode.size() == 1) {
                newDataMap |= bitpos;
                nodeMigrateToDataTargetMap |= bitpos;
                if (nodesToMigrateToData == null) {
                    nodesToMigrateToData = (Queue)Queue$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new MapNode[0]));
                }
                nodesToMigrateToData.$plus$eq(newSubNode);
            }
            ++nodeIndex;
        }
        if (newSize == 0) {
            return MapNode$.MODULE$.empty();
        }
        if (newSize == this.size()) {
            return this;
        }
        int newDataSize = Integer.bitCount(newDataMap);
        int newContentSize = 2 * newDataSize + Integer.bitCount(newNodeMap);
        Object[] newContent = new Object[newContentSize];
        int[] newOriginalHashes = new int[newDataSize];
        int newAllMap = newDataMap | newNodeMap;
        int maxIndex = 32 - Integer.numberOfLeadingZeros(newAllMap);
        int oldDataIndex = 0;
        int oldNodeIndex = 0;
        int newDataIndex = 0;
        int newNodeIndex = 0;
        for (int i = minimumIndex; i < maxIndex; ++i) {
            int bitpos = Node$.MODULE$.bitposFrom(i);
            if ((bitpos & oldDataPassThrough) != 0) {
                newContent[newDataIndex * 2] = this.getKey(oldDataIndex);
                newContent[newDataIndex * 2 + 1] = this.getValue(oldDataIndex);
                newOriginalHashes[newDataIndex] = this.getHash(oldDataIndex);
                ++newDataIndex;
                ++oldDataIndex;
                continue;
            }
            if ((bitpos & nodesToPassThroughMap) != 0) {
                newContent[newContentSize - newNodeIndex - 1] = this.getNode(oldNodeIndex);
                ++newNodeIndex;
                ++oldNodeIndex;
                continue;
            }
            if ((bitpos & nodeMigrateToDataTargetMap) != 0) {
                AbstractBuffer x$proxy4 = nodesToMigrateToData;
                if (x$proxy4 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                MapNode node = (MapNode)((Queue)x$proxy4).dequeue();
                newContent[2 * newDataIndex] = node.getKey(0);
                newContent[2 * newDataIndex + 1] = node.getValue(0);
                newOriginalHashes[newDataIndex] = node.getHash(0);
                ++newDataIndex;
                ++oldNodeIndex;
                continue;
            }
            if ((bitpos & mapOfNewNodes) != 0) {
                Object x$proxy5 = newNodes;
                if (x$proxy5 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                newContent[newContentSize - newNodeIndex - 1] = ((Queue)x$proxy5).dequeue();
                ++newNodeIndex;
                ++oldNodeIndex;
                continue;
            }
            if ((bitpos & this.dataMap()) != 0) {
                ++oldDataIndex;
                continue;
            }
            if ((bitpos & this.nodeMap()) == 0) continue;
            ++oldNodeIndex;
        }
        return new BitmapIndexedMapNode<K, V>(newDataMap, newNodeMap, newContent, newOriginalHashes, newSize, newCachedHashCode);
    }
}

