/*
 * Decompiled with CFR 0.152.
 */
package scala.io;

import java.io.Serializable;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import scala.Function0;
import scala.Function1;
import scala.io.Codec$;
import scala.runtime.BoxesRunTime;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Codec {
    private final Charset charSet;
    private CodingErrorAction _onMalformedInput;
    private CodingErrorAction _onUnmappableCharacter;
    private byte[] _encodingReplacement;
    private String _decodingReplacement;
    private Function1<CharacterCodingException, Object> _onCodingException;

    public static Codec ISO8859() {
        return Codec$.MODULE$.ISO8859();
    }

    public static Codec UTF8() {
        return Codec$.MODULE$.UTF8();
    }

    public static Codec apply(Charset charset) {
        return Codec$.MODULE$.apply(charset);
    }

    public static Codec apply(CharsetDecoder charsetDecoder) {
        return Codec$.MODULE$.apply(charsetDecoder);
    }

    public static Codec apply(String string2) {
        return Codec$.MODULE$.apply(string2);
    }

    public static Codec charset2codec(Charset charset) {
        return Codec$.MODULE$.charset2codec(charset);
    }

    public static Codec decoder2codec(CharsetDecoder charsetDecoder) {
        return Codec$.MODULE$.decoder2codec(charsetDecoder);
    }

    public static Codec default() {
        return Codec$.MODULE$.default();
    }

    public static Codec defaultCharsetCodec() {
        return Codec$.MODULE$.defaultCharsetCodec();
    }

    public static Codec fallbackSystemCodec() {
        return Codec$.MODULE$.fallbackSystemCodec();
    }

    public static Codec fileEncodingCodec() {
        return Codec$.MODULE$.fileEncodingCodec();
    }

    public static char[] fromUTF8(byte[] byArray) {
        return Codec$.MODULE$.fromUTF8(byArray);
    }

    public static char[] fromUTF8(byte[] byArray, int n, int n2) {
        return Codec$.MODULE$.fromUTF8(byArray, n, n2);
    }

    public static Codec string2codec(String string2) {
        return Codec$.MODULE$.string2codec(string2);
    }

    public static byte[] toUTF8(CharSequence charSequence) {
        return Codec$.MODULE$.toUTF8(charSequence);
    }

    public static byte[] toUTF8(char[] cArray, int n, int n2) {
        return Codec$.MODULE$.toUTF8(cArray, n, n2);
    }

    public Codec(Charset charSet) {
        this.charSet = charSet;
        this._onMalformedInput = null;
        this._onUnmappableCharacter = null;
        this._encodingReplacement = null;
        this._decodingReplacement = null;
        this._onCodingException = (Function1<CharacterCodingException, Integer> & Serializable)e -> {
            throw e;
        };
    }

    public Charset charSet() {
        return this.charSet;
    }

    public String toString() {
        return this.name();
    }

    public Codec onMalformedInput(CodingErrorAction newAction) {
        this._onMalformedInput = newAction;
        return this;
    }

    public Codec onUnmappableCharacter(CodingErrorAction newAction) {
        this._onUnmappableCharacter = newAction;
        return this;
    }

    public Codec decodingReplaceWith(String newReplacement) {
        this._decodingReplacement = newReplacement;
        return this;
    }

    public Codec encodingReplaceWith(byte[] newReplacement) {
        this._encodingReplacement = newReplacement;
        return this;
    }

    public Codec onCodingException(Function1<CharacterCodingException, Object> handler) {
        this._onCodingException = handler;
        return this;
    }

    public String name() {
        return this.charSet().name();
    }

    public CharsetEncoder encoder() {
        CharsetEncoder enc = this.charSet().newEncoder();
        if (!(this._onMalformedInput == null)) {
            enc.onMalformedInput(this._onMalformedInput);
        }
        if (!(this._onUnmappableCharacter == null)) {
            enc.onUnmappableCharacter(this._onUnmappableCharacter);
        }
        if (!(this._encodingReplacement == null)) {
            enc.replaceWith(this._encodingReplacement);
        }
        return enc;
    }

    public CharsetDecoder decoder() {
        CharsetDecoder dec = this.charSet().newDecoder();
        if (!(this._onMalformedInput == null)) {
            dec.onMalformedInput(this._onMalformedInput);
        }
        if (!(this._onUnmappableCharacter == null)) {
            dec.onUnmappableCharacter(this._onUnmappableCharacter);
        }
        if (!(this._decodingReplacement == null)) {
            dec.replaceWith(this._decodingReplacement);
        }
        return dec;
    }

    public int wrap(Function0<Object> body) {
        int n;
        try {
            n = BoxesRunTime.unboxToInt(body.apply());
        }
        catch (CharacterCodingException e) {
            n = BoxesRunTime.unboxToInt(this._onCodingException.apply(e));
        }
        return n;
    }
}

