/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.immutable.BitmapIndexedMapNode;
import scala.collection.immutable.HashMapBuilder;
import scala.collection.immutable.MapNode;
import scala.collection.immutable.MapNode$;
import scala.collection.immutable.Node$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.immutable.VectorBuilder;
import scala.collection.mutable.Builder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class HashCollisionMapNode<K, V>
extends MapNode<K, V> {
    private final int originalHash;
    private final int hash;
    private Vector<Tuple2<K, V>> content;

    public HashCollisionMapNode(int originalHash, int hash, Vector<Tuple2<K, V>> content) {
        this.originalHash = originalHash;
        this.hash = hash;
        this.content = content;
        Predef$.MODULE$.require(this.content().length() >= 2);
        Statics.releaseFence();
    }

    public int originalHash() {
        return this.originalHash;
    }

    public int hash() {
        return this.hash;
    }

    public Vector<Tuple2<K, V>> content() {
        return this.content;
    }

    public void content_$eq(Vector<Tuple2<K, V>> x$1) {
        this.content = x$1;
    }

    public int indexOf(Object key) {
        Iterator<Tuple2<K, V>> iter = this.content().iterator();
        int i = 0;
        while (iter.hasNext()) {
            if (BoxesRunTime.equals(iter.next()._1(), key)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int size() {
        return this.content().length();
    }

    @Override
    public V apply(K key, int originalHash, int hash, int shift) {
        return (V)this.get(key, originalHash, hash, shift).getOrElse(HashCollisionMapNode::apply$$anonfun$1);
    }

    @Override
    public Option<V> get(K key, int originalHash, int hash, int shift) {
        if (this.hash() == hash) {
            int index = this.indexOf(key);
            if (index >= 0) {
                return Some$.MODULE$.apply(((Tuple2)this.content().apply(index))._2());
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    @Override
    public Tuple2<K, V> getTuple(K key, int originalHash, int hash, int shift) {
        int index = this.indexOf(key);
        if (index >= 0) {
            return (Tuple2)this.content().apply(index);
        }
        return (Tuple2)Iterator$.MODULE$.empty().next();
    }

    @Override
    public <V1> V1 getOrElse(K key, int originalHash, int hash, int shift, Function0<V1> f) {
        if (this.hash() == hash) {
            int n = this.indexOf(key);
            if (-1 == n) {
                return f.apply();
            }
            int other = n;
            return (V1)((Tuple2)this.content().apply(other))._2();
        }
        return f.apply();
    }

    @Override
    public boolean containsKey(K key, int originalHash, int hash, int shift) {
        return this.hash() == hash && this.indexOf(key) >= 0;
    }

    public <V1> boolean contains(K key, V1 value, int hash, int shift) {
        int index;
        return this.hash() == hash && (index = this.indexOf(key)) >= 0 && ((Tuple2)this.content().apply(index))._2() == value;
    }

    @Override
    public <V1> MapNode<K, V1> updated(K key, V1 value, int originalHash, int hash, int shift, boolean replaceValue) {
        int index = this.indexOf(key);
        if (index >= 0) {
            if (replaceValue) {
                if (((Tuple2)this.content().apply(index))._2() == value) {
                    return this;
                }
                return new HashCollisionMapNode<K, V>(originalHash, hash, this.content().updated(index, Tuple2$.MODULE$.apply(key, value)));
            }
            return this;
        }
        return new HashCollisionMapNode<K, V>(originalHash, hash, this.content().appended(Tuple2$.MODULE$.apply(key, value)));
    }

    @Override
    public <V1> MapNode<K, V1> removed(K key, int originalHash, int hash, int shift) {
        if (!this.containsKey(key, originalHash, hash, shift)) {
            return this;
        }
        Vector updatedContent = (Vector)this.content().filterNot((Function1<Tuple2, Boolean> & Serializable)keyValuePair -> BoxesRunTime.equals(keyValuePair._1(), key));
        int n = updatedContent.size();
        if (1 == n) {
            Tuple2 tuple2;
            Tuple2 $7$;
            Tuple2 tuple22 = $7$ = (tuple2 = (Tuple2)updatedContent.apply(false));
            Object k = tuple22._1();
            Object v = tuple22._2();
            return new BitmapIndexedMapNode(Node$.MODULE$.bitposFrom(Node$.MODULE$.maskFrom(hash, 0)), 0, (Object[])Array$.MODULE$.apply(ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{k, v}), ClassTag$.MODULE$.Any()), new int[]{originalHash}, 1, hash);
        }
        return new HashCollisionMapNode<K, V>(originalHash, hash, updatedContent);
    }

    @Override
    public boolean hasNodes() {
        return false;
    }

    @Override
    public int nodeArity() {
        return 0;
    }

    @Override
    public MapNode<K, V> getNode(int index) {
        throw new IndexOutOfBoundsException("No sub-nodes present in hash-collision leaf node.");
    }

    @Override
    public boolean hasPayload() {
        return true;
    }

    @Override
    public int payloadArity() {
        return this.content().length();
    }

    @Override
    public K getKey(int index) {
        return (K)((Tuple2)this.getPayload(index))._1();
    }

    @Override
    public V getValue(int index) {
        return (V)((Tuple2)this.getPayload(index))._2();
    }

    @Override
    public Tuple2<K, V> getPayload(int index) {
        return (Tuple2)this.content().apply(index);
    }

    @Override
    public int getHash(int index) {
        return this.originalHash();
    }

    @Override
    public <U> void foreach(Function1<Tuple2<K, V>, U> f) {
        this.content().foreach(f);
    }

    @Override
    public <U> void foreachEntry(Function2<K, V, U> f) {
        this.content().foreach((Function1<Tuple2, Object> & Serializable)(A x$1) -> {
            Tuple2 tuple2 = x$1;
            Object k = tuple2._1();
            Object v = tuple2._2();
            return f.apply(k, v);
        });
    }

    @Override
    public void foreachWithHash(Function3<K, V, Object, BoxedUnit> f) {
        Iterator<Tuple2<K, V>> iter = this.content().iterator();
        while (iter.hasNext()) {
            Tuple2<K, V> next = iter.next();
            f.apply(next._1(), next._2(), BoxesRunTime.boxToInteger(this.originalHash()));
        }
    }

    @Override
    public <W> HashCollisionMapNode<K, W> transform(Function2<K, V, W> f) {
        Builder newContent = Vector$.MODULE$.newBuilder();
        Iterator<Tuple2<K, V>> contentIter = this.content().iterator();
        boolean anyChanges = false;
        while (contentIter.hasNext()) {
            Tuple2<K, V> tuple2;
            Tuple2<K, V> $9$;
            Tuple2<K, V> tuple22 = $9$ = (tuple2 = contentIter.next());
            K k = tuple22._1();
            V v = tuple22._2();
            W newValue = f.apply(k, v);
            newContent.addOne(Tuple2$.MODULE$.apply(k, newValue));
            anyChanges = anyChanges || v != newValue;
        }
        if (anyChanges) {
            return new HashCollisionMapNode<K, V>(this.originalHash(), this.hash(), (Vector)newContent.result());
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        Object object = that;
        if (!(object instanceof HashCollisionMapNode)) return false;
        HashCollisionMapNode hashCollisionMapNode = (HashCollisionMapNode)object;
        HashCollisionMapNode node = hashCollisionMapNode;
        if (this == node) return true;
        if (this.hash() != node.hash()) return false;
        if (this.content().length() != node.content().length()) return false;
        Iterator<Tuple2<K, V>> iter = this.content().iterator();
        while (iter.hasNext()) {
            Tuple2<K, V> tuple2;
            Tuple2<K, V> $11$;
            Tuple2<K, V> tuple22 = $11$ = (tuple2 = iter.next());
            K key = tuple22._1();
            V value = tuple22._2();
            int index = node.indexOf(key);
            if (index < 0) return false;
            if (BoxesRunTime.equals(value, ((Tuple2)node.content().apply(index))._2())) continue;
            return false;
        }
        if (!true) return false;
        return true;
    }

    @Override
    public <V1> HashCollisionMapNode<K, V1> concat(MapNode<K, V1> that, int shift) {
        MapNode<K, V1> mapNode = that;
        if (mapNode instanceof HashCollisionMapNode) {
            HashCollisionMapNode hashCollisionMapNode = (HashCollisionMapNode)mapNode;
            HashCollisionMapNode hc = hashCollisionMapNode;
            if (hc == this) {
                return this;
            }
            VectorBuilder newContent = null;
            Iterator<Tuple2<K, V>> iter = this.content().iterator();
            while (iter.hasNext()) {
                Tuple2<K, V> nextPayload = iter.next();
                if (hc.indexOf(nextPayload._1()) >= 0) continue;
                if (newContent == null) {
                    newContent = new VectorBuilder();
                    newContent.addAll((IterableOnce)hc.content());
                }
                newContent.addOne(nextPayload);
            }
            if (newContent == null) {
                return hc;
            }
            return new HashCollisionMapNode<K, V>(this.originalHash(), this.hash(), newContent.result());
        }
        if (mapNode instanceof BitmapIndexedMapNode) {
            BitmapIndexedMapNode bitmapIndexedMapNode = (BitmapIndexedMapNode)mapNode;
            throw new UnsupportedOperationException("Cannot concatenate a HashCollisionMapNode with a BitmapIndexedMapNode");
        }
        throw new MatchError(mapNode);
    }

    @Override
    public <V1> void mergeInto(MapNode<K, V1> that, HashMapBuilder<K, V1> builder, int shift, Function2<Tuple2<K, V>, Tuple2<K, V1>, Tuple2<K, V1>> mergef) {
        MapNode<K, V1> mapNode = that;
        if (mapNode instanceof HashCollisionMapNode) {
            HashCollisionMapNode hashCollisionMapNode;
            HashCollisionMapNode hc = hashCollisionMapNode = (HashCollisionMapNode)mapNode;
            Iterator<Tuple2<K, V>> iter = this.content().iterator();
            Object[] rightArray = (Object[])hc.content().toArray(ClassTag$.MODULE$.apply(Object.class));
            while (iter.hasNext()) {
                Tuple2<K, V> nextPayload = iter.next();
                int index = HashCollisionMapNode.rightIndexOf$1(rightArray, nextPayload._1());
                if (index == -1) {
                    builder.addOne(nextPayload);
                    continue;
                }
                Tuple2 rightPayload = (Tuple2)rightArray[index];
                rightArray[index] = null;
                builder.addOne(mergef.apply(nextPayload, rightPayload));
            }
            for (int i = 0; i < rightArray.length; ++i) {
                Object elem = rightArray[i];
                if (!(!(elem == null))) continue;
                builder.addOne((Tuple2)elem);
            }
            return;
        }
        if (mapNode instanceof BitmapIndexedMapNode) {
            BitmapIndexedMapNode bitmapIndexedMapNode = (BitmapIndexedMapNode)mapNode;
            throw new RuntimeException("Cannot merge HashCollisionMapNode with BitmapIndexedMapNode");
        }
        throw new MatchError(mapNode);
    }

    @Override
    public <V1> void buildTo(HashMapBuilder<K, V1> builder) {
        Iterator<Tuple2<K, V>> iter = this.content().iterator();
        while (iter.hasNext()) {
            Tuple2<K, V> tuple2;
            Tuple2<K, V> $13$;
            Tuple2<K, V> tuple22 = $13$ = (tuple2 = iter.next());
            K k = tuple22._1();
            V v = tuple22._2();
            builder.addOne(k, v, this.originalHash(), this.hash());
        }
    }

    @Override
    public MapNode<K, V> filterImpl(Function1<Tuple2<K, V>, Object> pred, boolean flipped) {
        Object newContent = this.content().filterImpl((Function1)pred, flipped);
        int newContentLength = ((Vector)newContent).length();
        if (newContentLength == 0) {
            return MapNode$.MODULE$.empty();
        }
        if (newContentLength == 1) {
            Tuple2 tuple2;
            Tuple2 $15$;
            Tuple2 tuple22 = $15$ = (tuple2 = (Tuple2)((Vector)newContent).head());
            Object k = tuple22._1();
            Object v = tuple22._2();
            return new BitmapIndexedMapNode(Node$.MODULE$.bitposFrom(Node$.MODULE$.maskFrom(this.hash(), 0)), 0, (Object[])Array$.MODULE$.apply(ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{k, v}), ClassTag$.MODULE$.Any()), new int[]{this.originalHash()}, 1, this.hash());
        }
        if (newContentLength == this.content().length()) {
            return this;
        }
        return new HashCollisionMapNode<K, V>(this.originalHash(), this.hash(), newContent);
    }

    @Override
    public HashCollisionMapNode<K, V> copy() {
        return new HashCollisionMapNode<K, V>(this.originalHash(), this.hash(), this.content());
    }

    public int hashCode() {
        throw new UnsupportedOperationException("Trie nodes do not support hashing.");
    }

    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(this));
    }

    @Override
    public int cachedJavaKeySetHashCode() {
        return this.size() * this.hash();
    }

    private static final Object apply$$anonfun$1() {
        return Iterator$.MODULE$.empty().next();
    }

    private static final int rightIndexOf$1(Object[] rightArray$1, Object key) {
        for (int i = 0; i < rightArray$1.length; ++i) {
            Object elem = rightArray$1[i];
            if (!(!(elem == null)) || !BoxesRunTime.equals(((Tuple2)elem)._1(), key)) continue;
            return i;
        }
        return -1;
    }
}

