/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.duration;

import java.util.concurrent.TimeUnit;
import scala.MatchError;
import scala.Predef$;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration$;
import scala.concurrent.duration.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;

public final class FiniteDuration
extends Duration {
    private final long length;
    private final TimeUnit unit;

    public static FiniteDuration apply(long l, String string2) {
        return FiniteDuration$.MODULE$.apply(l, string2);
    }

    public static FiniteDuration apply(long l, TimeUnit timeUnit) {
        return FiniteDuration$.MODULE$.apply(l, timeUnit);
    }

    public FiniteDuration(long length, TimeUnit unit) {
        boolean bl;
        this.length = length;
        this.unit = unit;
        TimeUnit timeUnit = unit;
        TimeUnit timeUnit2 = package$.MODULE$.NANOSECONDS();
        TimeUnit timeUnit3 = timeUnit;
        if (!(timeUnit2 != null ? !((Object)((Object)timeUnit2)).equals((Object)timeUnit3) : timeUnit3 != null)) {
            bl = this.bounded(Long.MAX_VALUE);
        } else {
            TimeUnit timeUnit4 = package$.MODULE$.MICROSECONDS();
            TimeUnit timeUnit5 = timeUnit;
            if (!(timeUnit4 != null ? !((Object)((Object)timeUnit4)).equals((Object)timeUnit5) : timeUnit5 != null)) {
                bl = this.bounded(9223372036854775L);
            } else {
                TimeUnit timeUnit6 = package$.MODULE$.MILLISECONDS();
                TimeUnit timeUnit7 = timeUnit;
                if (!(timeUnit6 != null ? !((Object)((Object)timeUnit6)).equals((Object)timeUnit7) : timeUnit7 != null)) {
                    bl = this.bounded(9223372036854L);
                } else {
                    TimeUnit timeUnit8 = package$.MODULE$.SECONDS();
                    TimeUnit timeUnit9 = timeUnit;
                    if (!(timeUnit8 != null ? !((Object)((Object)timeUnit8)).equals((Object)timeUnit9) : timeUnit9 != null)) {
                        bl = this.bounded(9223372036L);
                    } else {
                        TimeUnit timeUnit10 = package$.MODULE$.MINUTES();
                        TimeUnit timeUnit11 = timeUnit;
                        if (!(timeUnit10 != null ? !((Object)((Object)timeUnit10)).equals((Object)timeUnit11) : timeUnit11 != null)) {
                            bl = this.bounded(153722867L);
                        } else {
                            TimeUnit timeUnit12 = package$.MODULE$.HOURS();
                            TimeUnit timeUnit13 = timeUnit;
                            if (!(timeUnit12 != null ? !((Object)((Object)timeUnit12)).equals((Object)timeUnit13) : timeUnit13 != null)) {
                                bl = this.bounded(2562047L);
                            } else {
                                TimeUnit timeUnit14 = package$.MODULE$.DAYS();
                                TimeUnit timeUnit15 = timeUnit;
                                if (!(timeUnit14 != null ? !((Object)((Object)timeUnit14)).equals((Object)timeUnit15) : timeUnit15 != null)) {
                                    bl = this.bounded(106751L);
                                } else {
                                    long v = package$.MODULE$.DAYS().convert(length, unit);
                                    bl = -106751L <= v && v <= 106751L;
                                }
                            }
                        }
                    }
                }
            }
        }
        Predef$.MODULE$.require(bl, FiniteDuration::$init$$$anonfun$3);
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public TimeUnit unit() {
        return this.unit;
    }

    private boolean bounded(long max) {
        return -max <= this.length() && this.length() <= max;
    }

    @Override
    public long toNanos() {
        return this.unit().toNanos(this.length());
    }

    @Override
    public long toMicros() {
        return this.unit().toMicros(this.length());
    }

    @Override
    public long toMillis() {
        return this.unit().toMillis(this.length());
    }

    @Override
    public long toSeconds() {
        return this.unit().toSeconds(this.length());
    }

    @Override
    public long toMinutes() {
        return this.unit().toMinutes(this.length());
    }

    @Override
    public long toHours() {
        return this.unit().toHours(this.length());
    }

    @Override
    public long toDays() {
        return this.unit().toDays(this.length());
    }

    @Override
    public double toUnit(TimeUnit u) {
        return (double)this.toNanos() / (double)package$.MODULE$.NANOSECONDS().convert(1L, u);
    }

    public Deadline fromNow() {
        return Deadline$.MODULE$.now().$plus(this);
    }

    private String unitString() {
        return (String)Duration$.MODULE$.timeUnitName().apply(this.unit()) + (this.length() == 1L ? "" : "s");
    }

    public String toString() {
        return this.length() + " " + this.unitString();
    }

    @Override
    public int compare(Duration other) {
        Duration duration = other;
        if (duration instanceof FiniteDuration) {
            FiniteDuration finiteDuration;
            FiniteDuration x = finiteDuration = (FiniteDuration)duration;
            return new RichLong(Predef$.MODULE$.longWrapper(this.toNanos())).compare(BoxesRunTime.boxToLong(x.toNanos()));
        }
        return -other.compare(this);
    }

    private long safeAdd(long a, long b) {
        if (b > 0L && a > Long.MAX_VALUE - b || b < 0L && a < Long.MIN_VALUE - b) {
            throw new IllegalArgumentException("integer overflow");
        }
        return a + b;
    }

    private FiniteDuration add(long otherLength, TimeUnit otherUnit) {
        TimeUnit commonUnit = otherUnit.convert(1L, this.unit()) == 0L ? this.unit() : otherUnit;
        long totalLength = this.safeAdd(commonUnit.convert(this.length(), this.unit()), commonUnit.convert(otherLength, otherUnit));
        return new FiniteDuration(totalLength, commonUnit);
    }

    @Override
    public Duration $plus(Duration other) {
        Duration duration = other;
        if (duration instanceof FiniteDuration) {
            FiniteDuration finiteDuration;
            FiniteDuration x = finiteDuration = (FiniteDuration)duration;
            return this.add(x.length(), x.unit());
        }
        return other;
    }

    @Override
    public Duration $minus(Duration other) {
        Duration duration = other;
        if (duration instanceof FiniteDuration) {
            FiniteDuration finiteDuration;
            FiniteDuration x = finiteDuration = (FiniteDuration)duration;
            return this.add(-x.length(), x.unit());
        }
        return other.unary_$minus();
    }

    @Override
    public Duration $times(double factor) {
        if (!Predef$.MODULE$.double2Double(factor).isInfinite()) {
            return Duration$.MODULE$.fromNanos((double)this.toNanos() * factor);
        }
        if (Double.isNaN(factor)) {
            return Duration$.MODULE$.Undefined();
        }
        if (factor > 0.0 ^ this.$less(Duration$.MODULE$.Zero())) {
            return Duration$.MODULE$.Inf();
        }
        return Duration$.MODULE$.MinusInf();
    }

    @Override
    public Duration $div(double divisor) {
        if (!Predef$.MODULE$.double2Double(divisor).isInfinite()) {
            return Duration$.MODULE$.fromNanos((double)this.toNanos() / divisor);
        }
        if (Double.isNaN(divisor)) {
            return Duration$.MODULE$.Undefined();
        }
        return Duration$.MODULE$.Zero();
    }

    private double minusZero() {
        return -0.0;
    }

    @Override
    public double $div(Duration divisor) {
        if (divisor.isFinite()) {
            return (double)this.toNanos() / (double)divisor.toNanos();
        }
        if (divisor == Duration$.MODULE$.Undefined()) {
            return Double.NaN;
        }
        if (this.length() < 0L ^ divisor.$greater(Duration$.MODULE$.Zero())) {
            return 0.0;
        }
        return this.minusZero();
    }

    public FiniteDuration $plus(FiniteDuration other) {
        return this.add(other.length(), other.unit());
    }

    public FiniteDuration $minus(FiniteDuration other) {
        return this.add(-other.length(), other.unit());
    }

    public FiniteDuration plus(FiniteDuration other) {
        return this.$plus(other);
    }

    public FiniteDuration minus(FiniteDuration other) {
        return this.$minus(other);
    }

    public FiniteDuration min(FiniteDuration other) {
        if (this.$less(other)) {
            return this;
        }
        return other;
    }

    public FiniteDuration max(FiniteDuration other) {
        if (this.$greater(other)) {
            return this;
        }
        return other;
    }

    public FiniteDuration $div(long divisor) {
        return Duration$.MODULE$.fromNanos(this.toNanos() / divisor);
    }

    public FiniteDuration $times(long factor) {
        return new FiniteDuration(this.safeMul(this.length(), factor), this.unit());
    }

    private long safeMul(long _a, long _b) {
        long a = scala.math.package$.MODULE$.abs(_a);
        long b = scala.math.package$.MODULE$.abs(_b);
        if (Long.numberOfLeadingZeros(a) + Long.numberOfLeadingZeros(b) < 64) {
            throw new IllegalArgumentException("multiplication overflow");
        }
        long product = a * b;
        if (product < 0L) {
            throw new IllegalArgumentException("multiplication overflow");
        }
        if (a == _a ^ b == _b) {
            return -product;
        }
        return product;
    }

    public FiniteDuration div(long divisor) {
        return this.$div(divisor);
    }

    public FiniteDuration mul(long factor) {
        return this.$times(factor);
    }

    @Override
    public FiniteDuration unary_$minus() {
        return Duration$.MODULE$.apply(-this.length(), this.unit());
    }

    @Override
    public final boolean isFinite() {
        return true;
    }

    @Override
    public final FiniteDuration toCoarsest() {
        TimeUnit timeUnit = this.unit();
        TimeUnit timeUnit2 = package$.MODULE$.DAYS();
        if (!(timeUnit == null ? timeUnit2 != null : !((Object)((Object)timeUnit)).equals((Object)timeUnit2)) || this.length() == 0L) {
            return this;
        }
        return this.loop$1(this.length(), this.unit());
    }

    public boolean equals(Object other) {
        Object object = other;
        if (object instanceof FiniteDuration) {
            FiniteDuration finiteDuration;
            FiniteDuration x = finiteDuration = (FiniteDuration)object;
            return this.toNanos() == x.toNanos();
        }
        return super.equals(other);
    }

    public int hashCode() {
        return (int)this.toNanos();
    }

    private static final Object $init$$$anonfun$3() {
        return "Duration is limited to +-(2^63-1)ns (ca. 292 years)";
    }

    private final FiniteDuration coarserOrThis$1(long length$1, TimeUnit unit$4, TimeUnit coarser, int divider) {
        if (length$1 % (long)divider == 0L) {
            return this.loop$1(length$1 / (long)divider, coarser);
        }
        TimeUnit timeUnit = unit$4;
        TimeUnit timeUnit2 = this.unit();
        if (!(timeUnit != null ? !((Object)((Object)timeUnit)).equals((Object)timeUnit2) : timeUnit2 != null)) {
            return this;
        }
        return FiniteDuration$.MODULE$.apply(length$1, unit$4);
    }

    private final FiniteDuration loop$1(long length, TimeUnit unit) {
        TimeUnit timeUnit = unit;
        TimeUnit timeUnit2 = package$.MODULE$.DAYS();
        TimeUnit timeUnit3 = timeUnit;
        if (!(timeUnit2 != null ? !((Object)((Object)timeUnit2)).equals((Object)timeUnit3) : timeUnit3 != null)) {
            return FiniteDuration$.MODULE$.apply(length, unit);
        }
        TimeUnit timeUnit4 = package$.MODULE$.HOURS();
        TimeUnit timeUnit5 = timeUnit;
        if (!(timeUnit4 != null ? !((Object)((Object)timeUnit4)).equals((Object)timeUnit5) : timeUnit5 != null)) {
            return this.coarserOrThis$1(length, unit, package$.MODULE$.DAYS(), 24);
        }
        TimeUnit timeUnit6 = package$.MODULE$.MINUTES();
        TimeUnit timeUnit7 = timeUnit;
        if (!(timeUnit6 != null ? !((Object)((Object)timeUnit6)).equals((Object)timeUnit7) : timeUnit7 != null)) {
            return this.coarserOrThis$1(length, unit, package$.MODULE$.HOURS(), 60);
        }
        TimeUnit timeUnit8 = package$.MODULE$.SECONDS();
        TimeUnit timeUnit9 = timeUnit;
        if (!(timeUnit8 != null ? !((Object)((Object)timeUnit8)).equals((Object)timeUnit9) : timeUnit9 != null)) {
            return this.coarserOrThis$1(length, unit, package$.MODULE$.MINUTES(), 60);
        }
        TimeUnit timeUnit10 = package$.MODULE$.MILLISECONDS();
        TimeUnit timeUnit11 = timeUnit;
        if (!(timeUnit10 != null ? !((Object)((Object)timeUnit10)).equals((Object)timeUnit11) : timeUnit11 != null)) {
            return this.coarserOrThis$1(length, unit, package$.MODULE$.SECONDS(), 1000);
        }
        TimeUnit timeUnit12 = package$.MODULE$.MICROSECONDS();
        TimeUnit timeUnit13 = timeUnit;
        if (!(timeUnit12 != null ? !((Object)((Object)timeUnit12)).equals((Object)timeUnit13) : timeUnit13 != null)) {
            return this.coarserOrThis$1(length, unit, package$.MODULE$.MILLISECONDS(), 1000);
        }
        TimeUnit timeUnit14 = package$.MODULE$.NANOSECONDS();
        TimeUnit timeUnit15 = timeUnit;
        if (!(timeUnit14 != null ? !((Object)((Object)timeUnit14)).equals((Object)timeUnit15) : timeUnit15 != null)) {
            return this.coarserOrThis$1(length, unit, package$.MODULE$.MICROSECONDS(), 1000);
        }
        throw new MatchError((Object)timeUnit);
    }
}

