/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.ArrayList;
import java.util.Set;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.spatial.Geometry;
import org.sbml.jsbml.ext.spatial.SampledFieldGeometry;
import org.sbml.jsbml.ext.spatial.SampledVolume;
import org.sbml.jsbml.ext.spatial.SpatialModelPlugin;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.AbstractValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.ValidationConstraint;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageElementValidationFunction;

public class SampledFieldGeometryConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level < 3) break;
                this.addRangeToSet(set, 1221501, 1221507);
                set.add(1221752);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 1221501: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1221502: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1221503: {
                func = new UnknownPackageAttributeValidationFunction<SampledFieldGeometry>("spatial"){

                    public boolean check(ValidationContext ctx, SampledFieldGeometry sfg) {
                        if (!sfg.isSetSampledField()) {
                            return false;
                        }
                        return super.check(ctx, (TreeNodeWithChangeSupport)sfg);
                    }
                };
                break;
            }
            case 1221504: {
                func = new ValidationFunction<SampledFieldGeometry>(){

                    public boolean check(ValidationContext ctx, SampledFieldGeometry sfg) {
                        return new DuplicatedElementValidationFunction("listOfSampledVolumes").check(ctx, (TreeNodeWithChangeSupport)sfg) && new UnknownPackageElementValidationFunction("spatial").check(ctx, (TreeNodeWithChangeSupport)sfg);
                    }
                };
                break;
            }
            case 1221505: {
                func = new ValidationFunction<SampledFieldGeometry>(){

                    public boolean check(ValidationContext ctx, SampledFieldGeometry sfg) {
                        Geometry g;
                        SpatialModelPlugin smp;
                        return !sfg.isSetSampledField() || !(smp = (SpatialModelPlugin)sfg.getModel().getPlugin("spatial")).isSetGeometry() || (g = smp.getGeometry()).getSampledField(sfg.getSampledField()) != null;
                    }
                };
                break;
            }
            case 1221506: {
                func = new ValidationFunction<SampledFieldGeometry>(){

                    public boolean check(ValidationContext ctx, SampledFieldGeometry sfg) {
                        if (sfg.isSetListOfSampledVolumes()) {
                            return new UnknownElementValidationFunction().check(ctx, sfg.getListOfSampledVolumes());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1221507: {
                func = new ValidationFunction<SampledFieldGeometry>(){

                    public boolean check(ValidationContext ctx, SampledFieldGeometry sfg) {
                        if (sfg.isSetListOfSampledVolumes()) {
                            return new UnknownAttributeValidationFunction().check(ctx, sfg.getListOfSampledVolumes());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1221752: {
                func = new AbstractValidationFunction<SampledFieldGeometry>(){

                    public boolean check(ValidationContext ctx, SampledFieldGeometry sfg) {
                        int i;
                        boolean check = true;
                        ArrayList<Double> sampledValues = new ArrayList<Double>();
                        ArrayList<Double> minValues = new ArrayList<Double>();
                        ArrayList<Double> maxValues = new ArrayList<Double>();
                        for (SampledVolume sv : sfg.getListOfSampledVolumes()) {
                            if (!sv.isSetMinValue() || !sv.isSetMaxValue() || !(sv.getMinValue() < sv.getMaxValue())) continue;
                            for (i = 0; i < minValues.size(); ++i) {
                                if (sv.getMinValue() >= (Double)minValues.get(i) && sv.getMinValue() < (Double)maxValues.get(i)) {
                                    ValidationConstraint.logError((ValidationContext)ctx, (int)1221754, (SBase)sfg, (String[])new String[0]);
                                    check = false;
                                }
                                if (sv.getMaxValue() > (Double)minValues.get(i) && sv.getMaxValue() < (Double)maxValues.get(i)) {
                                    ValidationConstraint.logError((ValidationContext)ctx, (int)1221754, (SBase)sfg, (String[])new String[0]);
                                    check = false;
                                }
                                if (!(sv.getMinValue() <= (Double)minValues.get(i)) || !(sv.getMaxValue() >= (Double)maxValues.get(i))) continue;
                                ValidationConstraint.logError((ValidationContext)ctx, (int)1221754, (SBase)sfg, (String[])new String[0]);
                                check = false;
                            }
                            minValues.add(sv.getMinValue());
                            maxValues.add(sv.getMaxValue());
                        }
                        for (SampledVolume sv : sfg.getListOfSampledVolumes()) {
                            if (!sv.isSetSampledValue()) continue;
                            if (sampledValues.contains(sv.getSampledValue())) {
                                ValidationConstraint.logError((ValidationContext)ctx, (int)1221752, (SBase)sfg, (String[])new String[0]);
                                check = false;
                            } else {
                                sampledValues.add(sv.getSampledValue());
                            }
                            for (i = 0; i < minValues.size(); ++i) {
                                if (!(sv.getSampledValue() >= (Double)minValues.get(i)) || !(sv.getSampledValue() < (Double)maxValues.get(i))) continue;
                                ValidationConstraint.logError((ValidationContext)ctx, (int)1221753, (SBase)sfg, (String[])new String[0]);
                                check = false;
                            }
                        }
                        return check;
                    }
                };
            }
        }
        return func;
    }
}

