/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.spatial.AdjacentDomains;
import org.sbml.jsbml.ext.spatial.Domain;
import org.sbml.jsbml.ext.spatial.SpatialModelPlugin;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class AdjacentDomainsConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level < 3) break;
                this.addRangeToSet(set, 1221101, 1221106);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 1221101: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1221102: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1221103: {
                func = new UnknownPackageAttributeValidationFunction<AdjacentDomains>("spatial"){

                    public boolean check(ValidationContext ctx, AdjacentDomains adj) {
                        if (!adj.isSetId()) {
                            return false;
                        }
                        if (!adj.isSetDomain1()) {
                            return false;
                        }
                        if (!adj.isSetDomain2()) {
                            return false;
                        }
                        return super.check(ctx, (TreeNodeWithChangeSupport)adj);
                    }
                };
                break;
            }
            case 1221104: {
                func = new ValidationFunction<AdjacentDomains>(){

                    public boolean check(ValidationContext ctx, AdjacentDomains adj) {
                        Domain dom;
                        SpatialModelPlugin smp;
                        return !adj.isSetDomain1() || !(smp = (SpatialModelPlugin)adj.getModel().getPlugin("spatial")).isSetGeometry() || (dom = smp.getGeometry().getDomain(adj.getDomain1())) != null;
                    }
                };
                break;
            }
            case 1221105: {
                func = new ValidationFunction<AdjacentDomains>(){

                    public boolean check(ValidationContext ctx, AdjacentDomains adj) {
                        Domain dom;
                        SpatialModelPlugin smp;
                        return !adj.isSetDomain2() || !(smp = (SpatialModelPlugin)adj.getModel().getPlugin("spatial")).isSetGeometry() || (dom = smp.getGeometry().getDomain(adj.getDomain2())) != null;
                    }
                };
                break;
            }
            case 1221106: {
                func = new ValidationFunction<AdjacentDomains>(){

                    public boolean check(ValidationContext ctx, AdjacentDomains adj) {
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

