/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.spatial;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.SBasePlugin;
import org.sbml.jsbml.ext.spatial.AbstractSpatialSBasePlugin;
import org.sbml.jsbml.ext.spatial.Geometry;
import org.sbml.jsbml.ext.spatial.SpatialNamedSBase;
import org.sbml.jsbml.util.IdManager;

public class SpatialModelPlugin
extends AbstractSpatialSBasePlugin
implements IdManager {
    private static final long serialVersionUID = 8449591192464040411L;
    private Geometry geometry;
    private Map<String, SpatialNamedSBase> spatialIdMap;
    private static final transient Logger logger = Logger.getLogger(SpatialModelPlugin.class);

    public Geometry getGeometry() {
        if (this.isSetGeometry()) {
            return this.geometry;
        }
        throw new PropertyUndefinedError("geometry", (SBasePlugin)this);
    }

    public Geometry createGeometry() {
        Geometry geometry = new Geometry();
        this.setGeometry(geometry);
        return geometry;
    }

    public boolean isSetGeometry() {
        return this.geometry != null;
    }

    public void setGeometry(Geometry geometry) {
        Geometry oldGeometry = this.geometry;
        this.geometry = geometry;
        if (this.isSetExtendedSBase()) {
            this.getExtendedSBase().registerChild((SBase)geometry);
        }
        this.firePropertyChange("geometry", oldGeometry, this.geometry);
    }

    public boolean unsetGeometry() {
        if (this.isSetGeometry()) {
            Geometry oldGeometry = this.geometry;
            this.geometry = null;
            this.firePropertyChange("geometry", oldGeometry, this.geometry);
            return true;
        }
        return false;
    }

    public SpatialModelPlugin() {
    }

    public SpatialModelPlugin(Model model) {
        super((SBase)model);
    }

    public SpatialModelPlugin(SpatialModelPlugin spatialModelPlugin) {
        super(spatialModelPlugin);
        if (spatialModelPlugin.isSetGeometry()) {
            this.setGeometry(spatialModelPlugin.getGeometry().clone());
        }
    }

    public Model getExtendedSBase() {
        if (this.isSetExtendedSBase()) {
            return (Model)super.getExtendedSBase();
        }
        return null;
    }

    @Override
    public Map<String, String> writeXMLAttributes() {
        return null;
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public Geometry getChildAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexSurpassesBoundsException"), index, 0));
        }
        int pos = 0;
        if (this.isSetGeometry()) {
            if (pos == index) {
                return this.getGeometry();
            }
            ++pos;
        }
        throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexExceedsBoundsException"), index, pos));
    }

    public int getChildCount() {
        return this.isSetGeometry() ? 1 : 0;
    }

    @Override
    public SpatialModelPlugin clone() {
        return new SpatialModelPlugin(this);
    }

    public boolean accept(SBase sbase) {
        ListOf listOf;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)MessageFormat.format("accept called on {0}", sbase.getElementName()));
        }
        if (sbase instanceof SpatialNamedSBase) {
            return true;
        }
        return sbase instanceof ListOf && (listOf = (ListOf)sbase).size() > 0 && listOf.get(0) instanceof SpatialNamedSBase;
    }

    public boolean register(SBase sbase) {
        boolean success = true;
        if (sbase instanceof SpatialNamedSBase) {
            SpatialNamedSBase spatialSBase = (SpatialNamedSBase)sbase;
            if (spatialSBase.isSetSpatialId()) {
                String id = spatialSBase.getSpatialId();
                if (this.spatialIdMap == null) {
                    this.spatialIdMap = new HashMap<String, SpatialNamedSBase>();
                }
                if (this.spatialIdMap.containsKey(id)) {
                    logger.error((Object)MessageFormat.format("The spatial id \"{0}\" is already present in the spatial model assigned to the model {1}. The new element will not be added to the model.", id, this.isSetExtendedSBase() ? this.getExtendedSBase().getId() : ""));
                    success = false;
                } else {
                    this.spatialIdMap.put(id, spatialSBase);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)MessageFormat.format("registered spatial id={0} in {1}", id, this.isSetExtendedSBase() ? this.getExtendedSBase().getElementName() : ""));
                    }
                }
            }
        } else {
            logger.error((Object)MessageFormat.format("Trying to register something that does not have a spatialId: \"{0}\".", sbase));
        }
        return success;
    }

    public boolean unregister(SBase sbase) {
        boolean success = true;
        if (sbase instanceof SpatialNamedSBase) {
            SpatialNamedSBase spatialSbase = (SpatialNamedSBase)sbase;
            if (spatialSbase.isSetSpatialId()) {
                String id = spatialSbase.getSpatialId();
                if (this.spatialIdMap == null) {
                    logger.warn((Object)MessageFormat.format("No elements with spatial ids have been registered in this {0}. Nothing to be done.", this.isSetExtendedSBase() ? this.getExtendedSBase().getElementName() : ""));
                    return success;
                }
                if (this.spatialIdMap.containsKey(id)) {
                    this.spatialIdMap.remove(id);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)MessageFormat.format("unregistered spatial id={0} in {1}", id, this.isSetExtendedSBase() ? this.getExtendedSBase().getElementName() : ""));
                    }
                } else {
                    logger.warn((Object)MessageFormat.format("The spatial id \"{0}\" is not present in this model {1}. Nothing to be done.", id, this.isSetExtendedSBase() ? this.getExtendedSBase().getId() : ""));
                }
            }
        } else {
            logger.error((Object)MessageFormat.format("Trying to unregister something that does not have a spatial id: \"{0}\".", sbase));
        }
        return success;
    }

    public int hashCode() {
        int prime = 2039;
        int hashCode = super.hashCode();
        if (this.isSetGeometry()) {
            hashCode += 2039 * this.getGeometry().hashCode();
        }
        return hashCode;
    }
}

