/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.TimeUnit;

public class Scheduler {
    private long currentTime = 100L;
    private boolean isExecutingRunnable = false;
    private final Thread associatedThread = Thread.currentThread();
    private final List<ScheduledRunnable> runnables = new ArrayList<ScheduledRunnable>();
    private IdleState idleState = IdleState.UNPAUSED;

    public synchronized IdleState getIdleState() {
        return this.idleState;
    }

    public synchronized void setIdleState(IdleState idleState) {
        this.idleState = idleState;
        switch (idleState) {
            case UNPAUSED: {
                this.advanceBy(0L);
                break;
            }
            case CONSTANT_IDLE: {
                this.advanceToLastPostedRunnable();
            }
        }
    }

    public synchronized long getCurrentTime() {
        return this.currentTime;
    }

    public synchronized void pause() {
        this.setIdleState(IdleState.PAUSED);
    }

    public synchronized void unPause() {
        this.setIdleState(IdleState.UNPAUSED);
    }

    public synchronized boolean isPaused() {
        return this.idleState == IdleState.PAUSED;
    }

    public synchronized void post(Runnable runnable) {
        this.postDelayed(runnable, 0L, TimeUnit.MILLISECONDS);
    }

    public synchronized void postDelayed(Runnable runnable, long delayMillis) {
        this.postDelayed(runnable, delayMillis, TimeUnit.MILLISECONDS);
    }

    public synchronized void postDelayed(Runnable runnable, long delay, TimeUnit unit) {
        long delayMillis = unit.toMillis(delay);
        if (this.idleState != IdleState.CONSTANT_IDLE && (this.isPaused() || delayMillis > 0L) || Thread.currentThread() != this.associatedThread) {
            this.queueRunnableAndSort(runnable, this.currentTime + delayMillis);
        } else {
            this.runOrQueueRunnable(runnable, this.currentTime + delayMillis);
        }
    }

    public synchronized void postAtFrontOfQueue(Runnable runnable) {
        if (this.isPaused() || Thread.currentThread() != this.associatedThread) {
            this.runnables.add(0, new ScheduledRunnable(runnable, this.currentTime));
        } else {
            this.runOrQueueRunnable(runnable, this.currentTime);
        }
    }

    public synchronized void remove(Runnable runnable) {
        ListIterator<ScheduledRunnable> iterator = this.runnables.listIterator();
        while (iterator.hasNext()) {
            ScheduledRunnable next = iterator.next();
            if (next.runnable != runnable) continue;
            iterator.remove();
        }
    }

    public synchronized boolean advanceToLastPostedRunnable() {
        return this.size() >= 1 && this.advanceTo(this.runnables.get(this.runnables.size() - 1).scheduledTime);
    }

    public synchronized boolean advanceToNextPostedRunnable() {
        return this.size() >= 1 && this.advanceTo(this.runnables.get(0).scheduledTime);
    }

    @Deprecated
    public synchronized boolean advanceBy(long interval) {
        return this.advanceBy(interval, TimeUnit.MILLISECONDS);
    }

    public synchronized boolean advanceBy(long amount, TimeUnit unit) {
        long endingTime = this.currentTime + unit.toMillis(amount);
        return this.advanceTo(endingTime);
    }

    public synchronized boolean advanceTo(long endTime) {
        if (endTime - this.currentTime < 0L || this.size() < 1) {
            this.currentTime = endTime;
            return false;
        }
        int runCount = 0;
        while (this.nextTaskIsScheduledBefore(endTime)) {
            this.runOneTask();
            ++runCount;
        }
        this.currentTime = endTime;
        return runCount > 0;
    }

    public synchronized boolean runOneTask() {
        if (this.size() < 1) {
            return false;
        }
        ScheduledRunnable postedRunnable = this.runnables.remove(0);
        this.currentTime = postedRunnable.scheduledTime;
        postedRunnable.run();
        return true;
    }

    public synchronized boolean areAnyRunnable() {
        return this.nextTaskIsScheduledBefore(this.currentTime);
    }

    public synchronized void reset() {
        this.runnables.clear();
        this.idleState = IdleState.UNPAUSED;
    }

    public synchronized int size() {
        return this.runnables.size();
    }

    @Deprecated
    public void idleConstantly(boolean shouldIdleConstantly) {
        this.setIdleState(shouldIdleConstantly ? IdleState.CONSTANT_IDLE : IdleState.UNPAUSED);
    }

    private boolean nextTaskIsScheduledBefore(long endingTime) {
        return this.size() > 0 && this.runnables.get(0).scheduledTime <= endingTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runOrQueueRunnable(Runnable runnable, long scheduledTime) {
        if (this.isExecutingRunnable) {
            this.queueRunnableAndSort(runnable, scheduledTime);
            return;
        }
        this.isExecutingRunnable = true;
        try {
            runnable.run();
        }
        finally {
            this.isExecutingRunnable = false;
        }
        if (scheduledTime > this.currentTime) {
            this.currentTime = scheduledTime;
        }
        switch (this.idleState) {
            case CONSTANT_IDLE: {
                this.advanceToLastPostedRunnable();
                break;
            }
            case UNPAUSED: {
                this.advanceBy(0L);
            }
        }
    }

    private void queueRunnableAndSort(Runnable runnable, long scheduledTime) {
        this.runnables.add(new ScheduledRunnable(runnable, scheduledTime));
        Collections.sort(this.runnables);
    }

    private class ScheduledRunnable
    implements Comparable<ScheduledRunnable> {
        private final Runnable runnable;
        private final long scheduledTime;

        private ScheduledRunnable(Runnable runnable, long scheduledTime) {
            this.runnable = runnable;
            this.scheduledTime = scheduledTime;
        }

        @Override
        public int compareTo(ScheduledRunnable runnable) {
            return (int)(this.scheduledTime - runnable.scheduledTime);
        }

        public void run() {
            Scheduler.this.isExecutingRunnable = true;
            try {
                this.runnable.run();
            }
            finally {
                Scheduler.this.isExecutingRunnable = false;
            }
        }
    }

    public static enum IdleState {
        PAUSED,
        UNPAUSED,
        CONSTANT_IDLE;

    }
}

