/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.logging.Logger;
import org.robolectric.res.ResName;
import org.robolectric.res.ResourceIdGenerator;
import org.robolectric.res.ResourceIds;
import org.robolectric.res.ResourceTableFactory;

public class ResourceIndex {
    private static final Logger LOGGER = Logger.getLogger(ResourceTableFactory.class.getName());
    private final BiMap<Integer, ResName> resourceTable = HashBiMap.create();
    private final ResourceIdGenerator androidResourceIdGenerator = new ResourceIdGenerator(1);
    private final String packageName;
    private int packageIdentifier;

    public ResourceIndex(String packageName) {
        this.packageName = packageName;
    }

    public synchronized Integer getResourceId(ResName resName) {
        if (resName == null) {
            return null;
        }
        Integer id = (Integer)this.resourceTable.inverse().get((Object)resName);
        if (id == null && this.isAndroidPackage(resName)) {
            id = this.androidResourceIdGenerator.generate(resName.type, resName.name);
            this.resourceTable.put((Object)id, (Object)resName);
            LOGGER.fine("no id mapping found for " + resName.getFullyQualifiedName() + "; assigning ID #0x" + Integer.toHexString(id));
        }
        if (id == null) {
            return 0;
        }
        return id;
    }

    private boolean isAndroidPackage(ResName resName) {
        return "android".equals(resName.packageName) || "".equals(resName.packageName);
    }

    public synchronized ResName getResName(int resourceId) {
        return (ResName)this.resourceTable.get((Object)resourceId);
    }

    public synchronized void dump() {
        System.out.println(this.resourceTable);
    }

    public String getPackageName() {
        return this.packageName;
    }

    int getPackageIdentifier() {
        return this.packageIdentifier;
    }

    synchronized void addResource(int id, String type, String name) {
        if (ResourceIds.isFrameworkResource(id)) {
            this.androidResourceIdGenerator.record(id, type, name);
        }
        ResName resName = new ResName(this.packageName, type, name);
        int resIdPackageIdentifier = ResourceIds.getPackageIdentifier(id);
        if (this.getPackageIdentifier() == 0) {
            this.packageIdentifier = resIdPackageIdentifier;
        } else if (this.getPackageIdentifier() != resIdPackageIdentifier) {
            throw new IllegalArgumentException("Attempted to add resId " + resIdPackageIdentifier + " to ResourceIndex with packageIdentifier " + this.getPackageIdentifier());
        }
        ResName existingEntry = (ResName)this.resourceTable.put((Object)id, (Object)resName);
        if (existingEntry != null && !existingEntry.equals(resName)) {
            throw new IllegalArgumentException("ResId " + Integer.toHexString(id) + " mapped to both " + resName + " and " + existingEntry);
        }
    }
}

