/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;
import org.robolectric.res.FsFile;
import org.robolectric.res.ResBunch;
import org.robolectric.res.ResBundle;
import org.robolectric.res.ResName;
import org.robolectric.res.ResourceIndex;
import org.robolectric.res.ResourceTable;
import org.robolectric.res.TypedResource;
import org.robolectric.res.builder.XmlBlock;

public class PackageResourceTable
extends ResourceTable {
    final ResBunch data = new ResBunch();
    final ResBundle xmlDocuments = new ResBundle();
    final ResBundle rawResources = new ResBundle();
    private final ResourceIndex resourceIndex;

    PackageResourceTable(String packageName) {
        this.resourceIndex = new ResourceIndex(packageName);
    }

    public String getPackageName() {
        return this.resourceIndex.getPackageName();
    }

    @Override
    public Integer getResourceId(ResName resName) {
        return this.resourceIndex.getResourceId(resName);
    }

    @Override
    public ResName getResName(int resourceId) {
        return this.resourceIndex.getResName(resourceId);
    }

    @Override
    public TypedResource getValue(@NotNull ResName resName, String qualifiers) {
        return this.data.get(resName, qualifiers);
    }

    @Override
    public TypedResource getValue(int resId, String qualifiers) {
        return this.data.get(this.getResName(resId), qualifiers);
    }

    @Override
    public XmlBlock getXml(ResName resName, String qualifiers) {
        TypedResource typedResource = this.xmlDocuments.get(resName, qualifiers);
        return typedResource == null ? null : (XmlBlock)typedResource.getData();
    }

    @Override
    public InputStream getRawValue(ResName resName, String qualifiers) {
        TypedResource typedResource = this.rawResources.get(resName, qualifiers);
        FsFile file = typedResource == null ? null : (FsFile)typedResource.getData();
        try {
            return file == null ? null : file.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public InputStream getRawValue(int resId, String qualifiers) {
        return this.getRawValue(this.getResName(resId), qualifiers);
    }

    public int getPackageIdentifier() {
        return this.resourceIndex.getPackageIdentifier();
    }

    @Override
    public void addResource(int resId, String type, String name) {
        this.resourceIndex.addResource(resId, type, name);
    }

    @Override
    public void receive(ResourceTable.Visitor visitor) {
        this.data.receive(visitor);
    }

    @Override
    public boolean hasValue(ResName resName, String qualifiers) {
        return this.getValue(resName, qualifiers) != null || this.getXml(resName, qualifiers) != null || this.getRawValue(resName, qualifiers) != null;
    }
}

