/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.util.ArrayList;
import org.robolectric.res.AttrData;
import org.robolectric.res.ResBunch;
import org.robolectric.res.ResType;
import org.robolectric.res.TypedResource;
import org.robolectric.res.XmlLoader;
import org.robolectric.res.XpathResourceXmlLoader;

public class AttrResourceLoader
extends XpathResourceXmlLoader {
    private final ResBunch resBunch;

    public AttrResourceLoader(ResBunch resBunch) {
        super("//attr");
        this.resBunch = resBunch;
    }

    @Override
    protected void processNode(String name, XpathResourceXmlLoader.XmlNode xmlNode, XmlLoader.XmlContext xmlContext) {
        String format = xmlNode.getAttrValue("format");
        String childFormat = null;
        ArrayList<AttrData.Pair> pairs = null;
        XpathResourceXmlLoader.XmlNode firstChild = xmlNode.getFirstChild();
        if (firstChild != null) {
            childFormat = firstChild.getElementName();
            format = format == null ? childFormat : format + "|" + childFormat;
        }
        if ("enum".equals(childFormat)) {
            pairs = new ArrayList<AttrData.Pair>();
            for (XpathResourceXmlLoader.XmlNode enumNode : xmlNode.selectElements("enum")) {
                pairs.add(new AttrData.Pair(enumNode.getAttrValue("name"), enumNode.getAttrValue("value")));
            }
        } else if ("flag".equals(childFormat)) {
            pairs = new ArrayList();
            for (XpathResourceXmlLoader.XmlNode flagNode : xmlNode.selectElements("flag")) {
                pairs.add(new AttrData.Pair(flagNode.getAttrValue("name"), flagNode.getAttrValue("value")));
            }
        }
        if (format == null) {
            return;
        }
        AttrData attrData = new AttrData(name, format, pairs);
        this.resBunch.put("attr", name, new TypedResource<AttrData>(attrData, ResType.ATTR_DATA, xmlContext));
    }
}

