/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.nativeruntime;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

public final class NIOAccess {
    private NIOAccess() {
    }

    public static long getBasePointer(Buffer b) {
        long address = ((BufferReflector)Reflector.reflector(BufferReflector.class, (Object)b)).getAddress();
        if (address == 0L || !b.isDirect()) {
            return 0L;
        }
        return address + ((long)b.position() << NIOAccess.elementSizeShift(b));
    }

    static Object getBaseArray(Buffer b) {
        return b.hasArray() ? b.array() : null;
    }

    static int getBaseArrayOffset(Buffer b) {
        return b.hasArray() ? b.arrayOffset() + b.position() << NIOAccess.elementSizeShift(b) : 0;
    }

    public static int elementSizeShift(Buffer buffer) {
        if (buffer instanceof ByteBuffer) {
            return 0;
        }
        if (buffer instanceof ShortBuffer || buffer instanceof CharBuffer) {
            return 1;
        }
        if (buffer instanceof IntBuffer || buffer instanceof FloatBuffer) {
            return 2;
        }
        if (buffer instanceof LongBuffer || buffer instanceof DoubleBuffer) {
            return 3;
        }
        return 0;
    }

    @ForType(value=Buffer.class)
    static interface BufferReflector {
        @Accessor(value="address")
        public long getAddress();
    }
}

