/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.richfaces.renderkit.MacroDefinitionJSContentHandler;
import org.richfaces.renderkit.html.Lifo;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ContextMenuContentHandler
extends MacroDefinitionJSContentHandler {
    private static final Set INTERPOLATED_ATTRIBUTES = new HashSet();
    private Lifo elementStack = new Lifo();

    public ContextMenuContentHandler(Writer writer, String prolog, String epilog) {
        super(writer, prolog, epilog);
    }

    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        this.elementStack.push(localName);
        super.startElement(uri, localName, name, attributes);
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        this.elementStack.pop();
        super.endElement(uri, localName, name);
    }

    protected List parseExpressiion(String expressionString) throws SAXException {
        if ("script".equals(this.elementStack.peek())) {
            return Collections.singletonList(expressionString);
        }
        return super.parseExpressiion(expressionString);
    }

    protected void encodeAttributeValue(Attributes attributes, int idx) throws SAXException, IOException {
        if (INTERPOLATED_ATTRIBUTES.contains(attributes.getQName(idx))) {
            this.outputWriter.write("function (context) { return Richfaces.interpolate(\"");
            String value = attributes.getValue(idx);
            this.outputWriter.write(value);
            this.outputWriter.write("\", context);}");
        } else {
            super.encodeAttributeValue(attributes, idx);
        }
    }

    static {
        String[] attrs = new String[]{"onblur", "onchange", "onclick", "onfocus", "onkeydown", "onkeypress", "onkeyup", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup", "onselect"};
        for (int i = 0; i < attrs.length; ++i) {
            INTERPOLATED_ATTRIBUTES.add(attrs[i]);
        }
    }
}

