package org.richfaces.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.richfaces.component.UIMenuGroup;

public class HtmlMenuGroup extends UIMenuGroup{

static final public  String COMPONENT_FAMILY = "org.richfaces.DropDownMenu";

static final public  String COMPONENT_TYPE = "org.richfaces.MenuGroup";

/*
* Defines direction of the popup sublist to appear
                ("right", "left", "auto"(Default), "left-down", "left-up", "right-down", "right-up")
*/
private  String _direction = null;

/*
* If "true" sets state of the item to disabled state. Default value is "false".
*/
private  boolean _disabled = false;

private  boolean _disabledSet = false;

/*
* Defines the event on the representation element that
                triggers the menu's appearance. Default value is "onmouseover".
*/
private  String _event = null;

/*
* Path to the icon to be displayed for the enabled item
                state
*/
private  String _icon = null;

/*
* Class to be applied to icon element
*/
private  String _iconClass = null;

/*
* Path to the icon to be displayed for the disabled item
                state
*/
private  String _iconDisabled = null;

/*
* Path to the folder icon to be displayed for the enabled
                item state
*/
private  String _iconFolder = null;

/*
* Path to the folder icon to be displayed for the enabled
                item state
*/
private  String _iconFolderDisabled = null;

/*
* CSS style rules to be applied to icon element
*/
private  String _iconStyle = null;

/*
* Class to be applied to label element
*/
private  String _labelClass = null;

/*
* HTML: script expression; group was
                closed
*/
private  String _onclose = null;

/*
* HTML: a script expression; a pointer is moved
                within
*/
private  String _onmousemove = null;

/*
* HTML: a script expression; a pointer is moved
                away
*/
private  String _onmouseout = null;

/*
* HTML: a script expression; a pointer is moved
                onto
*/
private  String _onmouseover = null;

/*
* HTML: script expression; group was
                opened
*/
private  String _onopen = null;

/*
* Class to be applied to selected items
*/
private  String _selectClass = null;

/*
* CSS style rules to be applied to selected items
*/
private  String _selectStyle = null;

/*
* Delay between event and menu showing. Default value is "300".
*/
private  Integer _showDelay = null;

/*
* CSS style(s) is/are to be applied when this component is rendered
*/
private  String _style = null;

/*
* Corresponds to the HTML class attribute
*/
private  String _styleClass = null;


public HtmlMenuGroup(){
setRendererType("org.richfaces.MenuGroupRenderer");
}

public String getDirection(){
	if (this._direction != null) {
		return this._direction;
	}
	ValueExpression ve = getValueExpression("direction");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setDirection(String _direction){
this._direction = _direction;
}

public boolean isDisabled(){
	if (this._disabledSet) {
	    return (this._disabled);
	}
	ValueExpression ve = getValueExpression("disabled");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._disabled);
	    }
	    
	    return value;
	} else {
	    return (this._disabled);
	}

}

public void setDisabled(boolean _disabled){
this._disabled = _disabled;
this._disabledSet = true;
}

public String getEvent(){
	if (this._event != null) {
		return this._event;
	}
	ValueExpression ve = getValueExpression("event");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "onmouseover";
	

}

public void setEvent(String _event){
this._event = _event;
}

public String getIcon(){
	if (this._icon != null) {
		return this._icon;
	}
	ValueExpression ve = getValueExpression("icon");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setIcon(String _icon){
this._icon = _icon;
}

public String getIconClass(){
	if (this._iconClass != null) {
		return this._iconClass;
	}
	ValueExpression ve = getValueExpression("iconClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setIconClass(String _iconClass){
this._iconClass = _iconClass;
}

public String getIconDisabled(){
	if (this._iconDisabled != null) {
		return this._iconDisabled;
	}
	ValueExpression ve = getValueExpression("iconDisabled");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setIconDisabled(String _iconDisabled){
this._iconDisabled = _iconDisabled;
}

public String getIconFolder(){
	if (this._iconFolder != null) {
		return this._iconFolder;
	}
	ValueExpression ve = getValueExpression("iconFolder");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setIconFolder(String _iconFolder){
this._iconFolder = _iconFolder;
}

public String getIconFolderDisabled(){
	if (this._iconFolderDisabled != null) {
		return this._iconFolderDisabled;
	}
	ValueExpression ve = getValueExpression("iconFolderDisabled");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setIconFolderDisabled(String _iconFolderDisabled){
this._iconFolderDisabled = _iconFolderDisabled;
}

public String getIconStyle(){
	if (this._iconStyle != null) {
		return this._iconStyle;
	}
	ValueExpression ve = getValueExpression("iconStyle");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setIconStyle(String _iconStyle){
this._iconStyle = _iconStyle;
}

public String getLabelClass(){
	if (this._labelClass != null) {
		return this._labelClass;
	}
	ValueExpression ve = getValueExpression("labelClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setLabelClass(String _labelClass){
this._labelClass = _labelClass;
}

public String getOnclose(){
	if (this._onclose != null) {
		return this._onclose;
	}
	ValueExpression ve = getValueExpression("onclose");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnclose(String _onclose){
this._onclose = _onclose;
}

public String getOnmousemove(){
	if (this._onmousemove != null) {
		return this._onmousemove;
	}
	ValueExpression ve = getValueExpression("onmousemove");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnmousemove(String _onmousemove){
this._onmousemove = _onmousemove;
}

public String getOnmouseout(){
	if (this._onmouseout != null) {
		return this._onmouseout;
	}
	ValueExpression ve = getValueExpression("onmouseout");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnmouseout(String _onmouseout){
this._onmouseout = _onmouseout;
}

public String getOnmouseover(){
	if (this._onmouseover != null) {
		return this._onmouseover;
	}
	ValueExpression ve = getValueExpression("onmouseover");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnmouseover(String _onmouseover){
this._onmouseover = _onmouseover;
}

public String getOnopen(){
	if (this._onopen != null) {
		return this._onopen;
	}
	ValueExpression ve = getValueExpression("onopen");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnopen(String _onopen){
this._onopen = _onopen;
}

public String getSelectClass(){
	if (this._selectClass != null) {
		return this._selectClass;
	}
	ValueExpression ve = getValueExpression("selectClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setSelectClass(String _selectClass){
this._selectClass = _selectClass;
}

public String getSelectStyle(){
	if (this._selectStyle != null) {
		return this._selectStyle;
	}
	ValueExpression ve = getValueExpression("selectStyle");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setSelectStyle(String _selectStyle){
this._selectStyle = _selectStyle;
}

public Integer getShowDelay(){
	if (this._showDelay != null) {
		return this._showDelay;
	}
	ValueExpression ve = getValueExpression("showDelay");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return new Integer(300);
	

}

public void setShowDelay(Integer _showDelay){
this._showDelay = _showDelay;
}

public String getStyle(){
	if (this._style != null) {
		return this._style;
	}
	ValueExpression ve = getValueExpression("style");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyle(String _style){
this._style = _style;
}

public String getStyleClass(){
	if (this._styleClass != null) {
		return this._styleClass;
	}
	ValueExpression ve = getValueExpression("styleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyleClass(String _styleClass){
this._styleClass = _styleClass;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[22];
state[0] = super.saveState(context);
state[1] = _direction;
state[2] = Boolean.valueOf(_disabled);
state[3] = Boolean.valueOf(_disabledSet);
state[4] = _event;
state[5] = _icon;
state[6] = _iconClass;
state[7] = _iconDisabled;
state[8] = _iconFolder;
state[9] = _iconFolderDisabled;
state[10] = _iconStyle;
state[11] = _labelClass;
state[12] = _onclose;
state[13] = _onmousemove;
state[14] = _onmouseout;
state[15] = _onmouseover;
state[16] = _onopen;
state[17] = _selectClass;
state[18] = _selectStyle;
state[19] = _showDelay;
state[20] = _style;
state[21] = _styleClass;
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_direction = (String)states[1];;
		_disabled = ((Boolean)states[2]).booleanValue();
		_disabledSet = ((Boolean)states[3]).booleanValue();
		_event = (String)states[4];;
		_icon = (String)states[5];;
		_iconClass = (String)states[6];;
		_iconDisabled = (String)states[7];;
		_iconFolder = (String)states[8];;
		_iconFolderDisabled = (String)states[9];;
		_iconStyle = (String)states[10];;
		_labelClass = (String)states[11];;
		_onclose = (String)states[12];;
		_onmousemove = (String)states[13];;
		_onmouseout = (String)states[14];;
		_onmouseover = (String)states[15];;
		_onopen = (String)states[16];;
		_selectClass = (String)states[17];;
		_selectStyle = (String)states[18];;
		_showDelay = (Integer)states[19];;
		_style = (String)states[20];;
		_styleClass = (String)states[21];;
	
}

}
