/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.ussd.telephony;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorContext;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import javax.servlet.sip.Address;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import org.joda.time.DateTime;
import org.restcomm.connect.commons.configuration.RestcommConfiguration;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.commons.fsm.Action;
import org.restcomm.connect.commons.fsm.FiniteStateMachine;
import org.restcomm.connect.commons.fsm.State;
import org.restcomm.connect.commons.fsm.Transition;
import org.restcomm.connect.commons.patterns.Observe;
import org.restcomm.connect.commons.patterns.Observing;
import org.restcomm.connect.commons.patterns.StopObserving;
import org.restcomm.connect.commons.telephony.CreateCallType;
import org.restcomm.connect.dao.CallDetailRecordsDao;
import org.restcomm.connect.dao.entities.CallDetailRecord;
import org.restcomm.connect.telephony.api.Answer;
import org.restcomm.connect.telephony.api.CallInfo;
import org.restcomm.connect.telephony.api.CallResponse;
import org.restcomm.connect.telephony.api.CallStateChanged;
import org.restcomm.connect.telephony.api.GetCallInfo;
import org.restcomm.connect.telephony.api.GetCallObservers;
import org.restcomm.connect.telephony.api.InitializeOutbound;
import org.restcomm.connect.ussd.commons.UssdRestcommResponse;
import org.restcomm.connect.ussd.interpreter.UssdInterpreter;
import org.restcomm.connect.ussd.telephony.UssdCallType;
import scala.concurrent.duration.Duration;

public class UssdCall
extends UntypedActor {
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private final String ussdContentType = "application/vnd.3gpp.ussd+xml";
    private static final String OUTBOUND_API = "outbound-api";
    private static final String OUTBOUND_DIAL = "outbound-dial";
    private UssdCallType ussdCallType;
    private final FiniteStateMachine fsm;
    private final State uninitialized;
    private final State ringing;
    private final State inProgress;
    private final State ready;
    private final State processingUssdMessage;
    private final State completed;
    private final State queued;
    private final State dialing;
    private final State disconnecting;
    private final State cancelling;
    private final SipFactory factory;
    private String apiVersion;
    private Sid accountId;
    private String name;
    private SipURI from;
    private SipURI to;
    private String transport;
    private String username;
    private String password;
    private CreateCallType type;
    private long timeout;
    private SipServletRequest invite;
    private SipServletRequest outgoingInvite;
    private SipServletResponse lastResponse;
    private Map<String, String> headers;
    private boolean isFromApi;
    private final Sid id;
    private CallStateChanged.State external;
    private String direction;
    private DateTime created;
    private final List<ActorRef> observers;
    private CallDetailRecordsDao callDetailrecordsDao;
    private CallDetailRecord outgoingCallRecord;
    private ActorRef ussdInterpreter;

    public UssdCall(SipFactory factory) {
        ActorRef source = this.self();
        this.uninitialized = new State("uninitialized", null, null);
        this.ringing = new State("ringing", (Action)new Ringing(source), null);
        this.inProgress = new State("in progress", (Action)new InProgress(source), null);
        this.ready = new State("answering", (Action)new Ready(source), null);
        this.processingUssdMessage = new State("processing UssdMessage", (Action)new ProcessingUssdMessage(source), null);
        this.completed = new State("Completed", (Action)new Completed(source), null);
        this.queued = new State("queued", (Action)new Queued(source), null);
        this.dialing = new State("dialing", (Action)new Dialing(source), null);
        this.disconnecting = new State("Disconnecting", (Action)new Disconnecting(source), null);
        this.cancelling = new State("Cancelling", (Action)new Cancelling(source), null);
        HashSet<Transition> transitions = new HashSet<Transition>();
        transitions.add(new Transition(this.uninitialized, this.ringing));
        transitions.add(new Transition(this.uninitialized, this.cancelling));
        transitions.add(new Transition(this.uninitialized, this.queued));
        transitions.add(new Transition(this.queued, this.dialing));
        transitions.add(new Transition(this.queued, this.cancelling));
        transitions.add(new Transition(this.dialing, this.processingUssdMessage));
        transitions.add(new Transition(this.dialing, this.completed));
        transitions.add(new Transition(this.ringing, this.inProgress));
        transitions.add(new Transition(this.ringing, this.cancelling));
        transitions.add(new Transition(this.inProgress, this.processingUssdMessage));
        transitions.add(new Transition(this.inProgress, this.disconnecting));
        transitions.add(new Transition(this.inProgress, this.completed));
        transitions.add(new Transition(this.processingUssdMessage, this.ready));
        transitions.add(new Transition(this.processingUssdMessage, this.inProgress));
        transitions.add(new Transition(this.processingUssdMessage, this.completed));
        transitions.add(new Transition(this.processingUssdMessage, this.processingUssdMessage));
        transitions.add(new Transition(this.processingUssdMessage, this.dialing));
        transitions.add(new Transition(this.processingUssdMessage, this.disconnecting));
        this.fsm = new FiniteStateMachine(this.uninitialized, transitions);
        this.factory = factory;
        this.id = Sid.generate((Sid.Type)Sid.Type.CALL);
        this.created = DateTime.now();
        this.observers = Collections.synchronizedList(new ArrayList());
    }

    private void observe(Object message) {
        ActorRef self = this.self();
        Observe request = (Observe)message;
        ActorRef observer = request.observer();
        if (observer != null) {
            this.observers.add(observer);
            observer.tell((Object)new Observing(self), self);
        }
    }

    private void stopObserving(Object message) {
        StopObserving request = (StopObserving)message;
        ActorRef observer = request.observer();
        if (observer != null) {
            this.observers.remove(observer);
        }
    }

    private CallResponse<CallInfo> info() {
        if (this.from == null) {
            this.from = (SipURI)this.invite.getFrom().getURI();
        }
        if (this.to == null) {
            this.to = (SipURI)this.invite.getTo().getURI();
        }
        String from = this.from.getUser();
        String to = this.to.getUser();
        CallInfo info = new CallInfo(this.id, this.external, this.type, this.direction, this.created, null, this.name, from, to, this.invite, this.lastResponse, false, false, this.isFromApi, null);
        return new CallResponse((Object)info);
    }

    private SipURI getInitialIpAddressPort(SipServletMessage message) throws ServletParseException, UnknownHostException {
        String realIP = message.getInitialRemoteAddr();
        int realPort = message.getInitialRemotePort();
        ListIterator recordRouteHeaders = message.getHeaders("Record-Route");
        Address contactAddr = this.factory.createAddress(message.getHeader("Contact"));
        InetAddress contactInetAddress = InetAddress.getByName(((SipURI)contactAddr.getURI()).getHost());
        InetAddress inetAddress = InetAddress.getByName(realIP);
        int remotePort = message.getRemotePort();
        int contactPort = ((SipURI)contactAddr.getURI()).getPort();
        String remoteAddress = message.getRemoteAddr();
        String initialIpBeforeLB = message.getHeader("X-Sip-Balancer-InitialRemoteAddr");
        String initialPortBeforeLB = message.getHeader("X-Sip-Balancer-InitialRemotePort");
        SipURI uri = null;
        if (initialIpBeforeLB != null) {
            if (initialPortBeforeLB == null) {
                initialPortBeforeLB = "5060";
            }
            this.logger.info("We are behind load balancer, storing Initial Remote Address " + initialIpBeforeLB + ":" + initialPortBeforeLB + " to the session for later use");
            realIP = initialIpBeforeLB + ":" + initialPortBeforeLB;
            uri = this.factory.createSipURI(null, realIP);
        } else if (contactInetAddress.isSiteLocalAddress() && !recordRouteHeaders.hasNext() && !contactInetAddress.toString().equalsIgnoreCase(inetAddress.toString())) {
            this.logger.info("Contact header address " + contactAddr.toString() + " is a private network ip address, storing Initial Remote Address " + realIP + ":" + realPort + " to the session for later use");
            realIP = realIP + ":" + realPort;
            uri = this.factory.createSipURI(null, realIP);
        }
        return uri;
    }

    public void onReceive(Object message) throws Exception {
        UntypedActorContext context = this.getContext();
        Class<?> klass = message.getClass();
        ActorRef self = this.self();
        ActorRef sender = this.sender();
        State state = this.fsm.state();
        this.logger.info("UssdCall's Current State: \"" + state.toString());
        this.logger.info("UssdCall Processing Message: \"" + klass.getName());
        if (Observe.class.equals(klass)) {
            this.observe(message);
        } else if (StopObserving.class.equals(klass)) {
            this.stopObserving(message);
        } else if (GetCallObservers.class.equals(klass)) {
            sender.tell((Object)new CallResponse(this.observers), self);
        } else if (GetCallInfo.class.equals(klass)) {
            sender.tell(this.info(), self);
        } else if (message instanceof SipServletRequest) {
            SipServletRequest request = (SipServletRequest)message;
            String method = request.getMethod();
            if ("INVITE".equalsIgnoreCase(method)) {
                if (this.uninitialized.equals((Object)state)) {
                    this.fsm.transition(message, this.ringing);
                }
            } else if ("BYE".equalsIgnoreCase(method)) {
                this.fsm.transition(message, this.disconnecting);
            } else if (!(!"CANCEL".equalsIgnoreCase(method) || request.getSession().getState().equals((Object)SipSession.State.CONFIRMED) && request.getSession().getState().equals((Object)SipSession.State.TERMINATED))) {
                this.fsm.transition(message, this.cancelling);
            }
        } else if (message instanceof SipServletResponse) {
            SipServletResponse response;
            this.lastResponse = response = (SipServletResponse)message;
            if (response.getStatus() == 200 && response.getRequest().getMethod().equalsIgnoreCase("INVITE")) {
                response.createAck().send();
            }
            if (response.getStatus() == 200 && response.getRequest().getMethod().equalsIgnoreCase("BYE")) {
                this.fsm.transition(message, this.completed);
            }
        } else if (UssdRestcommResponse.class.equals(klass)) {
            if (!this.direction.equalsIgnoreCase("inbound") && this.outgoingInvite == null) {
                this.ussdInterpreter = sender;
                this.fsm.transition(message, this.dialing);
                return;
            }
            this.fsm.transition(message, this.processingUssdMessage);
        } else if (Answer.class.equals(klass)) {
            this.fsm.transition(message, this.inProgress);
        } else if (InitializeOutbound.class.equals(klass)) {
            this.fsm.transition(message, this.queued);
        }
    }

    public void postStop() {
        super.postStop();
    }

    private final class Dialing
    extends AbstractAction {
        public Dialing(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            UssdRestcommResponse ussdRequest = (UssdRestcommResponse)message;
            ActorRef self = UssdCall.this.self();
            StringBuilder buffer = new StringBuilder();
            buffer.append(UssdCall.this.to.getHost());
            if (UssdCall.this.to.getPort() > -1) {
                buffer.append(":").append(UssdCall.this.to.getPort());
            }
            if (!UssdCall.this.transport.equalsIgnoreCase("udp")) {
                buffer.append(";transport=").append(UssdCall.this.transport);
            }
            SipURI uri = UssdCall.this.factory.createSipURI(null, buffer.toString());
            SipApplicationSession application = UssdCall.this.factory.createApplicationSession();
            application.setAttribute("UssdCall", (Object)"true");
            application.setAttribute(UssdCall.class.getName(), (Object)self);
            if (UssdCall.this.ussdInterpreter != null) {
                application.setAttribute(UssdInterpreter.class.getName(), (Object)UssdCall.this.ussdInterpreter);
            }
            UssdCall.this.outgoingInvite = UssdCall.this.factory.createRequest(application, "INVITE", (URI)UssdCall.this.from, (URI)UssdCall.this.to);
            if (!UssdCall.this.transport.equalsIgnoreCase("udp")) {
                ((SipURI)UssdCall.this.outgoingInvite.getRequestURI()).setTransportParam(UssdCall.this.transport);
                ((SipURI)UssdCall.this.outgoingInvite.getFrom().getURI()).setTransportParam(UssdCall.this.transport);
                ((SipURI)UssdCall.this.outgoingInvite.getTo().getURI()).setTransportParam(UssdCall.this.transport);
            }
            UssdCall.this.outgoingInvite.pushRoute(uri);
            if (UssdCall.this.headers != null) {
                Set entrySet = UssdCall.this.headers.entrySet();
                for (Map.Entry entry : entrySet) {
                    UssdCall.this.outgoingInvite.addHeader("X-" + (String)entry.getKey(), (String)entry.getValue());
                }
            }
            UssdCall.this.outgoingInvite.addHeader("X-RestComm-ApiVersion", UssdCall.this.apiVersion);
            UssdCall.this.outgoingInvite.addHeader("X-RestComm-AccountSid", UssdCall.this.accountId.toString());
            UssdCall.this.outgoingInvite.addHeader("X-RestComm-CallSid", UssdCall.this.id.toString());
            SipSession session = UssdCall.this.outgoingInvite.getSession();
            session.setHandler("CallManager");
            UssdCall.this.outgoingInvite.setContent((Object)ussdRequest.createUssdPayload().toString(), "application/vnd.3gpp.ussd+xml");
            UssdCall.this.outgoingInvite.send();
            UntypedActorContext context = UssdCall.this.getContext();
            context.setReceiveTimeout((Duration)Duration.create((long)UssdCall.this.timeout, (TimeUnit)TimeUnit.SECONDS));
        }
    }

    private final class Queued
    extends AbstractAction {
        public Queued(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            InitializeOutbound request = (InitializeOutbound)message;
            UssdCall.this.name = request.name();
            UssdCall.this.from = request.from();
            UssdCall.this.to = request.to();
            UssdCall.this.transport = UssdCall.this.to.getTransportParam() != null ? UssdCall.this.to.getTransportParam() : "udp";
            UssdCall.this.apiVersion = request.apiVersion();
            UssdCall.this.accountId = request.accountId();
            UssdCall.this.username = request.username();
            UssdCall.this.password = request.password();
            UssdCall.this.type = request.type();
            UssdCall.this.isFromApi = request.isFromApi();
            UssdCall.this.callDetailrecordsDao = request.getDaoManager().getCallDetailRecordsDao();
            String toHeaderString = UssdCall.this.to.toString();
            if (toHeaderString.indexOf(63) != -1) {
                UssdCall.this.headers = new HashMap();
                UssdCall.this.to = (SipURI)UssdCall.this.factory.createURI(toHeaderString.substring(0, toHeaderString.lastIndexOf(63)));
                String headersString = toHeaderString.substring(toHeaderString.lastIndexOf(63) + 1);
                StringTokenizer tokenizer = new StringTokenizer(headersString, "&");
                while (tokenizer.hasMoreTokens()) {
                    String headerNameValue = tokenizer.nextToken();
                    String headerName = headerNameValue.substring(0, headerNameValue.lastIndexOf(61));
                    String headerValue = headerNameValue.substring(headerNameValue.lastIndexOf(61) + 1);
                    UssdCall.this.headers.put(headerName, headerValue);
                }
            }
            UssdCall.this.timeout = request.timeout();
            if (request.isFromApi()) {
                UssdCall.this.direction = UssdCall.OUTBOUND_API;
            } else {
                UssdCall.this.direction = UssdCall.OUTBOUND_DIAL;
            }
            UssdCall.this.external = CallStateChanged.State.QUEUED;
            CallStateChanged event = new CallStateChanged(UssdCall.this.external);
            for (ActorRef observer : UssdCall.this.observers) {
                observer.tell((Object)event, this.source);
            }
            if (UssdCall.this.callDetailrecordsDao != null) {
                CallDetailRecord.Builder builder = CallDetailRecord.builder();
                builder.setSid(UssdCall.this.id);
                builder.setInstanceId(RestcommConfiguration.getInstance().getMain().getInstanceId());
                builder.setDateCreated(UssdCall.this.created);
                builder.setAccountSid(UssdCall.this.accountId);
                builder.setTo(UssdCall.this.to.getUser());
                builder.setCallerName(UssdCall.this.name);
                String fromString = UssdCall.this.from.getUser() != null ? UssdCall.this.from.getUser() : "USSD REST API";
                builder.setFrom(fromString);
                builder.setStatus(UssdCall.this.external.name());
                builder.setDirection(UssdCall.OUTBOUND_API);
                builder.setApiVersion(UssdCall.this.apiVersion);
                builder.setPrice(new BigDecimal("0.00"));
                builder.setPriceUnit(Currency.getInstance("USD"));
                StringBuilder buffer = new StringBuilder();
                buffer.append("/").append(UssdCall.this.apiVersion).append("/Accounts/");
                buffer.append(UssdCall.this.accountId.toString()).append("/Calls/");
                buffer.append(UssdCall.this.id.toString());
                java.net.URI uri = java.net.URI.create(buffer.toString());
                builder.setUri(uri);
                UssdCall.this.outgoingCallRecord = builder.build();
                UssdCall.this.callDetailrecordsDao.addCallDetailRecord(UssdCall.this.outgoingCallRecord);
            }
        }
    }

    private final class Completed
    extends AbstractAction {
        public Completed(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            UssdCall.this.logger.info("Completing the call");
            if (UssdCall.this.invite != null) {
                UssdCall.this.invite.getSession().invalidate();
            }
            if (UssdCall.this.outgoingInvite != null) {
                UssdCall.this.outgoingInvite.getSession().invalidate();
            }
            UssdCall.this.external = CallStateChanged.State.COMPLETED;
            CallStateChanged event = new CallStateChanged(UssdCall.this.external);
            for (ActorRef observer : UssdCall.this.observers) {
                observer.tell((Object)event, this.source);
            }
            if (UssdCall.this.outgoingCallRecord != null && UssdCall.this.direction.contains("outbound")) {
                UssdCall.this.outgoingCallRecord = UssdCall.this.outgoingCallRecord.setStatus(CallStateChanged.State.COMPLETED.name());
                DateTime now = DateTime.now();
                UssdCall.this.outgoingCallRecord = UssdCall.this.outgoingCallRecord.setEndTime(now);
                boolean seconds = false;
                UssdCall.this.outgoingCallRecord = UssdCall.this.outgoingCallRecord.setDuration(Integer.valueOf(0));
                UssdCall.this.callDetailrecordsDao.updateCallDetailRecord(UssdCall.this.outgoingCallRecord);
            }
            UssdCall.this.logger.info("Call completed");
        }
    }

    private final class Disconnecting
    extends AbstractAction {
        public Disconnecting(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            UssdCall.this.logger.info("Disconnecting the call");
            SipServletRequest bye = (SipServletRequest)message;
            SipServletResponse response = bye.createResponse(200);
            response.send();
            if (UssdCall.this.invite != null) {
                UssdCall.this.invite.getSession().invalidate();
            }
            if (UssdCall.this.outgoingInvite != null) {
                UssdCall.this.outgoingInvite.getSession().invalidate();
            }
            UssdCall.this.external = CallStateChanged.State.CANCELED;
            CallStateChanged event = new CallStateChanged(UssdCall.this.external);
            for (ActorRef observer : UssdCall.this.observers) {
                observer.tell((Object)event, this.source);
            }
            if (UssdCall.this.outgoingCallRecord != null && UssdCall.this.direction.contains("outbound")) {
                UssdCall.this.outgoingCallRecord = UssdCall.this.outgoingCallRecord.setStatus(CallStateChanged.State.CANCELED.name());
                DateTime now = DateTime.now();
                UssdCall.this.outgoingCallRecord = UssdCall.this.outgoingCallRecord.setEndTime(now);
                boolean seconds = false;
                UssdCall.this.outgoingCallRecord = UssdCall.this.outgoingCallRecord.setDuration(Integer.valueOf(0));
                UssdCall.this.callDetailrecordsDao.updateCallDetailRecord(UssdCall.this.outgoingCallRecord);
            }
            UssdCall.this.logger.info("Call Disconnected");
        }
    }

    private final class Cancelling
    extends AbstractAction {
        public Cancelling(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            UssdCall.this.logger.info("Cancelling the call");
            SipServletRequest cancel = (SipServletRequest)message;
            SipServletResponse requestTerminated = UssdCall.this.invite.createResponse(487);
            requestTerminated.send();
            if (UssdCall.this.invite != null) {
                UssdCall.this.invite.getSession().invalidate();
            }
            if (UssdCall.this.outgoingInvite != null) {
                UssdCall.this.outgoingInvite.getSession().invalidate();
            }
            UssdCall.this.external = CallStateChanged.State.CANCELED;
            CallStateChanged event = new CallStateChanged(UssdCall.this.external);
            for (ActorRef observer : UssdCall.this.observers) {
                observer.tell((Object)event, this.source);
            }
            if (UssdCall.this.outgoingCallRecord != null && UssdCall.this.direction.contains("outbound")) {
                UssdCall.this.outgoingCallRecord = UssdCall.this.outgoingCallRecord.setStatus(CallStateChanged.State.CANCELED.name());
                DateTime now = DateTime.now();
                UssdCall.this.outgoingCallRecord = UssdCall.this.outgoingCallRecord.setEndTime(now);
                boolean seconds = false;
                UssdCall.this.outgoingCallRecord = UssdCall.this.outgoingCallRecord.setDuration(Integer.valueOf(0));
                UssdCall.this.callDetailrecordsDao.updateCallDetailRecord(UssdCall.this.outgoingCallRecord);
            }
            UssdCall.this.logger.info("Call Cancelled");
        }
    }

    private final class ProcessingUssdMessage
    extends AbstractAction {
        public ProcessingUssdMessage(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            UssdRestcommResponse ussdRequest = (UssdRestcommResponse)message;
            SipSession session = null;
            session = UssdCall.this.direction.equalsIgnoreCase("inbound") ? UssdCall.this.invite.getSession() : UssdCall.this.outgoingInvite.getSession();
            SipServletRequest request = null;
            request = ussdRequest.getIsFinalMessage() != false ? session.createRequest("BYE") : session.createRequest("INFO");
            request.setContent((Object)ussdRequest.createUssdPayload().toString().trim(), "application/vnd.3gpp.ussd+xml");
            UssdCall.this.logger.info("Prepared request: \n" + request);
            SipURI realInetUri = (SipURI)session.getAttribute("realInetUri");
            if (realInetUri != null) {
                UssdCall.this.logger.info("Using the real ip address of the sip client " + realInetUri.toString() + " as a request uri of the BYE request");
                request.setRequestURI((URI)realInetUri);
            }
            request.send();
            if (ussdRequest.getIsFinalMessage().booleanValue()) {
                UssdCall.this.fsm.transition((Object)request, UssdCall.this.completed);
            }
        }
    }

    private final class Ready
    extends AbstractAction {
        public Ready(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
        }
    }

    private final class InProgress
    extends AbstractAction {
        public InProgress(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            State state = UssdCall.this.fsm.state();
            SipServletResponse okay = UssdCall.this.invite.createResponse(200);
            okay.send();
            UssdCall.this.invite.getApplicationSession().setExpires(0);
            UssdCall.this.external = CallStateChanged.State.IN_PROGRESS;
            CallStateChanged event = new CallStateChanged(UssdCall.this.external);
            for (ActorRef observer : UssdCall.this.observers) {
                observer.tell((Object)event, this.source);
            }
            if (UssdCall.this.outgoingCallRecord != null && UssdCall.this.direction.contains("outbound") && !UssdCall.this.outgoingCallRecord.getStatus().equalsIgnoreCase("in_progress")) {
                UssdCall.this.outgoingCallRecord = UssdCall.this.outgoingCallRecord.setStatus(UssdCall.this.external.name());
                UssdCall.this.outgoingCallRecord = UssdCall.this.outgoingCallRecord.setAnsweredBy(UssdCall.this.to.getUser());
                UssdCall.this.callDetailrecordsDao.updateCallDetailRecord(UssdCall.this.outgoingCallRecord);
            }
        }
    }

    private final class Ringing
    extends AbstractAction {
        public Ringing(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            if (message instanceof SipServletRequest) {
                UssdCall.this.invite = (SipServletRequest)message;
                UssdCall.this.from = (SipURI)UssdCall.this.invite.getFrom().getURI();
                UssdCall.this.to = (SipURI)UssdCall.this.invite.getTo().getURI();
                UssdCall.this.timeout = -1L;
                UssdCall.this.direction = "inbound";
                SipServletResponse ringing = UssdCall.this.invite.createResponse(180);
                ringing.send();
                SipURI initialInetUri = UssdCall.this.getInitialIpAddressPort((SipServletMessage)UssdCall.this.invite);
                if (initialInetUri != null) {
                    UssdCall.this.invite.getSession().setAttribute("realInetUri", (Object)initialInetUri);
                }
            } else if (message instanceof SipServletResponse) {
                UntypedActorContext context = UssdCall.this.getContext();
                context.setReceiveTimeout((Duration)Duration.Undefined());
            }
            UssdCall.this.external = CallStateChanged.State.RINGING;
            CallStateChanged event = new CallStateChanged(UssdCall.this.external);
            for (ActorRef observer : UssdCall.this.observers) {
                UssdCall.this.logger.info("Telling observers that state changed to RINGING");
                observer.tell((Object)event, this.source);
            }
            if (UssdCall.this.outgoingCallRecord != null && UssdCall.this.direction.contains("outbound")) {
                UssdCall.this.outgoingCallRecord = UssdCall.this.outgoingCallRecord.setStatus(UssdCall.this.external.name());
                UssdCall.this.callDetailrecordsDao.updateCallDetailRecord(UssdCall.this.outgoingCallRecord);
            }
        }
    }

    private abstract class AbstractAction
    implements Action {
        protected final ActorRef source;

        public AbstractAction(ActorRef source) {
            this.source = source;
        }
    }
}

