/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.ussd.interpreter;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorFactory;
import java.net.URI;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.ussd.interpreter.UssdInterpreter;

public class UssdInterpreterBuilder {
    private static Logger logger = Logger.getLogger(UssdInterpreterBuilder.class);
    private final ActorSystem system;
    private Configuration configuration;
    private DaoManager storage;
    private ActorRef calls;
    private ActorRef conferences;
    private ActorRef sms;
    private Sid account;
    private Sid phone;
    private String version;
    private URI url;
    private String method;
    private URI fallbackUrl;
    private String fallbackMethod;
    private URI statusCallback;
    private String statusCallbackMethod;
    private String emailAddress;

    public UssdInterpreterBuilder(ActorSystem system) {
        this.system = system;
    }

    public ActorRef build() {
        Props props = new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new UssdInterpreter(UssdInterpreterBuilder.this.configuration, UssdInterpreterBuilder.this.account, UssdInterpreterBuilder.this.phone, UssdInterpreterBuilder.this.version, UssdInterpreterBuilder.this.url, UssdInterpreterBuilder.this.method, UssdInterpreterBuilder.this.fallbackUrl, UssdInterpreterBuilder.this.fallbackMethod, UssdInterpreterBuilder.this.statusCallback, UssdInterpreterBuilder.this.statusCallbackMethod, UssdInterpreterBuilder.this.emailAddress, UssdInterpreterBuilder.this.calls, UssdInterpreterBuilder.this.conferences, UssdInterpreterBuilder.this.sms, UssdInterpreterBuilder.this.storage);
            }
        });
        return this.system.actorOf(props);
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setStorage(DaoManager storage) {
        this.storage = storage;
    }

    public void setCallManager(ActorRef calls) {
        this.calls = calls;
    }

    public void setAccount(Sid account) {
        this.account = account;
    }

    public void setPhone(Sid phone) {
        this.phone = phone;
    }

    public void setUrl(URI url) {
        this.url = url;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setFallbackUrl(URI fallbackUrl) {
        this.fallbackUrl = fallbackUrl;
    }

    public void setFallbackMethod(String fallbackMethod) {
        this.fallbackMethod = fallbackMethod;
    }

    public void setStatusCallback(URI statusCallback) {
        this.statusCallback = statusCallback;
    }

    public void setStatusCallbackMethod(String statusCallbackMethod) {
        this.statusCallbackMethod = statusCallbackMethod;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

