/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.ussd.commons;

import java.io.StringWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.restcomm.connect.ussd.commons.UssdMessageType;

public class UssdRestcommResponse {
    private String message;
    private String language;
    private int messageLength;
    private UssdMessageType messageType;
    private Boolean isFinalMessage = true;
    private String ussdCollectAction;
    private String errorCode;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public int getMessageLength() {
        return this.messageLength;
    }

    public void setMessageLength(int messageLength) {
        this.messageLength = messageLength;
    }

    public UssdMessageType getUssdMessageType() {
        return this.messageType;
    }

    public void setMessageType(UssdMessageType messageType) {
        this.messageType = messageType;
    }

    public Boolean getIsFinalMessage() {
        return this.isFinalMessage;
    }

    public void setIsFinalMessage(Boolean isFinalMessage) {
        this.isFinalMessage = isFinalMessage;
    }

    public String createUssdPayload() throws XMLStreamException {
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        StringWriter writer = new StringWriter();
        XMLStreamWriter streamWriter = outputFactory.createXMLStreamWriter(writer);
        streamWriter.writeStartDocument("UTF-8", "1.0");
        streamWriter.writeCharacters("\n");
        streamWriter.writeStartElement("ussd-data");
        streamWriter.writeCharacters("\n");
        if (this.getLanguage() != null) {
            streamWriter.writeStartElement("language");
            streamWriter.writeAttribute("value", this.getLanguage());
            streamWriter.writeEndElement();
            streamWriter.writeCharacters("\n");
        }
        if (this.getMessage() != null) {
            streamWriter.writeStartElement("ussd-string");
            streamWriter.writeAttribute("value", this.getMessage());
            streamWriter.writeEndElement();
            streamWriter.writeCharacters("\n");
        }
        if (this.getUssdMessageType() != null) {
            streamWriter.writeStartElement("anyExt");
            streamWriter.writeCharacters("\n");
            streamWriter.writeStartElement("message-type");
            streamWriter.writeCharacters(this.getUssdMessageType().name());
            streamWriter.writeEndElement();
            streamWriter.writeCharacters("\n");
            streamWriter.writeEndElement();
            streamWriter.writeCharacters("\n");
        }
        if (this.getErrorCode() != null) {
            streamWriter.writeStartElement("error-code");
            streamWriter.writeAttribute("value", this.getErrorCode());
            streamWriter.writeEndElement();
            streamWriter.writeCharacters("\n");
        }
        streamWriter.writeEndElement();
        streamWriter.writeCharacters("\n");
        streamWriter.writeEndDocument();
        streamWriter.flush();
        streamWriter.close();
        return writer.toString();
    }

    public void setUssdCollectAction(String ussdCollectAction) {
        this.ussdCollectAction = ussdCollectAction;
    }

    public String getUssdCollectAction() {
        return this.ussdCollectAction;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String toString() {
        return "UssdRestCommResponse :" + this.message + " messageType: " + this.messageType.name() + " isFinalMessage: " + this.isFinalMessage;
    }
}

