/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.ussd.commons;

import java.io.IOException;
import java.io.StringReader;
import javax.servlet.sip.SipServletRequest;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.restcomm.connect.ussd.commons.UssdMessageType;

public class UssdInfoRequest {
    private final String ussdPayload;
    private String message;
    private String language;
    private UssdMessageType ussdMessageType;

    public UssdInfoRequest(SipServletRequest request) throws IOException {
        this.ussdPayload = new String(request.getRawContent());
    }

    public UssdInfoRequest(String payload) {
        this.ussdPayload = payload;
    }

    public void readUssdPayload() throws Exception {
        StringReader reader = new StringReader(this.ussdPayload.trim().replaceAll("&([^;]+(?!(?:\\w|;)))", "&amp;$1").replaceAll("\\n", "").replaceAll("\\t", ""));
        XMLInputFactory inputs = XMLInputFactory.newInstance();
        inputs.setProperty("javax.xml.stream.isCoalescing", true);
        XMLStreamReader stream = null;
        try {
            stream = inputs.createXMLStreamReader(reader);
            while (stream.hasNext()) {
                stream.next();
                int streamEvent = stream.getEventType();
                if (streamEvent == 8 || streamEvent != 1) continue;
                String name = stream.getLocalName();
                if (name.equalsIgnoreCase("language") && stream.isStartElement()) {
                    this.language = stream.getAttributeValue("", "value");
                    continue;
                }
                if (name.equalsIgnoreCase("ussd-string") && stream.isStartElement()) {
                    this.message = stream.getAttributeValue("", "value");
                    continue;
                }
                if (!name.equalsIgnoreCase("anyExt") || !stream.isStartElement()) continue;
                stream.next();
                name = stream.getLocalName();
                if (!name.equalsIgnoreCase("message-type") || !stream.isStartElement()) continue;
                stream.next();
                this.ussdMessageType = UssdMessageType.valueOf(stream.getText().trim());
            }
        }
        catch (Exception e) {
            this.message = e.getMessage();
            throw e;
        }
    }

    public String getMessage() throws Exception {
        if (this.message == null) {
            this.readUssdPayload();
        }
        return this.message;
    }

    public String getLanguage() throws Exception {
        if (this.language == null) {
            this.readUssdPayload();
        }
        return this.language == null ? "en" : this.language;
    }

    public UssdMessageType getUssdMessageType() throws Exception {
        if (this.ussdMessageType == null) {
            this.readUssdPayload();
        }
        return this.ussdMessageType == null ? UssdMessageType.unstructuredSSRequest_Response : this.ussdMessageType;
    }

    public int getMessageLength() throws Exception {
        if (this.message == null) {
            this.readUssdPayload();
        }
        return this.message.length();
    }

    public Boolean getIsFinalMessage() {
        return null;
    }
}

