/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.activity;

import java.util.concurrent.atomic.AtomicBoolean;
import org.rapidoid.activity.NamedActivity;
import org.rapidoid.u.U;

public abstract class LifecycleActivity<T>
extends NamedActivity<T> {
    private final AtomicBoolean active = new AtomicBoolean(false);

    public LifecycleActivity(String name) {
        super(name);
    }

    @Override
    public T start() {
        this.checkActive(false);
        this.active.set(true);
        return (T)this;
    }

    @Override
    public T halt() {
        this.checkActive(true);
        this.active.set(false);
        return (T)this;
    }

    @Override
    public T shutdown() {
        this.checkActive(true);
        this.active.set(false);
        return (T)this;
    }

    @Override
    public boolean isActive() {
        return this.active.get();
    }

    protected void checkActive(boolean active) {
        if (active) {
            U.must((boolean)this.isActive(), (String)"The activity is not active!");
        } else {
            U.must((!this.isActive() ? 1 : 0) != 0, (String)"The activity is already active!");
        }
    }
}

