/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.text;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.TreeMap;
import org.python.icu.impl.ICUResourceBundle;
import org.python.icu.text.CurrencyFormat;
import org.python.icu.text.ListFormatter;
import org.python.icu.text.MeasureFormat;
import org.python.icu.text.NumberFormat;
import org.python.icu.text.PluralRules;
import org.python.icu.text.UFieldPosition;
import org.python.icu.util.FormatWidth;
import org.python.icu.util.Measure;
import org.python.icu.util.MeasureUnit;
import org.python.icu.util.ULocale;
import org.python.icu.util.UResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralMeasureFormat
extends MeasureFormat {
    static final transient Map<ULocale, ParseData> localeToParseData = new HashMap<ULocale, ParseData>();
    static final transient Map<ULocale, Map<MeasureUnit, EnumMap<FormatWidth, Map<String, PatternData>>>> localeToUnitToStyleToCountToFormat = new HashMap<ULocale, Map<MeasureUnit, EnumMap<FormatWidth, Map<String, PatternData>>>>();
    static final transient Index<MeasureUnit> index = new Index();
    private final ULocale locale;
    private final FormatWidth length;
    private final NumberFormat numberFormat;
    private final transient PluralRules rules;
    private final transient Map<MeasureUnit, EnumMap<FormatWidth, Map<String, PatternData>>> unitToStyleToCountToFormat;
    private transient ParseData parseData;
    private static final long serialVersionUID = 7922671801770278517L;
    static final Comparator<String> LONGEST_FIRST = new Comparator<String>(){

        @Override
        public int compare(String as, String bs) {
            if (as.length() > bs.length()) {
                return -1;
            }
            if (as.length() < bs.length()) {
                return 1;
            }
            return as.compareTo(bs);
        }
    };

    protected GeneralMeasureFormat(ULocale locale, FormatWidth style, Map<MeasureUnit, EnumMap<FormatWidth, Map<String, PatternData>>> unitToStyleToCountToFormat, NumberFormat numberFormat) {
        this.locale = locale;
        this.length = style;
        this.unitToStyleToCountToFormat = unitToStyleToCountToFormat;
        this.rules = PluralRules.forLocale(locale);
        this.numberFormat = numberFormat;
    }

    public static GeneralMeasureFormat getInstance(ULocale locale, FormatWidth length) {
        return GeneralMeasureFormat.getInstance(locale, length, NumberFormat.getInstance(locale));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GeneralMeasureFormat getInstance(ULocale locale, FormatWidth length, NumberFormat decimalFormat) {
        Map<ULocale, Map<MeasureUnit, EnumMap<FormatWidth, Map<String, PatternData>>>> map = localeToUnitToStyleToCountToFormat;
        synchronized (map) {
            Map<MeasureUnit, EnumMap<FormatWidth, Map<String, PatternData>>> unitToStyleToCountToFormat = localeToUnitToStyleToCountToFormat.get(locale);
            if (unitToStyleToCountToFormat == null) {
                unitToStyleToCountToFormat = GeneralMeasureFormat.cacheLocaleData(locale);
            }
            return new GeneralMeasureFormat(locale, length, unitToStyleToCountToFormat, decimalFormat);
        }
    }

    public static MeasureFormat getCurrencyFormat(ULocale locale) {
        return new CurrencyFormat(locale);
    }

    public static MeasureFormat getCurrencyFormat() {
        return GeneralMeasureFormat.getCurrencyFormat(ULocale.getDefault(ULocale.Category.FORMAT));
    }

    public ULocale getLocale() {
        return this.locale;
    }

    public FormatWidth getLength() {
        return this.length;
    }

    private static Map<MeasureUnit, EnumMap<FormatWidth, Map<String, PatternData>>> cacheLocaleData(ULocale locale) {
        PluralRules rules = PluralRules.forLocale(locale);
        Set<String> keywords = rules.getKeywords();
        HashMap<MeasureUnit, EnumMap<FormatWidth, Map<String, PatternData>>> unitToStyleToCountToFormat = new HashMap<MeasureUnit, EnumMap<FormatWidth, Map<String, PatternData>>>();
        localeToUnitToStyleToCountToFormat.put(locale, unitToStyleToCountToFormat);
        for (MeasureUnit unit : MeasureUnit.getAvailable()) {
            EnumMap styleToCountToFormat = (EnumMap)unitToStyleToCountToFormat.get(unit);
            if (styleToCountToFormat == null) {
                styleToCountToFormat = new EnumMap(FormatWidth.class);
                unitToStyleToCountToFormat.put(unit, styleToCountToFormat);
            }
            ICUResourceBundle resource = (ICUResourceBundle)UResourceBundle.getBundleInstance("org/python/icu/impl/data/icudt52b", locale);
            for (FormatWidth styleItem : FormatWidth.values()) {
                try {
                    ICUResourceBundle unitTypeRes = resource.getWithFallback(styleItem.resourceKey);
                    ICUResourceBundle unitsRes = unitTypeRes.getWithFallback(unit.getType());
                    ICUResourceBundle oneUnitRes = unitsRes.getWithFallback(unit.getCode());
                    HashMap<String, PatternData> countToFormat = (HashMap<String, PatternData>)styleToCountToFormat.get((Object)styleItem);
                    if (countToFormat == null) {
                        countToFormat = new HashMap<String, PatternData>();
                        styleToCountToFormat.put(styleItem, countToFormat);
                    }
                    for (String keyword2 : keywords) {
                        UResourceBundle countBundle;
                        try {
                            countBundle = oneUnitRes.get(keyword2);
                        }
                        catch (MissingResourceException e) {
                            continue;
                        }
                        String pattern = countBundle.getString();
                        PatternData format = new PatternData(pattern);
                        countToFormat.put(keyword2, format);
                    }
                    PatternData other = (PatternData)countToFormat.get("other");
                    for (String keyword3 : keywords) {
                        if (countToFormat.containsKey(keyword3)) continue;
                        countToFormat.put(keyword3, other);
                    }
                }
                catch (MissingResourceException e) {
                    // empty catch block
                }
            }
            if (styleToCountToFormat.size() == FormatWidth.values().length) continue;
            Map fallback = (Map)styleToCountToFormat.get((Object)FormatWidth.SHORT);
            if (fallback == null) {
                fallback = (Map)styleToCountToFormat.get((Object)FormatWidth.WIDE);
            }
            if (fallback == null) continue;
            for (FormatWidth styleItem : FormatWidth.values()) {
                HashMap countToFormat = (HashMap)styleToCountToFormat.get((Object)styleItem);
                if (countToFormat != null) continue;
                countToFormat = new HashMap();
                styleToCountToFormat.put(styleItem, countToFormat);
                for (Map.Entry entry : fallback.entrySet()) {
                    countToFormat.put(entry.getKey(), entry.getValue());
                }
            }
        }
        return unitToStyleToCountToFormat;
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj instanceof Collection) {
            Collection coll = (Collection)obj;
            return this.format(toAppendTo, pos, coll.toArray(new Measure[coll.size()]));
        }
        if (obj instanceof Measure[]) {
            return this.format(toAppendTo, pos, (Measure[])obj);
        }
        return this.format((Measure)obj, toAppendTo, pos);
    }

    public StringBuffer format(Measure measure, StringBuffer toAppendTo, FieldPosition pos) {
        Number n = measure.getNumber();
        MeasureUnit unit = measure.getUnit();
        UFieldPosition fpos = new UFieldPosition(pos.getFieldAttribute(), pos.getField());
        StringBuffer formattedNumber = this.numberFormat.format(n, new StringBuffer(), (FieldPosition)fpos);
        String keyword2 = this.rules.select(new PluralRules.FixedDecimal(n.doubleValue(), fpos.getCountVisibleFractionDigits(), fpos.getFractionDigits()));
        Map styleToCountToFormat = this.unitToStyleToCountToFormat.get(unit);
        Map countToFormat = (Map)styleToCountToFormat.get((Object)this.length);
        PatternData messagePatternData = (PatternData)countToFormat.get(keyword2);
        toAppendTo.append(messagePatternData.prefix);
        if (messagePatternData.suffix != null) {
            pos.setBeginIndex(fpos.getBeginIndex() + messagePatternData.prefix.length());
            pos.setEndIndex(fpos.getEndIndex() + messagePatternData.prefix.length());
            toAppendTo.append(formattedNumber);
            toAppendTo.append(messagePatternData.suffix);
        }
        return toAppendTo;
    }

    public StringBuffer format(StringBuffer toAppendto, FieldPosition pos, Measure ... measures) {
        StringBuffer[] results = new StringBuffer[measures.length];
        for (int i = 0; i < measures.length; ++i) {
            results[i] = this.format(measures[i], new StringBuffer(), pos);
        }
        ListFormatter listFormatter = ListFormatter.getInstance(this.locale, this.length == FormatWidth.WIDE ? ListFormatter.Style.DURATION : ListFormatter.Style.DURATION_SHORT);
        return toAppendto.append(listFormatter.format(results));
    }

    public String format(Measure ... measures) {
        StringBuffer result = this.format(new StringBuffer(), new FieldPosition(0), measures);
        return result.toString();
    }

    @Override
    public Measure parseObject(String toParse, ParsePosition parsePosition) {
        if (this.parseData == null) {
            this.parseData = ParseData.of(this.locale, this.unitToStyleToCountToFormat);
        }
        Measure result = this.parseData.parse(this.numberFormat, toParse, parsePosition);
        return result;
    }

    private static int getFirst(BitSet prefixSet, BitSet suffixSet) {
        int i = prefixSet.nextSetBit(0);
        while (i >= 0) {
            if (suffixSet.get(i)) {
                return i;
            }
            i = prefixSet.nextSetBit(i + 1);
        }
        return 0;
    }

    private static boolean looseMatches(String suffix, String arg0, ParsePosition arg1) {
        boolean matches = suffix.regionMatches(0, arg0, arg1.getIndex(), suffix.length());
        if (matches) {
            arg1.setErrorIndex(-1);
            arg1.setIndex(arg1.getIndex() + suffix.length());
        } else {
            arg1.setErrorIndex(arg1.getIndex());
        }
        return matches;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != GeneralMeasureFormat.class) {
            return false;
        }
        GeneralMeasureFormat other = (GeneralMeasureFormat)obj;
        return this.locale.equals(other.locale) && this.length == other.length && this.numberFormat.equals(other.numberFormat);
    }

    public int hashCode() {
        return (this.locale.hashCode() * 37 + this.length.hashCode()) * 37 + this.numberFormat.hashCode();
    }

    private Object writeReplace() throws ObjectStreamException {
        return new GeneralMeasureProxy(this.locale, this.length, this.numberFormat);
    }

    static class GeneralMeasureProxy
    implements Externalizable {
        private static final long serialVersionUID = -6033308329886716770L;
        private ULocale locale;
        private FormatWidth length;
        private NumberFormat numberFormat;

        public GeneralMeasureProxy(ULocale locale, FormatWidth length, NumberFormat numberFormat) {
            this.locale = locale;
            this.length = length;
            this.numberFormat = numberFormat;
        }

        public GeneralMeasureProxy() {
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(0);
            out.writeObject(this.locale);
            out.writeObject((Object)this.length);
            out.writeObject(this.numberFormat);
            out.writeShort(0);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            in.readByte();
            this.locale = (ULocale)in.readObject();
            this.length = (FormatWidth)((Object)in.readObject());
            this.numberFormat = (NumberFormat)in.readObject();
            short extra = in.readShort();
            if (extra > 0) {
                byte[] extraBytes = new byte[extra];
                in.read(extraBytes, 0, extra);
            }
        }

        private Object readResolve() throws ObjectStreamException {
            return GeneralMeasureFormat.getInstance(this.locale, this.length, this.numberFormat);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Index<T> {
        List<T> intToItem = new ArrayList<T>();
        Map<T, Integer> itemToInt = new HashMap<T, Integer>();

        Index() {
        }

        int getIndex(T item) {
            return this.itemToInt.get(item);
        }

        T getUnit(int index) {
            return this.intToItem.get(index);
        }

        int addItem(T item) {
            Integer index = this.itemToInt.get(item);
            if (index != null) {
                return index;
            }
            int size = this.intToItem.size();
            this.itemToInt.put(item, size);
            this.intToItem.add(item);
            return size;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ParseData {
        transient Map<String, BitSet> prefixMap = new TreeMap<String, BitSet>(LONGEST_FIRST);
        transient Map<String, BitSet> suffixMap = new TreeMap<String, BitSet>(LONGEST_FIRST);
        transient BitSet nullSuffix = new BitSet();

        ParseData(ULocale locale, Map<MeasureUnit, EnumMap<FormatWidth, Map<String, PatternData>>> unitToStyleToCountToFormat) {
            for (Map.Entry<MeasureUnit, EnumMap<FormatWidth, Map<String, PatternData>>> entry3 : unitToStyleToCountToFormat.entrySet()) {
                MeasureUnit unit = entry3.getKey();
                int unitIndex = index.addItem(unit);
                for (Map.Entry<FormatWidth, Map<String, PatternData>> entry : entry3.getValue().entrySet()) {
                    for (Map.Entry<String, PatternData> entry2 : entry.getValue().entrySet()) {
                        PatternData data = entry2.getValue();
                        this.setBits(this.prefixMap, data.prefix, unitIndex);
                        if (data.suffix == null) {
                            this.nullSuffix.set(unitIndex);
                            continue;
                        }
                        this.setBits(this.suffixMap, data.suffix, unitIndex);
                    }
                }
            }
        }

        private void setBits(Map<String, BitSet> map, String string, int unitIndex) {
            BitSet bs = map.get(string);
            if (bs == null) {
                bs = new BitSet();
                map.put(string, bs);
            }
            bs.set(unitIndex);
        }

        public static synchronized ParseData of(ULocale locale, Map<MeasureUnit, EnumMap<FormatWidth, Map<String, PatternData>>> unitToStyleToCountToFormat) {
            ParseData result = localeToParseData.get(locale);
            if (result == null) {
                result = new ParseData(locale, unitToStyleToCountToFormat);
                localeToParseData.put(locale, result);
            }
            return result;
        }

        private Measure parse(NumberFormat numberFormat, String toParse, ParsePosition parsePosition) {
            int startIndex = parsePosition.getIndex();
            Number bestNumber = null;
            int bestUnit = -1;
            int longestMatch = -1;
            int furthestError = -1;
            for (Map.Entry<String, BitSet> prefixEntry : this.prefixMap.entrySet()) {
                String prefix = prefixEntry.getKey();
                BitSet prefixSet = prefixEntry.getValue();
                for (Map.Entry<String, BitSet> suffixEntry : this.suffixMap.entrySet()) {
                    String suffix = suffixEntry.getKey();
                    BitSet suffixSet = suffixEntry.getValue();
                    parsePosition.setIndex(startIndex);
                    if (GeneralMeasureFormat.looseMatches(prefix, toParse, parsePosition)) {
                        Number number = numberFormat.parse(toParse, parsePosition);
                        if (parsePosition.getErrorIndex() >= 0) {
                            if (furthestError >= parsePosition.getErrorIndex()) continue;
                            furthestError = parsePosition.getErrorIndex();
                            continue;
                        }
                        if (GeneralMeasureFormat.looseMatches(suffix, toParse, parsePosition) && prefixSet.intersects(suffixSet)) {
                            if (longestMatch >= parsePosition.getIndex()) continue;
                            longestMatch = parsePosition.getIndex();
                            bestNumber = number;
                            bestUnit = GeneralMeasureFormat.getFirst(prefixSet, suffixSet);
                            continue;
                        }
                        if (furthestError >= parsePosition.getErrorIndex()) continue;
                        furthestError = parsePosition.getErrorIndex();
                        continue;
                    }
                    if (furthestError >= parsePosition.getErrorIndex()) continue;
                    furthestError = parsePosition.getErrorIndex();
                }
            }
            if (longestMatch >= 0) {
                parsePosition.setIndex(longestMatch);
                return new Measure(bestNumber, index.getUnit(bestUnit));
            }
            parsePosition.setErrorIndex(furthestError);
            return null;
        }
    }

    static final class PatternData {
        final String prefix;
        final String suffix;

        public PatternData(String pattern) {
            int pos = pattern.indexOf("{0}");
            if (pos < 0) {
                this.prefix = pattern;
                this.suffix = null;
            } else {
                this.prefix = pattern.substring(0, pos);
                this.suffix = pattern.substring(pos + 3);
            }
        }

        public String toString() {
            return this.prefix + "; " + this.suffix;
        }
    }
}

