/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.api.ns;

import java.util.HashMap;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.GetNamespaceBuilder;
import org.projectnessie.client.api.NessieApiV2;
import org.projectnessie.client.api.UpdateNamespaceResult;
import org.projectnessie.client.builder.BaseUpdateNamespaceBuilder;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNamespaceNotFoundException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.error.NessieReferenceNotFoundException;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.CommitResponse;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.ImmutableNamespace;
import org.projectnessie.model.Namespace;
import org.projectnessie.model.Operation;

public final class ClientSideUpdateNamespace
extends BaseUpdateNamespaceBuilder {
    private final NessieApiV2 api;

    public ClientSideUpdateNamespace(NessieApiV2 api) {
        this.api = api;
    }

    @Override
    public void update() throws NessieNamespaceNotFoundException, NessieReferenceNotFoundException {
        this.updateWithResponse();
    }

    @Override
    public UpdateNamespaceResult updateWithResponse() throws NessieNamespaceNotFoundException, NessieReferenceNotFoundException {
        ContentKey key = this.namespace.toContentKey();
        Namespace oldNamespace = ((GetNamespaceBuilder)((GetNamespaceBuilder)((GetNamespaceBuilder)this.api.getNamespace().refName(this.refName)).hashOnRef(this.hashOnRef)).namespace(this.namespace)).get();
        HashMap newProperties = new HashMap(oldNamespace.getProperties());
        this.propertyRemovals.forEach(newProperties::remove);
        newProperties.putAll(this.propertyUpdates);
        ImmutableNamespace.Builder builder = Namespace.builder().from(oldNamespace).properties(newProperties);
        try {
            CommitMeta meta;
            String expectedHash = this.hashOnRef;
            if (expectedHash == null) {
                expectedHash = this.api.getReference().refName(this.refName).get().getHash();
            }
            if ((meta = this.commitMeta) == null) {
                meta = CommitMeta.fromMessage((String)("update namespace " + key));
            } else if (meta.getMessage().isEmpty()) {
                meta = CommitMeta.builder().from(meta).message("update namespace " + key).build();
            }
            ImmutableNamespace updatedNamespace = builder.build();
            CommitResponse commit = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branchName(this.refName)).hash(expectedHash)).commitMeta(meta).operation((Operation)Operation.Put.of((ContentKey)key, (Content)updatedNamespace)).commitWithResponse();
            return UpdateNamespaceResult.of((Namespace)updatedNamespace, oldNamespace, commit.getTargetBranch());
        }
        catch (NessieNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (NessieConflictException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

