/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers;

import com.sun.tools.javac.code.TypeTags;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import java.lang.annotation.Annotation;
import java.util.regex.Pattern;
import lombok.AccessLevel;
import lombok.Data;
import lombok.Getter;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.core.handlers.TransformationsUtil;
import lombok.javac.Javac;
import lombok.javac.JavacNode;
import lombok.javac.handlers.HandleGetter;

public class JavacHandlerUtil {
    private JavacHandlerUtil() {
    }

    public static boolean isPrimitive(JCTree.JCExpression ref) {
        String typeName = ref.toString();
        return TransformationsUtil.PRIMITIVE_TYPE_NAME_PATTERN.matcher(typeName).matches();
    }

    public static void deleteAnnotationIfNeccessary(JavacNode annotation, Class<? extends Annotation> annotationType) {
        if (!annotation.shouldDeleteLombokAnnotations()) {
            return;
        }
        JavacNode parentNode = (JavacNode)annotation.directUp();
        switch (parentNode.getKind()) {
            case FIELD: 
            case ARGUMENT: 
            case LOCAL: {
                JCTree.JCVariableDecl variable = (JCTree.JCVariableDecl)parentNode.get();
                variable.mods.annotations = JavacHandlerUtil.filterList(variable.mods.annotations, (JCTree)annotation.get());
                break;
            }
            case METHOD: {
                JCTree.JCMethodDecl method = (JCTree.JCMethodDecl)parentNode.get();
                method.mods.annotations = JavacHandlerUtil.filterList(method.mods.annotations, (JCTree)annotation.get());
                break;
            }
            case TYPE: {
                try {
                    JCTree.JCClassDecl type = (JCTree.JCClassDecl)parentNode.get();
                    type.mods.annotations = JavacHandlerUtil.filterList(type.mods.annotations, (JCTree)annotation.get());
                }
                catch (ClassCastException e) {}
                break;
            }
            default: {
                return;
            }
        }
        JavacHandlerUtil.deleteImportFromCompilationUnit(annotation, annotationType.getName());
    }

    public static void deleteImportFromCompilationUnit(JavacNode node, String name) {
        if (!node.shouldDeleteLombokAnnotations()) {
            return;
        }
        ListBuffer newDefs = ListBuffer.lb();
        JCTree.JCCompilationUnit unit = (JCTree.JCCompilationUnit)((JavacNode)node.top()).get();
        for (JCTree def : unit.defs) {
            boolean delete = false;
            if (def instanceof JCTree.JCImport) {
                JCTree.JCImport imp0rt = (JCTree.JCImport)def;
                boolean bl = delete = !imp0rt.staticImport && imp0rt.qualid.toString().equals(name);
            }
            if (delete) continue;
            newDefs.append(def);
        }
        unit.defs = newDefs.toList();
    }

    private static List<JCTree.JCAnnotation> filterList(List<JCTree.JCAnnotation> annotations, JCTree jcTree) {
        ListBuffer newAnnotations = ListBuffer.lb();
        for (JCTree.JCAnnotation ann : annotations) {
            if (jcTree == ann) continue;
            newAnnotations.append(ann);
        }
        return newAnnotations.toList();
    }

    public static java.util.List<String> toAllGetterNames(JCTree.JCVariableDecl field) {
        Name fieldName = field.name;
        boolean isBoolean = field.vartype.toString().equals("boolean");
        return TransformationsUtil.toAllGetterNames(fieldName, isBoolean);
    }

    public static String toGetterName(JCTree.JCVariableDecl field) {
        Name fieldName = field.name;
        boolean isBoolean = field.vartype.toString().equals("boolean");
        return TransformationsUtil.toGetterName(fieldName, isBoolean);
    }

    public static java.util.List<String> toAllSetterNames(JCTree.JCVariableDecl field) {
        Name fieldName = field.name;
        boolean isBoolean = field.vartype.toString().equals("boolean");
        return TransformationsUtil.toAllSetterNames(fieldName, isBoolean);
    }

    public static String toSetterName(JCTree.JCVariableDecl field) {
        Name fieldName = field.name;
        boolean isBoolean = field.vartype.toString().equals("boolean");
        return TransformationsUtil.toSetterName(fieldName, isBoolean);
    }

    public static MemberExistsResult fieldExists(String fieldName, JavacNode node) {
        while (node != null && !(node.get() instanceof JCTree.JCClassDecl)) {
            node = (JavacNode)node.up();
        }
        if (node != null && node.get() instanceof JCTree.JCClassDecl) {
            for (JCTree def : ((JCTree.JCClassDecl)node.get()).defs) {
                if (!(def instanceof JCTree.JCVariableDecl) || !((JCTree.JCVariableDecl)def).name.contentEquals(fieldName)) continue;
                return Javac.getGeneratedBy(def) == null ? MemberExistsResult.EXISTS_BY_USER : MemberExistsResult.EXISTS_BY_LOMBOK;
            }
        }
        return MemberExistsResult.NOT_EXISTS;
    }

    public static MemberExistsResult methodExists(String methodName, JavacNode node) {
        return JavacHandlerUtil.methodExists(methodName, node, true);
    }

    public static MemberExistsResult methodExists(String methodName, JavacNode node, boolean caseSensitive) {
        while (node != null && !(node.get() instanceof JCTree.JCClassDecl)) {
            node = (JavacNode)node.up();
        }
        if (node != null && node.get() instanceof JCTree.JCClassDecl) {
            for (JCTree def : ((JCTree.JCClassDecl)node.get()).defs) {
                if (!(def instanceof JCTree.JCMethodDecl)) continue;
                String name = ((JCTree.JCMethodDecl)def).name.toString();
                boolean matches = caseSensitive ? name.equals(methodName) : name.equalsIgnoreCase(methodName);
                if (!matches) continue;
                return Javac.getGeneratedBy(def) == null ? MemberExistsResult.EXISTS_BY_USER : MemberExistsResult.EXISTS_BY_LOMBOK;
            }
        }
        return MemberExistsResult.NOT_EXISTS;
    }

    public static MemberExistsResult constructorExists(JavacNode node) {
        while (node != null && !(node.get() instanceof JCTree.JCClassDecl)) {
            node = (JavacNode)node.up();
        }
        if (node != null && node.get() instanceof JCTree.JCClassDecl) {
            for (JCTree def : ((JCTree.JCClassDecl)node.get()).defs) {
                if (!(def instanceof JCTree.JCMethodDecl) || !((JCTree.JCMethodDecl)def).name.contentEquals("<init>") || (((JCTree.JCMethodDecl)def).mods.flags & 0x1000000000L) != 0L) continue;
                return Javac.getGeneratedBy(def) == null ? MemberExistsResult.EXISTS_BY_USER : MemberExistsResult.EXISTS_BY_LOMBOK;
            }
        }
        return MemberExistsResult.NOT_EXISTS;
    }

    public static int toJavacModifier(AccessLevel accessLevel) {
        switch (accessLevel) {
            case MODULE: 
            case PACKAGE: {
                return 0;
            }
            default: {
                return 1;
            }
            case NONE: 
            case PRIVATE: {
                return 2;
            }
            case PROTECTED: 
        }
        return 4;
    }

    private static GetterMethod findGetter(JavacNode field) {
        JavacNode containingType;
        JCTree.JCVariableDecl decl = (JCTree.JCVariableDecl)field.get();
        JavacNode typeNode = (JavacNode)field.up();
        for (String potentialGetterName : JavacHandlerUtil.toAllGetterNames(decl)) {
            for (JavacNode potentialGetter : typeNode.down()) {
                if (potentialGetter.getKind() != AST.Kind.METHOD) continue;
                JCTree.JCMethodDecl method = (JCTree.JCMethodDecl)potentialGetter.get();
                if (!method.name.toString().equalsIgnoreCase(potentialGetterName) || (method.mods.flags & 8L) != 0L || method.params != null && method.params.size() > 0) continue;
                return new GetterMethod(method.name, method.restype);
            }
        }
        boolean hasGetterAnnotation = false;
        for (JavacNode child : field.down()) {
            if (child.getKind() != AST.Kind.ANNOTATION || !Javac.annotationTypeMatches(Getter.class, child)) continue;
            AnnotationValues<Getter> ann = Javac.createAnnotation(Getter.class, child);
            if (ann.getInstance().value() == AccessLevel.NONE) {
                return null;
            }
            hasGetterAnnotation = true;
        }
        if (!hasGetterAnnotation && new HandleGetter().fieldQualifiesForGetterGeneration(field) && (containingType = (JavacNode)field.up()) != null) {
            for (JavacNode child : containingType.down()) {
                if (child.getKind() == AST.Kind.ANNOTATION && Javac.annotationTypeMatches(Data.class, child)) {
                    hasGetterAnnotation = true;
                }
                if (child.getKind() != AST.Kind.ANNOTATION || !Javac.annotationTypeMatches(Getter.class, child)) continue;
                AnnotationValues<Getter> ann = Javac.createAnnotation(Getter.class, child);
                if (ann.getInstance().value() == AccessLevel.NONE) {
                    return null;
                }
                hasGetterAnnotation = true;
            }
        }
        if (hasGetterAnnotation) {
            String getterName = JavacHandlerUtil.toGetterName(decl);
            return new GetterMethod(field.toName(getterName), decl.vartype);
        }
        return null;
    }

    static boolean lookForGetter(JavacNode field, FieldAccess fieldAccess) {
        if (fieldAccess == FieldAccess.GETTER) {
            return true;
        }
        if (fieldAccess == FieldAccess.ALWAYS_FIELD) {
            return false;
        }
        for (JavacNode child : field.down()) {
            AnnotationValues<Getter> ann;
            if (child.getKind() != AST.Kind.ANNOTATION || !Javac.annotationTypeMatches(Getter.class, child) || !(ann = Javac.createAnnotation(Getter.class, child)).getInstance().lazy()) continue;
            return true;
        }
        return false;
    }

    static JCTree.JCExpression getFieldType(JavacNode field, FieldAccess fieldAccess) {
        GetterMethod getter;
        boolean lookForGetter = JavacHandlerUtil.lookForGetter(field, fieldAccess);
        GetterMethod getterMethod = getter = lookForGetter ? JavacHandlerUtil.findGetter(field) : null;
        if (getter == null) {
            return ((JCTree.JCVariableDecl)field.get()).vartype;
        }
        return getter.type;
    }

    static JCTree.JCExpression createFieldAccessor(TreeMaker maker, JavacNode field, FieldAccess fieldAccess) {
        return JavacHandlerUtil.createFieldAccessor(maker, field, fieldAccess, null);
    }

    static JCTree.JCExpression createFieldAccessor(TreeMaker maker, JavacNode field, FieldAccess fieldAccess, JCTree.JCExpression receiver) {
        boolean lookForGetter = JavacHandlerUtil.lookForGetter(field, fieldAccess);
        GetterMethod getter = lookForGetter ? JavacHandlerUtil.findGetter(field) : null;
        JCTree.JCVariableDecl fieldDecl = (JCTree.JCVariableDecl)field.get();
        if (getter == null) {
            if (receiver == null) {
                if ((fieldDecl.mods.flags & 8L) == 0L) {
                    receiver = maker.Ident(field.toName("this"));
                } else {
                    JavacNode containerNode = (JavacNode)field.up();
                    if (containerNode != null && containerNode.get() instanceof JCTree.JCClassDecl) {
                        JCTree.JCClassDecl container = (JCTree.JCClassDecl)((JavacNode)field.up()).get();
                        receiver = maker.Ident(container.name);
                    }
                }
            }
            return receiver == null ? maker.Ident(fieldDecl.name) : maker.Select(receiver, fieldDecl.name);
        }
        if (receiver == null) {
            receiver = maker.Ident(field.toName("this"));
        }
        JCTree.JCMethodInvocation call = maker.Apply(List.<JCTree.JCExpression>nil(), maker.Select(receiver, getter.name), List.<JCTree.JCExpression>nil());
        return call;
    }

    public static void injectFieldSuppressWarnings(JavacNode typeNode, JCTree.JCVariableDecl field) {
        JavacHandlerUtil.injectField(typeNode, field, true);
    }

    public static void injectField(JavacNode typeNode, JCTree.JCVariableDecl field) {
        JavacHandlerUtil.injectField(typeNode, field, false);
    }

    private static void injectField(JavacNode typeNode, JCTree.JCVariableDecl field, boolean addSuppressWarnings) {
        JCTree.JCClassDecl type = (JCTree.JCClassDecl)typeNode.get();
        if (addSuppressWarnings) {
            JavacHandlerUtil.addSuppressWarningsAll(field.mods, typeNode, field.pos, Javac.getGeneratedBy(field));
        }
        type.defs = type.defs.append(field);
        typeNode.add(field, AST.Kind.FIELD);
    }

    public static void injectMethod(JavacNode typeNode, JCTree.JCMethodDecl method) {
        JCTree.JCClassDecl type = (JCTree.JCClassDecl)typeNode.get();
        if (method.getName().contentEquals("<init>")) {
            int idx = 0;
            for (JCTree def : type.defs) {
                if (def instanceof JCTree.JCMethodDecl && (((JCTree.JCMethodDecl)def).mods.flags & 0x1000000000L) != 0L) {
                    JavacNode tossMe = (JavacNode)typeNode.getNodeFor(def);
                    if (tossMe != null) {
                        ((JavacNode)tossMe.up()).removeChild(tossMe);
                    }
                    type.defs = JavacHandlerUtil.addAllButOne(type.defs, idx);
                    break;
                }
                ++idx;
            }
        }
        JavacHandlerUtil.addSuppressWarningsAll(method.mods, typeNode, method.pos, Javac.getGeneratedBy(method));
        type.defs = type.defs.append(method);
        typeNode.add(method, AST.Kind.METHOD);
    }

    private static void addSuppressWarningsAll(JCTree.JCModifiers mods, JavacNode node, int pos, JCTree source) {
        TreeMaker maker = node.getTreeMaker();
        JCTree.JCExpression suppressWarningsType = JavacHandlerUtil.chainDots(maker, node, "java", "lang", "SuppressWarnings");
        JCTree.JCLiteral allLiteral = maker.Literal("all");
        suppressWarningsType.pos = pos;
        allLiteral.pos = pos;
        JCTree.JCAnnotation annotation = Javac.recursiveSetGeneratedBy(maker.Annotation(suppressWarningsType, List.of(allLiteral)), source);
        annotation.pos = pos;
        mods.annotations = mods.annotations.append(annotation);
    }

    private static List<JCTree> addAllButOne(List<JCTree> defs, int idx) {
        ListBuffer out = ListBuffer.lb();
        int i = 0;
        for (JCTree def : defs) {
            if (i++ == idx) continue;
            out.append(def);
        }
        return out.toList();
    }

    public static JCTree.JCExpression chainDots(TreeMaker maker, JavacNode node, String ... elems) {
        assert (elems != null);
        assert (elems.length > 0);
        JCTree.JCExpression e = maker.Ident(node.toName(elems[0]));
        for (int i = 1; i < elems.length; ++i) {
            e = maker.Select(e, node.toName(elems[i]));
        }
        return e;
    }

    public static JCTree.JCExpression chainDotsString(TreeMaker maker, JavacNode node, String elems) {
        return JavacHandlerUtil.chainDots(maker, node, elems.split("\\."));
    }

    public static List<JCTree.JCAnnotation> findAnnotations(JavacNode fieldNode, Pattern namePattern) {
        ListBuffer result = ListBuffer.lb();
        for (JavacNode child : fieldNode.down()) {
            if (child.getKind() != AST.Kind.ANNOTATION) continue;
            JCTree.JCAnnotation annotation = (JCTree.JCAnnotation)child.get();
            String name = annotation.annotationType.toString();
            int idx = name.lastIndexOf(".");
            String suspect = idx == -1 ? name : name.substring(idx + 1);
            if (!namePattern.matcher(suspect).matches()) continue;
            result.append(annotation);
        }
        return result.toList();
    }

    public static JCTree.JCStatement generateNullCheck(TreeMaker treeMaker, JavacNode variable) {
        JCTree.JCVariableDecl varDecl = (JCTree.JCVariableDecl)variable.get();
        if (JavacHandlerUtil.isPrimitive(varDecl.vartype)) {
            return null;
        }
        Name fieldName = varDecl.name;
        JCTree.JCExpression npe = JavacHandlerUtil.chainDots(treeMaker, variable, "java", "lang", "NullPointerException");
        JCTree.JCNewClass exception = treeMaker.NewClass(null, List.<JCTree.JCExpression>nil(), npe, List.of(treeMaker.Literal(fieldName.toString())), null);
        JCTree.JCThrow throwStatement = treeMaker.Throw(exception);
        return treeMaker.If(treeMaker.Binary(Javac.getCTCint(JCTree.class, "EQ"), treeMaker.Ident(fieldName), treeMaker.Literal(Javac.getCTCint(TypeTags.class, "BOT"), null)), throwStatement, null);
    }

    public static List<Integer> createListOfNonExistentFields(List<String> list, JavacNode type, boolean excludeStandard, boolean excludeTransient) {
        boolean[] matched = new boolean[list.size()];
        for (JavacNode child : type.down()) {
            int idx;
            if (list.isEmpty()) break;
            if (child.getKind() != AST.Kind.FIELD) continue;
            JCTree.JCVariableDecl field = (JCTree.JCVariableDecl)child.get();
            if (excludeStandard && ((field.mods.flags & 8L) != 0L || field.name.toString().startsWith("$")) || excludeTransient && (field.mods.flags & 0x80L) != 0L || (idx = list.indexOf(child.getName())) <= -1) continue;
            matched[idx] = true;
        }
        ListBuffer problematic = ListBuffer.lb();
        for (int i = 0; i < list.size(); ++i) {
            if (matched[i]) continue;
            problematic.append(i);
        }
        return problematic.toList();
    }

    static List<JCTree.JCExpression> getAndRemoveAnnotationParameter(JCTree.JCAnnotation ast, String parameterName) {
        ListBuffer params = ListBuffer.lb();
        List<JCTree.JCExpression> result = List.nil();
        for (JCTree.JCExpression param : ast.args) {
            if (param instanceof JCTree.JCAssign) {
                JCTree.JCAssign assign = (JCTree.JCAssign)param;
                if (assign.lhs instanceof JCTree.JCIdent) {
                    JCTree.JCIdent ident = (JCTree.JCIdent)assign.lhs;
                    if (parameterName.equals(ident.name.toString())) {
                        if (assign.rhs instanceof JCTree.JCNewArray) {
                            result = ((JCTree.JCNewArray)assign.rhs).elems;
                            continue;
                        }
                        result = result.append(assign.rhs);
                        continue;
                    }
                }
            }
            params.append(param);
        }
        ast.args = params.toList();
        return result;
    }

    static List<JCTree.JCAnnotation> copyAnnotations(List<JCTree.JCExpression> in) {
        ListBuffer out = ListBuffer.lb();
        for (JCTree.JCExpression expr : in) {
            if (!(expr instanceof JCTree.JCAnnotation)) continue;
            out.append((JCTree.JCAnnotation)expr.clone());
        }
        return out.toList();
    }

    static enum FieldAccess {
        GETTER,
        PREFER_FIELD,
        ALWAYS_FIELD;

    }

    private static class GetterMethod {
        private final Name name;
        private final JCTree.JCExpression type;

        GetterMethod(Name name, JCTree.JCExpression type) {
            this.name = name;
            this.type = type;
        }
    }

    public static enum MemberExistsResult {
        NOT_EXISTS,
        EXISTS_BY_USER,
        EXISTS_BY_LOMBOK;

    }
}

