/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.NoArgsConstructor;
import lombok.RequiredArgsConstructor;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.core.handlers.TransformationsUtil;
import lombok.javac.Javac;
import lombok.javac.JavacAnnotationHandler;
import lombok.javac.JavacNode;
import lombok.javac.handlers.JavacHandlerUtil;

public class HandleConstructor {
    private static List<JavacNode> findRequiredFields(JavacNode typeNode) {
        ListBuffer fields = ListBuffer.lb();
        for (JavacNode child : typeNode.down()) {
            boolean isNonNull;
            long fieldFlags;
            if (child.getKind() != AST.Kind.FIELD) continue;
            JCTree.JCVariableDecl fieldDecl = (JCTree.JCVariableDecl)child.get();
            if (fieldDecl.name.toString().startsWith("$") || ((fieldFlags = fieldDecl.mods.flags) & 8L) != 0L) continue;
            boolean isFinal = (fieldFlags & 0x10L) != 0L;
            boolean bl = isNonNull = !JavacHandlerUtil.findAnnotations(child, TransformationsUtil.NON_NULL_PATTERN).isEmpty();
            if (!isFinal && !isNonNull || fieldDecl.init != null) continue;
            fields.append(child);
        }
        return fields.toList();
    }

    static boolean checkLegality(JavacNode typeNode, JavacNode errorNode, String name) {
        boolean notAClass;
        JCTree.JCClassDecl typeDecl = null;
        if (typeNode.get() instanceof JCTree.JCClassDecl) {
            typeDecl = (JCTree.JCClassDecl)typeNode.get();
        }
        long modifiers = typeDecl == null ? 0L : typeDecl.mods.flags;
        boolean bl = notAClass = (modifiers & 0x2200L) != 0L;
        if (typeDecl == null || notAClass) {
            errorNode.addError(name + " is only supported on a class or an enum.");
            return false;
        }
        return true;
    }

    public void generateRequiredArgsConstructor(JavacNode typeNode, AccessLevel level, String staticName, boolean skipIfConstructorExists, JavacNode source) {
        this.generateConstructor(typeNode, level, HandleConstructor.findRequiredFields(typeNode), staticName, List.<JCTree.JCExpression>nil(), skipIfConstructorExists, false, source);
    }

    public void generateConstructor(JavacNode typeNode, AccessLevel level, List<JavacNode> fields, String staticName, List<JCTree.JCExpression> onConstructor, boolean skipIfConstructorExists, boolean suppressConstructorProperties, JavacNode source) {
        if (skipIfConstructorExists && JavacHandlerUtil.constructorExists(typeNode) != JavacHandlerUtil.MemberExistsResult.NOT_EXISTS) {
            return;
        }
        if (skipIfConstructorExists) {
            for (JavacNode child : typeNode.down()) {
                if (child.getKind() != AST.Kind.ANNOTATION || !Javac.annotationTypeMatches(NoArgsConstructor.class, child) && !Javac.annotationTypeMatches(AllArgsConstructor.class, child) && !Javac.annotationTypeMatches(RequiredArgsConstructor.class, child)) continue;
                return;
            }
        }
        boolean staticConstrRequired = staticName != null && !staticName.equals("");
        JCTree.JCMethodDecl constr = this.createConstructor(staticConstrRequired ? AccessLevel.PRIVATE : level, typeNode, fields, onConstructor, suppressConstructorProperties, (JCTree)source.get());
        JavacHandlerUtil.injectMethod(typeNode, constr);
        if (staticConstrRequired) {
            JCTree.JCMethodDecl staticConstr = this.createStaticConstructor(staticName, level, typeNode, fields, (JCTree)source.get());
            JavacHandlerUtil.injectMethod(typeNode, staticConstr);
        }
    }

    private static void addConstructorProperties(JCTree.JCModifiers mods, JavacNode node, List<JavacNode> fields) {
        if (fields.isEmpty()) {
            return;
        }
        TreeMaker maker = node.getTreeMaker();
        JCTree.JCExpression constructorPropertiesType = JavacHandlerUtil.chainDots(maker, node, "java", "beans", "ConstructorProperties");
        ListBuffer fieldNames = ListBuffer.lb();
        for (JavacNode field : fields) {
            fieldNames.append(maker.Literal(field.getName()));
        }
        JCTree.JCNewArray fieldNamesArray = maker.NewArray(null, List.<JCTree.JCExpression>nil(), fieldNames.toList());
        JCTree.JCAnnotation annotation = maker.Annotation(constructorPropertiesType, List.of(fieldNamesArray));
        mods.annotations = mods.annotations.append(annotation);
    }

    private JCTree.JCMethodDecl createConstructor(AccessLevel level, JavacNode typeNode, List<JavacNode> fields, List<JCTree.JCExpression> onConstructor, boolean suppressConstructorProperties, JCTree source) {
        boolean isEnum;
        TreeMaker maker = typeNode.getTreeMaker();
        boolean bl = isEnum = (((JCTree.JCClassDecl)typeNode.get()).mods.flags & 0x4000L) != 0L;
        if (isEnum) {
            level = AccessLevel.PRIVATE;
        }
        ListBuffer nullChecks = ListBuffer.lb();
        ListBuffer assigns = ListBuffer.lb();
        ListBuffer params = ListBuffer.lb();
        for (JavacNode fieldNode : fields) {
            JCTree.JCStatement nullCheck;
            JCTree.JCVariableDecl field = (JCTree.JCVariableDecl)fieldNode.get();
            List<JCTree.JCAnnotation> nonNulls = JavacHandlerUtil.findAnnotations(fieldNode, TransformationsUtil.NON_NULL_PATTERN);
            List<JCTree.JCAnnotation> nullables = JavacHandlerUtil.findAnnotations(fieldNode, TransformationsUtil.NULLABLE_PATTERN);
            JCTree.JCVariableDecl param = maker.VarDef(maker.Modifiers(16L, nonNulls.appendList(nullables)), field.name, field.vartype, null);
            params.append(param);
            JCTree.JCFieldAccess thisX = maker.Select((JCTree.JCExpression)maker.Ident(fieldNode.toName("this")), field.name);
            JCTree.JCAssign assign = maker.Assign(thisX, maker.Ident(field.name));
            assigns.append(maker.Exec(assign));
            if (nonNulls.isEmpty() || (nullCheck = JavacHandlerUtil.generateNullCheck(maker, fieldNode)) == null) continue;
            nullChecks.append(nullCheck);
        }
        List<JCTree.JCAnnotation> annsOnConstructor = JavacHandlerUtil.copyAnnotations(onConstructor);
        JCTree.JCModifiers mods = maker.Modifiers(JavacHandlerUtil.toJavacModifier(level), annsOnConstructor);
        if (!suppressConstructorProperties && level != AccessLevel.PRIVATE && !this.isLocalType(typeNode)) {
            HandleConstructor.addConstructorProperties(mods, typeNode, fields);
        }
        return Javac.recursiveSetGeneratedBy(maker.MethodDef(mods, typeNode.toName("<init>"), null, List.<JCTree.JCTypeParameter>nil(), params.toList(), List.<JCTree.JCExpression>nil(), maker.Block(0L, nullChecks.appendList(assigns).toList()), null), source);
    }

    private boolean isLocalType(JavacNode type) {
        AST.Kind kind = ((JavacNode)type.up()).getKind();
        if (kind == AST.Kind.COMPILATION_UNIT) {
            return false;
        }
        if (kind == AST.Kind.TYPE) {
            return this.isLocalType((JavacNode)type.up());
        }
        return true;
    }

    private JCTree.JCMethodDecl createStaticConstructor(String name, AccessLevel level, JavacNode typeNode, List<JavacNode> fields, JCTree source) {
        JCTree.JCExpression constructorType;
        JCTree.JCExpression returnType;
        TreeMaker maker = typeNode.getTreeMaker();
        JCTree.JCClassDecl type = (JCTree.JCClassDecl)typeNode.get();
        JCTree.JCModifiers mods = maker.Modifiers(8 | JavacHandlerUtil.toJavacModifier(level));
        ListBuffer typeParams = ListBuffer.lb();
        ListBuffer params = ListBuffer.lb();
        ListBuffer typeArgs1 = ListBuffer.lb();
        ListBuffer typeArgs2 = ListBuffer.lb();
        ListBuffer args = ListBuffer.lb();
        if (!type.typarams.isEmpty()) {
            for (JCTree.JCTypeParameter param : type.typarams) {
                typeArgs1.append(maker.Ident(param.name));
                typeArgs2.append(maker.Ident(param.name));
                typeParams.append(maker.TypeParameter(param.name, param.bounds));
            }
            returnType = maker.TypeApply(maker.Ident(type.name), typeArgs1.toList());
            constructorType = maker.TypeApply(maker.Ident(type.name), typeArgs2.toList());
        } else {
            returnType = maker.Ident(type.name);
            constructorType = maker.Ident(type.name);
        }
        for (JavacNode fieldNode : fields) {
            JCTree.JCExpression pType;
            JCTree.JCVariableDecl field = (JCTree.JCVariableDecl)fieldNode.get();
            if (field.vartype instanceof JCTree.JCIdent) {
                pType = maker.Ident(((JCTree.JCIdent)field.vartype).name);
            } else if (field.vartype instanceof JCTree.JCTypeApply) {
                JCTree.JCTypeApply typeApply = (JCTree.JCTypeApply)field.vartype;
                ListBuffer tArgs = ListBuffer.lb();
                for (JCTree.JCExpression arg : typeApply.arguments) {
                    tArgs.append(arg);
                }
                pType = maker.TypeApply(typeApply.clazz, tArgs.toList());
            } else {
                pType = field.vartype;
            }
            List<JCTree.JCAnnotation> nonNulls = JavacHandlerUtil.findAnnotations(fieldNode, TransformationsUtil.NON_NULL_PATTERN);
            List<JCTree.JCAnnotation> nullables = JavacHandlerUtil.findAnnotations(fieldNode, TransformationsUtil.NULLABLE_PATTERN);
            JCTree.JCVariableDecl param = maker.VarDef(maker.Modifiers(16L, nonNulls.appendList(nullables)), field.name, pType, null);
            params.append(param);
            args.append(maker.Ident(field.name));
        }
        JCTree.JCReturn returnStatement = maker.Return(maker.NewClass(null, List.<JCTree.JCExpression>nil(), constructorType, args.toList(), null));
        JCTree.JCBlock body = maker.Block(0L, List.of(returnStatement));
        return Javac.recursiveSetGeneratedBy(maker.MethodDef(mods, typeNode.toName(name), returnType, typeParams.toList(), params.toList(), List.<JCTree.JCExpression>nil(), body, null), source);
    }

    public static class HandleAllArgsConstructor
    extends JavacAnnotationHandler<AllArgsConstructor> {
        @Override
        public void handle(AnnotationValues<AllArgsConstructor> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
            JavacHandlerUtil.deleteAnnotationIfNeccessary(annotationNode, AllArgsConstructor.class);
            JavacHandlerUtil.deleteImportFromCompilationUnit(annotationNode, "lombok.AccessLevel");
            JavacNode typeNode = (JavacNode)annotationNode.up();
            if (!HandleConstructor.checkLegality(typeNode, annotationNode, AllArgsConstructor.class.getSimpleName())) {
                return;
            }
            AllArgsConstructor ann = annotation.getInstance();
            AccessLevel level = ann.access();
            String staticName = ann.staticName();
            boolean suppressConstructorProperties = ann.suppressConstructorProperties();
            if (level == AccessLevel.NONE) {
                return;
            }
            ListBuffer fields = ListBuffer.lb();
            for (JavacNode child : typeNode.down()) {
                long fieldFlags;
                if (child.getKind() != AST.Kind.FIELD) continue;
                JCTree.JCVariableDecl fieldDecl = (JCTree.JCVariableDecl)child.get();
                if (fieldDecl.name.toString().startsWith("$") || ((fieldFlags = fieldDecl.mods.flags) & 8L) != 0L || (fieldFlags & 0x10L) != 0L && fieldDecl.init != null) continue;
                fields.append(child);
            }
            List<JCTree.JCExpression> onConstructor = JavacHandlerUtil.getAndRemoveAnnotationParameter(ast, "onConstructor");
            new HandleConstructor().generateConstructor(typeNode, level, fields.toList(), staticName, onConstructor, false, suppressConstructorProperties, annotationNode);
        }
    }

    public static class HandleRequiredArgsConstructor
    extends JavacAnnotationHandler<RequiredArgsConstructor> {
        @Override
        public void handle(AnnotationValues<RequiredArgsConstructor> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
            JavacHandlerUtil.deleteAnnotationIfNeccessary(annotationNode, RequiredArgsConstructor.class);
            JavacHandlerUtil.deleteImportFromCompilationUnit(annotationNode, "lombok.AccessLevel");
            JavacNode typeNode = (JavacNode)annotationNode.up();
            if (!HandleConstructor.checkLegality(typeNode, annotationNode, RequiredArgsConstructor.class.getSimpleName())) {
                return;
            }
            RequiredArgsConstructor ann = annotation.getInstance();
            AccessLevel level = ann.access();
            String staticName = ann.staticName();
            boolean suppressConstructorProperties = ann.suppressConstructorProperties();
            if (level == AccessLevel.NONE) {
                return;
            }
            List<JCTree.JCExpression> onConstructor = JavacHandlerUtil.getAndRemoveAnnotationParameter(ast, "onConstructor");
            new HandleConstructor().generateConstructor(typeNode, level, HandleConstructor.findRequiredFields(typeNode), staticName, onConstructor, false, suppressConstructorProperties, annotationNode);
        }
    }

    public static class HandleNoArgsConstructor
    extends JavacAnnotationHandler<NoArgsConstructor> {
        @Override
        public void handle(AnnotationValues<NoArgsConstructor> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
            JavacHandlerUtil.deleteAnnotationIfNeccessary(annotationNode, NoArgsConstructor.class);
            JavacHandlerUtil.deleteImportFromCompilationUnit(annotationNode, "lombok.AccessLevel");
            JavacNode typeNode = (JavacNode)annotationNode.up();
            if (!HandleConstructor.checkLegality(typeNode, annotationNode, NoArgsConstructor.class.getSimpleName())) {
                return;
            }
            NoArgsConstructor ann = annotation.getInstance();
            AccessLevel level = ann.access();
            String staticName = ann.staticName();
            if (level == AccessLevel.NONE) {
                return;
            }
            List<JavacNode> fields = List.nil();
            List<JCTree.JCExpression> onConstructor = JavacHandlerUtil.getAndRemoveAnnotationParameter(ast, "onConstructor");
            new HandleConstructor().generateConstructor(typeNode, level, fields, staticName, onConstructor, false, false, annotationNode);
        }
    }
}

