/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.apt;

import com.sun.tools.javac.file.JavacFileManager;
import java.lang.reflect.Method;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import lombok.core.DiagnosticsReceiver;
import lombok.javac.apt.EmptyLombokFileObject;
import lombok.javac.apt.InterceptingJavaFileObject;
import lombok.javac.apt.Javac6BaseFileObjectWrapper;
import lombok.javac.apt.Javac7BaseFileObjectWrapper;
import lombok.javac.apt.LombokFileObject;

final class LombokFileObjects {
    private static final Compiler compiler;
    private static final Method decoderMethod;

    private LombokFileObjects() {
    }

    static JavaFileObject createEmpty(JavaFileManager fileManager, String name, JavaFileObject.Kind kind) {
        return compiler.wrap(fileManager, new EmptyLombokFileObject(name, kind));
    }

    static JavaFileObject createIntercepting(JavaFileManager fileManager, JavaFileObject delegate, String fileName, DiagnosticsReceiver diagnostics) {
        return compiler.wrap(fileManager, new InterceptingJavaFileObject(delegate, fileName, diagnostics, decoderMethod));
    }

    static {
        Compiler c = null;
        Method m = null;
        try {
            Class<?> clazz = Class.forName("com.sun.tools.javac.util.BaseFileObject");
            c = Compiler.JAVAC6;
            try {
                m = clazz.getDeclaredMethod("getDecoder", Boolean.TYPE);
            }
            catch (NoSuchMethodException e) {}
        }
        catch (ClassNotFoundException cnfe) {
            try {
                Class<?> clazz = Class.forName("com.sun.tools.javac.file.BaseFileObject");
                c = Compiler.JAVAC7;
                try {
                    m = clazz.getDeclaredMethod("getDecoder", Boolean.TYPE);
                }
                catch (NoSuchMethodException e) {}
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        compiler = c;
        if (m != null) {
            m.setAccessible(true);
        }
        decoderMethod = m;
    }

    private static enum Compiler {
        JAVAC6{

            @Override
            public JavaFileObject wrap(JavaFileManager fileManager, LombokFileObject fileObject) {
                return new Javac6BaseFileObjectWrapper(fileObject);
            }
        }
        ,
        JAVAC7{

            @Override
            public JavaFileObject wrap(JavaFileManager fileManager, LombokFileObject fileObject) {
                return new Javac7BaseFileObjectWrapper((JavacFileManager)fileManager, fileObject);
            }
        };


        abstract JavaFileObject wrap(JavaFileManager var1, LombokFileObject var2);
    }
}

