/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Options;
import java.util.ArrayList;
import javax.annotation.processing.Messager;
import lombok.javac.HandlerLibrary;
import lombok.javac.JavacAST;
import lombok.javac.JavacASTAdapter;
import lombok.javac.JavacNode;
import lombok.javac.LombokOptions;

public class JavacTransformer {
    private final HandlerLibrary handlers;
    private final Messager messager;

    public JavacTransformer(Messager messager) {
        this.messager = messager;
        this.handlers = HandlerLibrary.load(messager);
    }

    public void transform(boolean postResolution, Context context, java.util.List<JCTree.JCCompilationUnit> compilationUnitsRaw) {
        Options options;
        List<JCTree.JCCompilationUnit> compilationUnits;
        if (compilationUnitsRaw instanceof List) {
            compilationUnits = (List<JCTree.JCCompilationUnit>)compilationUnitsRaw;
        } else {
            compilationUnits = List.nil();
            for (int i = compilationUnitsRaw.size() - 1; i >= 0; --i) {
                compilationUnits = compilationUnits.prepend(compilationUnitsRaw.get(i));
            }
        }
        ArrayList<JavacAST> asts = new ArrayList<JavacAST>();
        for (JCTree.JCCompilationUnit unit : compilationUnits) {
            asts.add(new JavacAST(this.messager, context, unit));
        }
        if (!postResolution) {
            this.handlers.setPreResolutionPhase();
            for (JavacAST ast : asts) {
                ast.traverse(new AnnotationVisitor());
                this.handlers.callASTVisitors(ast);
            }
        }
        if (postResolution) {
            this.handlers.setPostResolutionPhase();
            for (JavacAST ast : asts) {
                ast.traverse(new AnnotationVisitor());
                this.handlers.callASTVisitors(ast);
            }
            this.handlers.setPrintASTPhase();
            for (JavacAST ast : asts) {
                ast.traverse(new AnnotationVisitor());
            }
        }
        if ((options = context.get(Options.optionsKey)) instanceof LombokOptions) {
            for (JavacAST ast : asts) {
                if (!ast.isChanged()) continue;
                ((LombokOptions)options).changed.add((JCTree.JCCompilationUnit)((JavacNode)ast.top()).get());
            }
        }
    }

    private class AnnotationVisitor
    extends JavacASTAdapter {
        private AnnotationVisitor() {
        }

        @Override
        public void visitAnnotationOnType(JCTree.JCClassDecl type, JavacNode annotationNode, JCTree.JCAnnotation annotation) {
            JCTree.JCCompilationUnit top = (JCTree.JCCompilationUnit)((JavacNode)annotationNode.top()).get();
            JavacTransformer.this.handlers.handleAnnotation(top, annotationNode, annotation);
        }

        @Override
        public void visitAnnotationOnField(JCTree.JCVariableDecl field, JavacNode annotationNode, JCTree.JCAnnotation annotation) {
            JCTree.JCCompilationUnit top = (JCTree.JCCompilationUnit)((JavacNode)annotationNode.top()).get();
            JavacTransformer.this.handlers.handleAnnotation(top, annotationNode, annotation);
        }

        @Override
        public void visitAnnotationOnMethod(JCTree.JCMethodDecl method, JavacNode annotationNode, JCTree.JCAnnotation annotation) {
            JCTree.JCCompilationUnit top = (JCTree.JCCompilationUnit)((JavacNode)annotationNode.top()).get();
            JavacTransformer.this.handlers.handleAnnotation(top, annotationNode, annotation);
        }

        @Override
        public void visitAnnotationOnMethodArgument(JCTree.JCVariableDecl argument, JCTree.JCMethodDecl method, JavacNode annotationNode, JCTree.JCAnnotation annotation) {
            JCTree.JCCompilationUnit top = (JCTree.JCCompilationUnit)((JavacNode)annotationNode.top()).get();
            JavacTransformer.this.handlers.handleAnnotation(top, annotationNode, annotation);
        }

        @Override
        public void visitAnnotationOnLocal(JCTree.JCVariableDecl local, JavacNode annotationNode, JCTree.JCAnnotation annotation) {
            JCTree.JCCompilationUnit top = (JCTree.JCCompilationUnit)((JavacNode)annotationNode.top()).get();
            JavacTransformer.this.handlers.handleAnnotation(top, annotationNode, annotation);
        }
    }
}

