/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac;

import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import lombok.Lombok;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.core.TypeLibrary;
import lombok.core.TypeResolver;
import lombok.javac.JavacNode;

public class Javac {
    private static Map<JCTree, JCTree> generatedNodes = new WeakHashMap<JCTree, JCTree>();

    private Javac() {
    }

    public static boolean annotationTypeMatches(Class<? extends Annotation> type, JavacNode node) {
        if (node.getKind() != AST.Kind.ANNOTATION) {
            return false;
        }
        return Javac.typeMatches(type, node, ((JCTree.JCAnnotation)node.get()).annotationType);
    }

    public static boolean typeMatches(Class<?> type, JavacNode node, JCTree typeNode) {
        String typeName = typeNode.toString();
        TypeLibrary library = new TypeLibrary();
        library.addType(type.getName());
        TypeResolver resolver = new TypeResolver(library, node.getPackageDeclaration(), node.getImportStatements());
        Collection<String> typeMatches = resolver.findTypeMatches(node, typeName);
        for (String match : typeMatches) {
            if (!match.equals(type.getName())) continue;
            return true;
        }
        return false;
    }

    public static <A extends Annotation> AnnotationValues<A> createAnnotation(Class<A> type, final JavacNode node) {
        HashMap<String, AnnotationValues.AnnotationValue> values = new HashMap<String, AnnotationValues.AnnotationValue>();
        JCTree.JCAnnotation anno = (JCTree.JCAnnotation)node.get();
        java.util.List arguments = anno.getArguments();
        for (Method m : type.getDeclaredMethods()) {
            if (!Modifier.isPublic(m.getModifiers())) continue;
            String name = m.getName();
            ArrayList<String> raws = new ArrayList<String>();
            ArrayList<Object> guesses = new ArrayList<Object>();
            ArrayList<JCTree.JCExpression> expressions = new ArrayList<JCTree.JCExpression>();
            final ArrayList<JCDiagnostic.DiagnosticPosition> positions = new ArrayList<JCDiagnostic.DiagnosticPosition>();
            boolean isExplicit = false;
            for (JCTree.JCExpression arg : arguments) {
                JCTree.JCExpression rhs;
                String mName;
                if (arg instanceof JCTree.JCAssign) {
                    JCTree.JCAssign assign = (JCTree.JCAssign)arg;
                    mName = assign.lhs.toString();
                    rhs = assign.rhs;
                } else {
                    rhs = arg;
                    mName = "value";
                }
                if (!mName.equals(name)) continue;
                isExplicit = true;
                if (rhs instanceof JCTree.JCNewArray) {
                    List<JCTree.JCExpression> elems = ((JCTree.JCNewArray)rhs).elems;
                    for (JCTree.JCExpression inner : elems) {
                        raws.add(inner.toString());
                        expressions.add(inner);
                        guesses.add(Javac.calculateGuess(inner));
                        positions.add(inner.pos());
                    }
                    continue;
                }
                raws.add(rhs.toString());
                expressions.add(rhs);
                guesses.add(Javac.calculateGuess(rhs));
                positions.add(rhs.pos());
            }
            values.put(name, new AnnotationValues.AnnotationValue(node, raws, expressions, guesses, isExplicit){

                @Override
                public void setError(String message, int valueIdx) {
                    if (valueIdx < 0) {
                        node.addError(message);
                    } else {
                        node.addError(message, (JCDiagnostic.DiagnosticPosition)positions.get(valueIdx));
                    }
                }

                @Override
                public void setWarning(String message, int valueIdx) {
                    if (valueIdx < 0) {
                        node.addWarning(message);
                    } else {
                        node.addWarning(message, (JCDiagnostic.DiagnosticPosition)positions.get(valueIdx));
                    }
                }
            });
        }
        return new AnnotationValues<A>(type, values, node);
    }

    private static Object calculateGuess(JCTree.JCExpression expr) {
        if (expr instanceof JCTree.JCLiteral) {
            JCTree.JCLiteral lit = (JCTree.JCLiteral)expr;
            if (lit.getKind() == Tree.Kind.BOOLEAN_LITERAL) {
                return ((Number)lit.value).intValue() != 0;
            }
            return lit.value;
        }
        if (expr instanceof JCTree.JCIdent || expr instanceof JCTree.JCFieldAccess) {
            String x = expr.toString();
            if (x.endsWith(".class")) {
                x = x.substring(0, x.length() - 6);
            } else {
                int idx = x.lastIndexOf(46);
                if (idx > -1) {
                    x = x.substring(idx + 1);
                }
            }
            return x;
        }
        return null;
    }

    public static int getCTCint(Class<?> ctcLocation, String identifier) {
        try {
            return (Integer)ctcLocation.getField(identifier).get(null);
        }
        catch (NoSuchFieldException e) {
            throw Lombok.sneakyThrow(e);
        }
        catch (IllegalAccessException e) {
            throw Lombok.sneakyThrow(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JCTree getGeneratedBy(JCTree node) {
        Map<JCTree, JCTree> map = generatedNodes;
        synchronized (map) {
            return generatedNodes.get(node);
        }
    }

    public static boolean isGenerated(JCTree node) {
        return Javac.getGeneratedBy(node) != null;
    }

    public static <T extends JCTree> T recursiveSetGeneratedBy(T node, JCTree source) {
        Javac.setGeneratedBy(node, source);
        node.accept(new MarkingScanner(source));
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends JCTree> T setGeneratedBy(T node, JCTree source) {
        Map<JCTree, JCTree> map = generatedNodes;
        synchronized (map) {
            if (source == null) {
                generatedNodes.remove(node);
            } else {
                generatedNodes.put(node, source);
            }
        }
        return node;
    }

    private static class MarkingScanner
    extends TreeScanner {
        private final JCTree source;

        MarkingScanner(JCTree source) {
            this.source = source;
        }

        @Override
        public void scan(JCTree tree) {
            Javac.setGeneratedBy(tree, this.source);
            super.scan(tree);
        }
    }
}

