/*
 * Decompiled with CFR 0.152.
 */
package lombok.eclipse.handlers;

import java.util.ArrayList;
import java.util.List;
import lombok.SneakyThrows;
import lombok.core.AnnotationValues;
import lombok.eclipse.Eclipse;
import lombok.eclipse.EclipseAnnotationHandler;
import lombok.eclipse.EclipseNode;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.ThrowStatement;
import org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandleSneakyThrows
extends EclipseAnnotationHandler<SneakyThrows> {
    @Override
    public boolean deferUntilPostDiet() {
        return true;
    }

    @Override
    public void handle(AnnotationValues<SneakyThrows> annotation, Annotation source, EclipseNode annotationNode) {
        List<String> exceptionNames = annotation.getRawExpressions("value");
        ArrayList<DeclaredException> exceptions = new ArrayList<DeclaredException>();
        MemberValuePair[] memberValuePairs = source.memberValuePairs();
        if (memberValuePairs == null || memberValuePairs.length == 0) {
            exceptions.add(new DeclaredException("java.lang.Throwable", (ASTNode)source));
        } else {
            Expression arrayOrSingle = memberValuePairs[0].value;
            Expression[] exceptionNameNodes = arrayOrSingle instanceof ArrayInitializer ? ((ArrayInitializer)arrayOrSingle).expressions : new Expression[]{arrayOrSingle};
            if (exceptionNames.size() != exceptionNameNodes.length) {
                annotationNode.addError("LOMBOK BUG: The number of exception classes in the annotation isn't the same pre- and post- guessing.");
            }
            int idx = 0;
            for (String exceptionName : exceptionNames) {
                if (exceptionName.endsWith(".class")) {
                    exceptionName = exceptionName.substring(0, exceptionName.length() - 6);
                }
                exceptions.add(new DeclaredException(exceptionName, (ASTNode)exceptionNameNodes[idx++]));
            }
        }
        EclipseNode owner = (EclipseNode)annotationNode.up();
        switch (owner.getKind()) {
            case METHOD: {
                this.handleMethod(annotationNode, (AbstractMethodDeclaration)owner.get(), exceptions);
                break;
            }
            default: {
                annotationNode.addError("@SneakyThrows is legal only on methods and constructors.");
            }
        }
    }

    private void handleMethod(EclipseNode annotation, AbstractMethodDeclaration method, List<DeclaredException> exceptions) {
        if (method.isAbstract()) {
            annotation.addError("@SneakyThrows can only be used on concrete methods.");
            return;
        }
        if (method.statements == null) {
            return;
        }
        Statement[] contents = method.statements;
        for (DeclaredException exception : exceptions) {
            contents = new Statement[]{this.buildTryCatchBlock(contents, exception, exception.node)};
        }
        method.statements = contents;
        ((EclipseNode)annotation.up()).rebuild();
    }

    private Statement buildTryCatchBlock(Statement[] contents, DeclaredException exception, ASTNode source) {
        SingleTypeReference typeReference;
        long p = exception.getPos();
        int pS = (int)(p >> 32);
        int pE = (int)p;
        TryStatement tryStatement = new TryStatement();
        Eclipse.setGeneratedBy((ASTNode)tryStatement, source);
        tryStatement.tryBlock = new Block(0);
        tryStatement.tryBlock.sourceStart = pS;
        tryStatement.tryBlock.sourceEnd = pE;
        Eclipse.setGeneratedBy((ASTNode)tryStatement.tryBlock, source);
        tryStatement.tryBlock.statements = contents;
        if (exception.exceptionName.indexOf(46) == -1) {
            typeReference = new SingleTypeReference(exception.exceptionName.toCharArray(), p);
            typeReference.statementEnd = pE;
        } else {
            String[] x = exception.exceptionName.split("\\.");
            char[][] elems = new char[x.length][];
            long[] poss = new long[x.length];
            int start = pS;
            for (int i = 0; i < x.length; ++i) {
                elems[i] = x[i].trim().toCharArray();
                int end = start + x[i].length();
                poss[i] = (long)start << 32 | (long)end;
                start = end + 1;
            }
            typeReference = new QualifiedTypeReference((char[][])elems, poss);
        }
        Eclipse.setGeneratedBy((ASTNode)typeReference, source);
        Argument catchArg = new Argument("$ex".toCharArray(), p, (TypeReference)typeReference, 16);
        Eclipse.setGeneratedBy((ASTNode)catchArg, source);
        catchArg.declarationEnd = catchArg.sourceEnd = pE;
        catchArg.declarationSourceEnd = catchArg.sourceEnd;
        catchArg.modifiersSourceStart = catchArg.sourceStart = pS;
        catchArg.declarationSourceStart = catchArg.sourceStart;
        tryStatement.catchArguments = new Argument[]{catchArg};
        MessageSend sneakyThrowStatement = new MessageSend();
        Eclipse.setGeneratedBy((ASTNode)sneakyThrowStatement, source);
        sneakyThrowStatement.receiver = new QualifiedNameReference((char[][])new char[][]{"lombok".toCharArray(), "Lombok".toCharArray()}, new long[]{p, p}, pS, pE);
        Eclipse.setGeneratedBy((ASTNode)sneakyThrowStatement.receiver, source);
        sneakyThrowStatement.receiver.statementEnd = pE;
        sneakyThrowStatement.selector = "sneakyThrow".toCharArray();
        SingleNameReference exRef = new SingleNameReference("$ex".toCharArray(), p);
        Eclipse.setGeneratedBy((ASTNode)exRef, source);
        exRef.statementEnd = pE;
        sneakyThrowStatement.arguments = new Expression[]{exRef};
        sneakyThrowStatement.nameSourcePosition = p;
        sneakyThrowStatement.sourceStart = pS;
        sneakyThrowStatement.sourceEnd = sneakyThrowStatement.statementEnd = pE;
        ThrowStatement rethrowStatement = new ThrowStatement((Expression)sneakyThrowStatement, pS, pE);
        Eclipse.setGeneratedBy((ASTNode)rethrowStatement, source);
        Block block = new Block(0);
        block.sourceStart = pS;
        block.sourceEnd = pE;
        Eclipse.setGeneratedBy((ASTNode)block, source);
        block.statements = new Statement[]{rethrowStatement};
        tryStatement.catchBlocks = new Block[]{block};
        tryStatement.sourceStart = pS;
        tryStatement.sourceEnd = pE;
        return tryStatement;
    }

    private static class DeclaredException {
        final String exceptionName;
        final ASTNode node;

        DeclaredException(String exceptionName, ASTNode node) {
            this.exceptionName = exceptionName;
            this.node = node;
        }

        public long getPos() {
            return (long)this.node.sourceStart << 32 | (long)this.node.sourceEnd;
        }
    }
}

