/*
 * Decompiled with CFR 0.152.
 */
package lombok.eclipse.handlers;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import lombok.AccessLevel;
import lombok.Data;
import lombok.Getter;
import lombok.Lombok;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.core.handlers.TransformationsUtil;
import lombok.eclipse.Eclipse;
import lombok.eclipse.EclipseNode;
import lombok.eclipse.handlers.HandleGetter;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Clinit;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.EqualExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.IfStatement;
import org.eclipse.jdt.internal.compiler.ast.MarkerAnnotation;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.NormalAnnotation;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleMemberAnnotation;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.ast.ThrowStatement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseHandlerUtil {
    private static final char[] ALL = "all".toCharArray();
    private static final String PRIMITIVE_NAMES = " int long float double char short byte boolean ";
    private static final Constructor<CastExpression> castExpressionConstructor;
    private static final boolean castExpressionConstructorIsTypeRefBased;
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY;

    private EclipseHandlerUtil() {
    }

    public static boolean isPrimitive(TypeReference ref) {
        if (ref.dimensions() > 0) {
            return false;
        }
        return TransformationsUtil.PRIMITIVE_TYPE_NAME_PATTERN.matcher(Eclipse.toQualifiedName(ref.getTypeName())).matches();
    }

    public static int toEclipseModifier(AccessLevel value) {
        switch (value) {
            case MODULE: 
            case PACKAGE: {
                return 0;
            }
            default: {
                return 1;
            }
            case PROTECTED: {
                return 4;
            }
            case NONE: 
            case PRIVATE: 
        }
        return 2;
    }

    private static GetterMethod findGetter(EclipseNode field) {
        EclipseNode containingType;
        TypeReference fieldType = ((FieldDeclaration)field.get()).type;
        boolean isBoolean = EclipseHandlerUtil.nameEquals(fieldType.getTypeName(), "boolean") && fieldType.dimensions() == 0;
        EclipseNode typeNode = (EclipseNode)field.up();
        for (String potentialGetterName : TransformationsUtil.toAllGetterNames(field.getName(), isBoolean)) {
            for (EclipseNode potentialGetter : typeNode.down()) {
                if (potentialGetter.getKind() != AST.Kind.METHOD || !(potentialGetter.get() instanceof MethodDeclaration)) continue;
                MethodDeclaration method = (MethodDeclaration)potentialGetter.get();
                if (!potentialGetterName.equalsIgnoreCase(new String(method.selector)) || (method.modifiers & 8) != 0 || method.arguments != null && method.arguments.length > 0) continue;
                return new GetterMethod(method.selector, method.returnType);
            }
        }
        boolean hasGetterAnnotation = false;
        for (EclipseNode child : field.down()) {
            if (child.getKind() != AST.Kind.ANNOTATION || !Eclipse.annotationTypeMatches(Getter.class, child)) continue;
            AnnotationValues<Getter> ann = Eclipse.createAnnotation(Getter.class, child);
            if (ann.getInstance().value() == AccessLevel.NONE) {
                return null;
            }
            hasGetterAnnotation = true;
        }
        if (!hasGetterAnnotation && new HandleGetter().fieldQualifiesForGetterGeneration(field) && (containingType = (EclipseNode)field.up()) != null) {
            for (EclipseNode child : containingType.down()) {
                if (child.getKind() == AST.Kind.ANNOTATION && Eclipse.annotationTypeMatches(Data.class, child)) {
                    hasGetterAnnotation = true;
                }
                if (child.getKind() != AST.Kind.ANNOTATION || !Eclipse.annotationTypeMatches(Getter.class, child)) continue;
                AnnotationValues<Getter> ann = Eclipse.createAnnotation(Getter.class, child);
                if (ann.getInstance().value() == AccessLevel.NONE) {
                    return null;
                }
                hasGetterAnnotation = true;
            }
        }
        if (hasGetterAnnotation) {
            String getterName = TransformationsUtil.toGetterName(field.getName(), isBoolean);
            return new GetterMethod(getterName.toCharArray(), fieldType);
        }
        return null;
    }

    static boolean lookForGetter(EclipseNode field, FieldAccess fieldAccess) {
        if (fieldAccess == FieldAccess.GETTER) {
            return true;
        }
        if (fieldAccess == FieldAccess.ALWAYS_FIELD) {
            return false;
        }
        for (EclipseNode child : field.down()) {
            AnnotationValues<Getter> ann;
            if (child.getKind() != AST.Kind.ANNOTATION || !Eclipse.annotationTypeMatches(Getter.class, child) || !(ann = Eclipse.createAnnotation(Getter.class, child)).getInstance().lazy()) continue;
            return true;
        }
        return false;
    }

    static TypeReference getFieldType(EclipseNode field, FieldAccess fieldAccess) {
        GetterMethod getter;
        boolean lookForGetter = EclipseHandlerUtil.lookForGetter(field, fieldAccess);
        GetterMethod getterMethod = getter = lookForGetter ? EclipseHandlerUtil.findGetter(field) : null;
        if (getter == null) {
            return ((FieldDeclaration)field.get()).type;
        }
        return getter.type;
    }

    /*
     * Enabled aggressive block sorting
     */
    static Expression createFieldAccessor(EclipseNode field, FieldAccess fieldAccess, ASTNode source) {
        FieldReference ref;
        block4: {
            GetterMethod getter;
            int pS = source.sourceStart;
            int pE = source.sourceEnd;
            long p = (long)pS << 32 | (long)pE;
            boolean lookForGetter = EclipseHandlerUtil.lookForGetter(field, fieldAccess);
            GetterMethod getterMethod = getter = lookForGetter ? EclipseHandlerUtil.findGetter(field) : null;
            if (getter != null) {
                MessageSend call = new MessageSend();
                Eclipse.setGeneratedBy((ASTNode)call, source);
                call.sourceStart = pS;
                call.sourceEnd = pE;
                call.receiver = new ThisReference(pS, pE);
                Eclipse.setGeneratedBy((ASTNode)call.receiver, source);
                call.selector = getter.name;
                return call;
            }
            FieldDeclaration fieldDecl = (FieldDeclaration)field.get();
            ref = new FieldReference(fieldDecl.name, p);
            if ((fieldDecl.modifiers & 8) != 0) {
                EclipseNode containerNode = (EclipseNode)field.up();
                if (containerNode != null && containerNode.get() instanceof TypeDeclaration) {
                    ref.receiver = new SingleNameReference(((TypeDeclaration)containerNode.get()).name, p);
                    break block4;
                } else {
                    FieldReference smallRef = new FieldReference(field.getName().toCharArray(), p);
                    Eclipse.setGeneratedBy((ASTNode)smallRef, source);
                    return smallRef;
                }
            }
            ref.receiver = new ThisReference(pS, pE);
        }
        Eclipse.setGeneratedBy((ASTNode)ref, source);
        Eclipse.setGeneratedBy((ASTNode)ref.receiver, source);
        return ref;
    }

    static Expression createFieldAccessor(EclipseNode field, FieldAccess fieldAccess, ASTNode source, char[] receiver) {
        GetterMethod getter;
        int pS = source.sourceStart;
        int pE = source.sourceEnd;
        long p = (long)pS << 32 | (long)pE;
        boolean lookForGetter = EclipseHandlerUtil.lookForGetter(field, fieldAccess);
        GetterMethod getterMethod = getter = lookForGetter ? EclipseHandlerUtil.findGetter(field) : null;
        if (getter == null) {
            char[][] tokens = new char[][]{receiver, field.getName().toCharArray()};
            long[] poss = new long[]{p, p};
            QualifiedNameReference ref = new QualifiedNameReference((char[][])tokens, poss, pS, pE);
            Eclipse.setGeneratedBy((ASTNode)ref, source);
            return ref;
        }
        MessageSend call = new MessageSend();
        Eclipse.setGeneratedBy((ASTNode)call, source);
        call.sourceStart = pS;
        call.sourceEnd = pE;
        call.receiver = new SingleNameReference(receiver, p);
        Eclipse.setGeneratedBy((ASTNode)call.receiver, source);
        call.selector = getter.name;
        return call;
    }

    public static boolean nameEquals(char[][] typeName, String string) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (char[] elem : typeName) {
            if (first) {
                first = false;
            } else {
                sb.append('.');
            }
            sb.append(elem);
        }
        return string.contentEquals(sb);
    }

    public static boolean filterField(FieldDeclaration declaration) {
        if (declaration.initialization instanceof AllocationExpression && ((AllocationExpression)declaration.initialization).enumConstant != null) {
            return false;
        }
        if (declaration.type == null) {
            return false;
        }
        if (declaration.name.length > 0 && declaration.name[0] == '$') {
            return false;
        }
        return (declaration.modifiers & 8) == 0;
    }

    public static MemberExistsResult fieldExists(String fieldName, EclipseNode node) {
        while (node != null && !(node.get() instanceof TypeDeclaration)) {
            node = (EclipseNode)node.up();
        }
        if (node != null && node.get() instanceof TypeDeclaration) {
            TypeDeclaration typeDecl = (TypeDeclaration)node.get();
            if (typeDecl.fields != null) {
                for (FieldDeclaration def : typeDecl.fields) {
                    char[] fName = def.name;
                    if (fName == null || !fieldName.equals(new String(fName))) continue;
                    return Eclipse.getGeneratedBy((ASTNode)def) == null ? MemberExistsResult.EXISTS_BY_USER : MemberExistsResult.EXISTS_BY_LOMBOK;
                }
            }
        }
        return MemberExistsResult.NOT_EXISTS;
    }

    public static MemberExistsResult methodExists(String methodName, EclipseNode node) {
        return EclipseHandlerUtil.methodExists(methodName, node, true);
    }

    public static MemberExistsResult methodExists(String methodName, EclipseNode node, boolean caseSensitive) {
        while (node != null && !(node.get() instanceof TypeDeclaration)) {
            node = (EclipseNode)node.up();
        }
        if (node != null && node.get() instanceof TypeDeclaration) {
            TypeDeclaration typeDecl = (TypeDeclaration)node.get();
            if (typeDecl.methods != null) {
                for (AbstractMethodDeclaration def : typeDecl.methods) {
                    boolean nameEquals;
                    char[] mName;
                    if (!(def instanceof MethodDeclaration) || (mName = def.selector) == null) continue;
                    boolean bl = nameEquals = caseSensitive ? methodName.equals(new String(mName)) : methodName.equalsIgnoreCase(new String(mName));
                    if (!nameEquals) continue;
                    return Eclipse.getGeneratedBy((ASTNode)def) == null ? MemberExistsResult.EXISTS_BY_USER : MemberExistsResult.EXISTS_BY_LOMBOK;
                }
            }
        }
        return MemberExistsResult.NOT_EXISTS;
    }

    public static MemberExistsResult constructorExists(EclipseNode node) {
        while (node != null && !(node.get() instanceof TypeDeclaration)) {
            node = (EclipseNode)node.up();
        }
        if (node != null && node.get() instanceof TypeDeclaration) {
            TypeDeclaration typeDecl = (TypeDeclaration)node.get();
            if (typeDecl.methods != null) {
                for (AbstractMethodDeclaration def : typeDecl.methods) {
                    if (!(def instanceof ConstructorDeclaration) || (def.bits & 0x80) != 0) continue;
                    return Eclipse.getGeneratedBy((ASTNode)def) == null ? MemberExistsResult.EXISTS_BY_USER : MemberExistsResult.EXISTS_BY_LOMBOK;
                }
            }
        }
        return MemberExistsResult.NOT_EXISTS;
    }

    public static void injectFieldSuppressWarnings(EclipseNode type, FieldDeclaration field) {
        field.annotations = EclipseHandlerUtil.createSuppressWarningsAll((ASTNode)field, field.annotations);
        EclipseHandlerUtil.injectField(type, field);
    }

    public static void injectField(EclipseNode type, FieldDeclaration field) {
        TypeDeclaration parent = (TypeDeclaration)type.get();
        if (parent.fields == null) {
            parent.fields = new FieldDeclaration[1];
            parent.fields[0] = field;
        } else {
            FieldDeclaration[] newArray = new FieldDeclaration[parent.fields.length + 1];
            System.arraycopy(parent.fields, 0, newArray, 0, parent.fields.length);
            newArray[parent.fields.length] = field;
            parent.fields = newArray;
        }
        if ((field.modifiers & 8) != 0 && !EclipseHandlerUtil.hasClinit(parent)) {
            parent.addClinit();
        }
        type.add(field, AST.Kind.FIELD);
    }

    private static boolean hasClinit(TypeDeclaration parent) {
        if (parent.methods == null) {
            return false;
        }
        for (AbstractMethodDeclaration method : parent.methods) {
            if (!(method instanceof Clinit)) continue;
            return true;
        }
        return false;
    }

    public static void injectMethod(EclipseNode type, AbstractMethodDeclaration method) {
        method.annotations = EclipseHandlerUtil.createSuppressWarningsAll((ASTNode)method, method.annotations);
        TypeDeclaration parent = (TypeDeclaration)type.get();
        if (parent.scope != null && method.scope == null) {
            boolean report = true;
            for (StackTraceElement elem : Thread.currentThread().getStackTrace()) {
                if (!"lombok.eclipse.agent.PatchDelegate".equals(elem.getClassName())) continue;
                report = false;
                break;
            }
            if (report) {
                Eclipse.warning("We believe you may have just stumbled on lombok issue #164. Please report the stack trace associated with this message at:\nhttp://code.google.com/p/projectlombok/issues/detail?id=164", new Throwable());
            }
        }
        if (parent.methods == null) {
            parent.methods = new AbstractMethodDeclaration[1];
            parent.methods[0] = method;
        } else {
            AbstractMethodDeclaration current;
            int insertionPoint;
            if (method instanceof ConstructorDeclaration) {
                for (int i = 0; i < parent.methods.length; ++i) {
                    if (!(parent.methods[i] instanceof ConstructorDeclaration) || (parent.methods[i].bits & 0x80) == 0) continue;
                    EclipseNode tossMe = (EclipseNode)type.getNodeFor(parent.methods[i]);
                    AbstractMethodDeclaration[] withoutGeneratedConstructor = new AbstractMethodDeclaration[parent.methods.length - 1];
                    System.arraycopy(parent.methods, 0, withoutGeneratedConstructor, 0, i);
                    System.arraycopy(parent.methods, i + 1, withoutGeneratedConstructor, i, parent.methods.length - i - 1);
                    parent.methods = withoutGeneratedConstructor;
                    if (tossMe == null) break;
                    ((EclipseNode)tossMe.up()).removeChild(tossMe);
                    break;
                }
            }
            for (insertionPoint = 0; insertionPoint < parent.methods.length && ((current = parent.methods[insertionPoint]) instanceof Clinit || (method instanceof ConstructorDeclaration ? current instanceof ConstructorDeclaration : Eclipse.isGenerated((ASTNode)current))); ++insertionPoint) {
            }
            AbstractMethodDeclaration[] newArray = new AbstractMethodDeclaration[parent.methods.length + 1];
            System.arraycopy(parent.methods, 0, newArray, 0, insertionPoint);
            if (insertionPoint <= parent.methods.length) {
                System.arraycopy(parent.methods, insertionPoint, newArray, insertionPoint + 1, parent.methods.length - insertionPoint);
            }
            newArray[insertionPoint] = method;
            parent.methods = newArray;
        }
        type.add(method, AST.Kind.METHOD);
    }

    public static Annotation[] createSuppressWarningsAll(ASTNode source, Annotation[] originalAnnotationArray) {
        int pS = source.sourceStart;
        int pE = source.sourceEnd;
        long p = (long)pS << 32 | (long)pE;
        long[] poss = new long[3];
        Arrays.fill(poss, p);
        QualifiedTypeReference suppressWarningsType = new QualifiedTypeReference(TypeConstants.JAVA_LANG_SUPPRESSWARNINGS, poss);
        Eclipse.setGeneratedBy((ASTNode)suppressWarningsType, source);
        SingleMemberAnnotation ann = new SingleMemberAnnotation((TypeReference)suppressWarningsType, pS);
        ann.declarationSourceEnd = pE;
        ann.memberValue = new StringLiteral(ALL, pS, pE, 0);
        Eclipse.setGeneratedBy((ASTNode)ann, source);
        Eclipse.setGeneratedBy((ASTNode)ann.memberValue, source);
        if (originalAnnotationArray == null) {
            return new Annotation[]{ann};
        }
        Annotation[] newAnnotationArray = Arrays.copyOf(originalAnnotationArray, originalAnnotationArray.length + 1);
        newAnnotationArray[originalAnnotationArray.length] = ann;
        return newAnnotationArray;
    }

    public static Annotation[] findAnnotations(FieldDeclaration field, Pattern namePattern) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        if (field.annotations == null) {
            return new Annotation[0];
        }
        for (Annotation annotation : field.annotations) {
            char[][] typeName;
            String suspect;
            TypeReference typeRef = annotation.type;
            if (typeRef == null || typeRef.getTypeName() == null || !namePattern.matcher(suspect = new String((typeName = typeRef.getTypeName())[typeName.length - 1])).matches()) continue;
            result.add(annotation);
        }
        return result.toArray(new Annotation[0]);
    }

    public static Statement generateNullCheck(AbstractVariableDeclaration variable, ASTNode source) {
        int pS = source.sourceStart;
        int pE = source.sourceEnd;
        long p = (long)pS << 32 | (long)pE;
        if (EclipseHandlerUtil.isPrimitive(variable.type)) {
            return null;
        }
        AllocationExpression exception = new AllocationExpression();
        Eclipse.setGeneratedBy((ASTNode)exception, source);
        exception.type = new QualifiedTypeReference(Eclipse.fromQualifiedName("java.lang.NullPointerException"), new long[]{p, p, p});
        Eclipse.setGeneratedBy((ASTNode)exception.type, source);
        exception.arguments = new Expression[]{new StringLiteral(variable.name, pS, pE, 0)};
        Eclipse.setGeneratedBy((ASTNode)exception.arguments[0], source);
        ThrowStatement throwStatement = new ThrowStatement((Expression)exception, pS, pE);
        Eclipse.setGeneratedBy((ASTNode)throwStatement, source);
        SingleNameReference varName = new SingleNameReference(variable.name, p);
        Eclipse.setGeneratedBy((ASTNode)varName, source);
        NullLiteral nullLiteral = new NullLiteral(pS, pE);
        Eclipse.setGeneratedBy((ASTNode)nullLiteral, source);
        EqualExpression equalExpression = new EqualExpression((Expression)varName, (Expression)nullLiteral, 18);
        equalExpression.sourceStart = pS;
        equalExpression.sourceEnd = pE;
        Eclipse.setGeneratedBy((ASTNode)equalExpression, source);
        IfStatement ifStatement = new IfStatement((Expression)equalExpression, (Statement)throwStatement, 0, 0);
        Eclipse.setGeneratedBy((ASTNode)ifStatement, source);
        return ifStatement;
    }

    public static MarkerAnnotation makeMarkerAnnotation(char[][] name, ASTNode source) {
        long pos = (long)source.sourceStart << 32 | (long)source.sourceEnd;
        QualifiedTypeReference typeRef = new QualifiedTypeReference(name, new long[]{pos, pos, pos});
        Eclipse.setGeneratedBy((ASTNode)typeRef, source);
        MarkerAnnotation ann = new MarkerAnnotation((TypeReference)typeRef, (int)(pos >> 32));
        ann.sourceEnd = ann.statementEnd = (int)pos;
        ann.declarationSourceEnd = ann.statementEnd;
        Eclipse.setGeneratedBy((ASTNode)ann, source);
        return ann;
    }

    public static List<Integer> createListOfNonExistentFields(List<String> list, EclipseNode type, boolean excludeStandard, boolean excludeTransient) {
        boolean[] matched = new boolean[list.size()];
        for (EclipseNode child : type.down()) {
            int idx;
            if (list.isEmpty()) break;
            if (child.getKind() != AST.Kind.FIELD || excludeStandard && ((((FieldDeclaration)child.get()).modifiers & 8) != 0 || child.getName().startsWith("$")) || excludeTransient && (((FieldDeclaration)child.get()).modifiers & 0x80) != 0 || (idx = list.indexOf(child.getName())) <= -1) continue;
            matched[idx] = true;
        }
        ArrayList<Integer> problematic = new ArrayList<Integer>();
        for (int i = 0; i < list.size(); ++i) {
            if (matched[i]) continue;
            problematic.add(i);
        }
        return problematic;
    }

    public static CastExpression makeCastExpression(Expression ref, TypeReference castTo, ASTNode source) {
        CastExpression result;
        try {
            if (castExpressionConstructorIsTypeRefBased) {
                result = castExpressionConstructor.newInstance(ref, castTo);
            } else {
                TypeReference castToConverted = castTo;
                if (castTo.getClass() == SingleTypeReference.class && !PRIMITIVE_NAMES.contains(" " + new String(((SingleTypeReference)castTo).token) + " ")) {
                    SingleTypeReference str = (SingleTypeReference)castTo;
                    castToConverted = new SingleNameReference(str.token, 0L);
                    castToConverted.bits = castToConverted.bits & 0xFFFFFFFC | 4;
                    castToConverted.sourceStart = str.sourceStart;
                    castToConverted.sourceEnd = str.sourceEnd;
                    Eclipse.setGeneratedBy((ASTNode)castToConverted, source);
                } else if (castTo.getClass() == QualifiedTypeReference.class) {
                    QualifiedTypeReference qtr = (QualifiedTypeReference)castTo;
                    castToConverted = new QualifiedNameReference(qtr.tokens, qtr.sourcePositions, qtr.sourceStart, qtr.sourceEnd);
                    castToConverted.bits = castToConverted.bits & 0xFFFFFFFC | 4;
                    Eclipse.setGeneratedBy((ASTNode)castToConverted, source);
                }
                result = castExpressionConstructor.newInstance(ref, castToConverted);
            }
        }
        catch (InvocationTargetException e) {
            throw Lombok.sneakyThrow(e.getCause());
        }
        catch (IllegalAccessException e) {
            throw Lombok.sneakyThrow(e);
        }
        catch (InstantiationException e) {
            throw Lombok.sneakyThrow(e);
        }
        Eclipse.setGeneratedBy((ASTNode)result, source);
        return result;
    }

    static Annotation[] getAndRemoveAnnotationParameter(Annotation annotation, String annotationName) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        if (annotation instanceof NormalAnnotation) {
            NormalAnnotation normalAnnotation = (NormalAnnotation)annotation;
            MemberValuePair[] memberValuePairs = normalAnnotation.memberValuePairs;
            ArrayList<MemberValuePair> pairs = new ArrayList<MemberValuePair>();
            if (memberValuePairs != null) {
                for (MemberValuePair memberValuePair : memberValuePairs) {
                    if (annotationName.equals(new String(memberValuePair.name))) {
                        Expression value = memberValuePair.value;
                        if (value instanceof ArrayInitializer) {
                            ArrayInitializer array = (ArrayInitializer)value;
                            for (Expression expression : array.expressions) {
                                if (!(expression instanceof Annotation)) continue;
                                result.add((Annotation)expression);
                            }
                            continue;
                        }
                        if (!(value instanceof Annotation)) continue;
                        result.add((Annotation)value);
                        continue;
                    }
                    pairs.add(memberValuePair);
                }
            }
            if (!result.isEmpty()) {
                normalAnnotation.memberValuePairs = pairs.isEmpty() ? null : pairs.toArray(new MemberValuePair[0]);
                return result.toArray(EMPTY_ANNOTATION_ARRAY);
            }
        }
        return EMPTY_ANNOTATION_ARRAY;
    }

    static NameReference createNameReference(String name, Annotation source) {
        int pS = source.sourceStart;
        int pE = source.sourceEnd;
        long p = (long)pS << 32 | (long)pE;
        char[][] nameTokens = Eclipse.fromQualifiedName(name);
        long[] pos = new long[nameTokens.length];
        Arrays.fill(pos, p);
        QualifiedNameReference nameReference = new QualifiedNameReference(nameTokens, pos, pS, pE);
        nameReference.statementEnd = pE;
        Eclipse.setGeneratedBy((ASTNode)nameReference, (ASTNode)source);
        return nameReference;
    }

    static {
        Constructor<?> constructor = null;
        for (Constructor<?> ctor : CastExpression.class.getConstructors()) {
            if (ctor.getParameterTypes().length != 2) continue;
            constructor = ctor;
        }
        Constructor<?> constructor_ = constructor;
        castExpressionConstructor = constructor_;
        castExpressionConstructorIsTypeRefBased = castExpressionConstructor.getParameterTypes()[1] == TypeReference.class;
        EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MemberExistsResult {
        NOT_EXISTS,
        EXISTS_BY_USER,
        EXISTS_BY_LOMBOK;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum FieldAccess {
        GETTER,
        PREFER_FIELD,
        ALWAYS_FIELD;

    }

    private static class GetterMethod {
        private final char[] name;
        private final TypeReference type;

        GetterMethod(char[] name, TypeReference type) {
            this.name = name;
            this.type = type;
        }
    }
}

