/*
 * Decompiled with CFR 0.152.
 */
package lombok.eclipse;

import java.lang.reflect.Field;
import lombok.eclipse.Eclipse;
import lombok.eclipse.EclipseAST;
import lombok.eclipse.EclipseASTAdapter;
import lombok.eclipse.EclipseNode;
import lombok.eclipse.HandlerLibrary;
import lombok.patcher.Symbols;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.parser.Parser;

public class TransformEclipseAST {
    private final EclipseAST ast;
    private static final Field astCacheField;
    private static final HandlerLibrary handlers;
    public static boolean disableLombok;

    public static void transform_swapped(CompilationUnitDeclaration ast, Parser parser) {
        TransformEclipseAST.transform(parser, ast);
    }

    public static EclipseAST getAST(CompilationUnitDeclaration ast, boolean forceRebuild) {
        EclipseAST existing = null;
        if (astCacheField != null) {
            try {
                existing = (EclipseAST)astCacheField.get(ast);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (existing == null) {
            existing = new EclipseAST(ast);
            if (astCacheField != null) {
                try {
                    astCacheField.set(ast, existing);
                }
                catch (Exception exception) {}
            }
        } else {
            existing.rebuild(forceRebuild);
        }
        return existing;
    }

    public static void transform(Parser parser, CompilationUnitDeclaration ast) {
        if (disableLombok) {
            return;
        }
        if (Symbols.hasSymbol("lombok.disable")) {
            return;
        }
        try {
            EclipseAST existing = TransformEclipseAST.getAST(ast, false);
            new TransformEclipseAST(existing).go();
        }
        catch (Throwable t) {
            try {
                String message = "Lombok can't parse this source: " + t.toString();
                EclipseAST.addProblemToCompilationResult(ast, false, message, 0, 0);
                t.printStackTrace();
            }
            catch (Throwable t2) {
                try {
                    Eclipse.error(ast, "Can't create an error in the problems dialog while adding: " + t.toString(), t2);
                }
                catch (Throwable t3) {
                    disableLombok = true;
                }
            }
        }
    }

    public TransformEclipseAST(EclipseAST ast) {
        this.ast = ast;
    }

    public void go() {
        handlers.skipPrintAST();
        this.ast.traverse(new AnnotationVisitor());
        handlers.callASTVisitors(this.ast);
        handlers.skipAllButPrintAST();
        this.ast.traverse(new AnnotationVisitor());
    }

    static {
        disableLombok = false;
        Field f = null;
        HandlerLibrary h = null;
        try {
            h = HandlerLibrary.load();
        }
        catch (Throwable t) {
            try {
                Eclipse.error(null, "Problem initializing lombok", t);
            }
            catch (Throwable t2) {
                System.err.println("Problem initializing lombok");
                t.printStackTrace();
            }
            disableLombok = true;
        }
        try {
            f = CompilationUnitDeclaration.class.getDeclaredField("$lombokAST");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        astCacheField = f;
        handlers = h;
    }

    private static class AnnotationVisitor
    extends EclipseASTAdapter {
        private AnnotationVisitor() {
        }

        public boolean deferUntilPostDiet() {
            return false;
        }

        public void visitAnnotationOnField(FieldDeclaration field, EclipseNode annotationNode, Annotation annotation) {
            CompilationUnitDeclaration top = (CompilationUnitDeclaration)((EclipseNode)annotationNode.top()).get();
            handlers.handleAnnotation(top, annotationNode, annotation);
        }

        public void visitAnnotationOnMethodArgument(Argument arg, AbstractMethodDeclaration method, EclipseNode annotationNode, Annotation annotation) {
            CompilationUnitDeclaration top = (CompilationUnitDeclaration)((EclipseNode)annotationNode.top()).get();
            handlers.handleAnnotation(top, annotationNode, annotation);
        }

        public void visitAnnotationOnLocal(LocalDeclaration local, EclipseNode annotationNode, Annotation annotation) {
            CompilationUnitDeclaration top = (CompilationUnitDeclaration)((EclipseNode)annotationNode.top()).get();
            handlers.handleAnnotation(top, annotationNode, annotation);
        }

        public void visitAnnotationOnMethod(AbstractMethodDeclaration method, EclipseNode annotationNode, Annotation annotation) {
            CompilationUnitDeclaration top = (CompilationUnitDeclaration)((EclipseNode)annotationNode.top()).get();
            handlers.handleAnnotation(top, annotationNode, annotation);
        }

        public void visitAnnotationOnType(TypeDeclaration type, EclipseNode annotationNode, Annotation annotation) {
            CompilationUnitDeclaration top = (CompilationUnitDeclaration)((EclipseNode)annotationNode.top()).get();
            handlers.handleAnnotation(top, annotationNode, annotation);
        }
    }
}

