/*
 * Decompiled with CFR 0.152.
 */
package lombok.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import lombok.core.AST;
import lombok.core.LombokNode;
import lombok.core.TypeLibrary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeResolver {
    private final TypeLibrary library;
    private Collection<String> imports;

    public TypeResolver(TypeLibrary library, String packageString, Collection<String> importStrings) {
        this.library = library;
        this.imports = TypeResolver.makeImportList(packageString, importStrings);
    }

    private static Collection<String> makeImportList(String packageString, Collection<String> importStrings) {
        HashSet<String> imports = new HashSet<String>();
        if (packageString != null) {
            imports.add(packageString + ".*");
        }
        imports.addAll(importStrings == null ? Collections.emptySet() : importStrings);
        return imports;
    }

    public Collection<String> findTypeMatches(LombokNode<?, ?, ?> context, String typeRef) {
        Collection<String> potentialMatches = this.library.findCompatible(typeRef);
        if (potentialMatches.isEmpty()) {
            return Collections.emptyList();
        }
        int idx = typeRef.indexOf(46);
        if (idx > -1) {
            return potentialMatches;
        }
        String simpleName = typeRef.substring(idx + 1);
        if (this.nameConflictInImportList(simpleName, potentialMatches)) {
            return Collections.emptyList();
        }
        if ((potentialMatches = this.eliminateImpossibleMatches(potentialMatches)).isEmpty()) {
            return Collections.emptyList();
        }
        for (LombokNode<Object, Object, Object> n = context; n != null; n = n.up()) {
            String name;
            if (n.getKind() != AST.Kind.TYPE || (name = n.getName()) == null || !name.equals(simpleName)) continue;
            return Collections.emptyList();
        }
        return potentialMatches;
    }

    private Collection<String> eliminateImpossibleMatches(Collection<String> potentialMatches) {
        HashSet<String> results = new HashSet<String>();
        for (String importedType : this.imports) {
            HashSet<String> reduced = new HashSet<String>(this.library.findCompatible(importedType));
            reduced.retainAll(potentialMatches);
            results.addAll(reduced);
        }
        return results;
    }

    private boolean nameConflictInImportList(String simpleName, Collection<String> potentialMatches) {
        for (String importedType : this.imports) {
            if (!TypeResolver.toSimpleName(importedType).equals(simpleName) || potentialMatches.contains(importedType)) continue;
            return true;
        }
        return false;
    }

    private static String toSimpleName(String typeName) {
        int idx = typeName.lastIndexOf(46);
        return idx == -1 ? typeName : typeName.substring(idx + 1);
    }
}

