
/*
 * Copyright (c) 2011-2022 PrimeFaces Extensions
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */

package org.primefaces.extensions.model.monacoeditor;

import org.primefaces.shaded.json.*;
import java.io.ObjectStreamException;
import java.io.Serializable;

// ============================================================
// THIS FILE WAS GENERATED AUTOMATICALLY. DO NOT EDIT DIRECTLY.
// ============================================================

/**
 * Configuration options for editor drop into behavior
 */
@SuppressWarnings("serial")
public class EditorDropIntoEditorOptions extends JSONObject implements Serializable {
    private Object writeReplace() throws ObjectStreamException {
        return new SerializedEditorDropIntoEditorOptions(this);
    }

    private static class SerializedEditorDropIntoEditorOptions implements Serializable {
        private String json;

        public SerializedEditorDropIntoEditorOptions(EditorDropIntoEditorOptions editorDropIntoEditorOptions) {
            this.json = editorDropIntoEditorOptions.toString();
        }

        private Object readResolve() throws ObjectStreamException {
            final EditorDropIntoEditorOptions editorDropIntoEditorOptions = new EditorDropIntoEditorOptions();
            final JSONObject data = new JSONObject(json);
            for (final String key : data.keySet()) {
                final Object value = data.get(key);
                editorDropIntoEditorOptions.put(key, value);
            }
            return editorDropIntoEditorOptions;
        }
    }

    /**
     * @return Enable the dropping into editor. Defaults to {@code true}.
     */
    public Boolean isEnabled() {
        return (Boolean) (has("enabled") ? get("enabled") : null);
    }

    /**
     * @param enabled Enable the dropping into editor. Defaults to {@code true}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorDropIntoEditorOptions setEnabled(final Boolean enabled) {
        put("enabled", enabled);
        return this;
    }

    /**
     * @return Controls if a widget is shown after a drop. Defaults to {@code afterDrop}.
     */
    public String getShowDropSelector() {
        return (String) (has("showDropSelector") ? get("showDropSelector") : null);
    }

    /**
     * @param showDropSelector Controls if a widget is shown after a drop. Defaults to {@code afterDrop}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorDropIntoEditorOptions setShowDropSelector(final EShowDropSelectorMode showDropSelector) {
        put("showDropSelector", showDropSelector != null ? showDropSelector.toString() : null);
        return this;
    }

    /**
     * @param showDropSelector Controls if a widget is shown after a drop. Defaults to {@code afterDrop}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorDropIntoEditorOptions setShowDropSelector(final String showDropSelector) {
        put("showDropSelector", showDropSelector);
        return this;
    }

    /**
     * @return This options object as a serializable JSON object
     */
    JSONObject getJSONObject() {
        return this;
    }
}