/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.timeago;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import org.primefaces.component.api.Widget;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LocaleUtils;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces-extensions", name="primefaces-extensions.js"), @ResourceDependency(library="primefaces-extensions", name="timeago/timeago.js")})
public class TimeAgo
extends UIComponentBase
implements Widget {
    public static final String COMPONENT_TYPE = "org.primefaces.extensions.component.TimeAgo";
    public static final String COMPONENT_FAMILY = "org.primefaces.extensions.component";
    public static final String DEFAULT_RENDERER = "org.primefaces.extensions.component.TimeAgoRenderer";
    public static final String STYLE_CLASS = "ui-timeago ui-widget";
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    private static final List<String> BUNDLED_LOCALES = Arrays.asList("af", "am", "ar", "az", "be", "bg", "bs", "ca", "cs", "cy", "da", "de", "dv", "el", "en", "es", "et", "eu", "fa", "fi", "fr", "gl", "he", "hr", "hu", "hy", "id", "is", "it", "ja", "jv", "ko", "ky", "lt", "lv", "mk", "nl", "no", "pl", "pt-br", "pt", "ro", "rs", "ru", "rw", "si", "sk", "sl", "sq", "sr", "sv", "th", "tr", "uk", "ur", "uz", "vi", "zh-cn", "zh-tw");
    private Locale appropriateLocale;

    public TimeAgo() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public Object getValue() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.value), null);
    }

    public void setValue(String value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.value), (Object)value);
    }

    public String getWidgetVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.widgetVar), null);
    }

    public void setWidgetVar(String widgetVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.widgetVar), (Object)widgetVar);
    }

    public String getStyle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.style), null);
    }

    public void setStyle(String style) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.style), (Object)style);
    }

    public String getStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.styleClass), null);
    }

    public void setStyleClass(String styleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.styleClass), (Object)styleClass);
    }

    public Object getLocale() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.locale), null);
    }

    public void setLocale(Object locale) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.locale), locale);
    }

    public String getTitlePattern() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.titlePattern), null);
    }

    public void setTitlePattern(String titlePattern) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.titlePattern), (Object)titlePattern);
    }

    public String resolveWidgetVar() {
        return ComponentUtils.resolveWidgetVar((FacesContext)this.getFacesContext(), (Widget)this);
    }

    public Locale calculateLocale() {
        if (this.appropriateLocale == null) {
            this.appropriateLocale = LocaleUtils.resolveLocale((Object)this.getLocale(), (String)this.getClientId(FacesContext.getCurrentInstance()));
        }
        return this.appropriateLocale;
    }

    public final String getBundledLocale() {
        Locale locale = this.calculateLocale();
        String bundledLocale = locale.getLanguage() + "-" + locale.getCountry().toLowerCase();
        if (BUNDLED_LOCALES.contains(bundledLocale)) {
            return bundledLocale;
        }
        if (BUNDLED_LOCALES.contains(locale.getLanguage())) {
            return locale.getLanguage();
        }
        return null;
    }

    public final String formattedForJs() {
        return this.format(DATE_FORMAT, TimeZone.getTimeZone("UTC"));
    }

    public final String formattedForTitle() {
        return this.format(this.getTitlePattern(), TimeZone.getDefault());
    }

    protected String format(String pattern, TimeZone timeZone) {
        return this.format((Date)this.getValue(), pattern, timeZone);
    }

    protected String format(Date value, String pattern, TimeZone timeZone) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern, this.calculateLocale());
        sdf.setTimeZone(timeZone);
        return sdf.format(value);
    }

    public static enum PropertyKeys {
        value,
        widgetVar,
        style,
        styleClass,
        locale,
        titlePattern;

    }
}

